/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat.geotiff;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.esa.s3tbx.dataio.landsat.geotiff.CollectionMSSLandsatQA;
import org.esa.s3tbx.dataio.landsat.geotiff.CollectionOLILandsatQA;
import org.esa.s3tbx.dataio.landsat.geotiff.CollectionTMLandsatQA;
import org.esa.s3tbx.dataio.landsat.geotiff.LandsatQA;
import org.esa.s3tbx.dataio.landsat.geotiff.PreCollectionLandsatQA;

public class LandsatQAFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LandsatQA create(File mtlFile) throws IOException {
        boolean isCollectionProduct = false;
        boolean isOLI = false;
        boolean isMSS = false;
        boolean isTM = false;
        try (BufferedReader reader = null;){
            FileReader fileReader = new FileReader(mtlFile);
            reader = new BufferedReader(fileReader);
            String line = reader.readLine();
            while (line != null) {
                if (line.contains("COLLECTION_NUMBER")) {
                    isCollectionProduct = true;
                }
                if (line.contains("SENSOR_ID")) {
                    if (line.contains("OLI")) {
                        isOLI = true;
                    } else if (line.contains("MSS")) {
                        isMSS = true;
                    } else if (line.contains("TM")) {
                        isTM = true;
                    }
                }
                if (isCollectionProduct && isMSS) {
                    CollectionMSSLandsatQA collectionMSSLandsatQA = new CollectionMSSLandsatQA();
                    return collectionMSSLandsatQA;
                }
                if (isCollectionProduct && isOLI) {
                    CollectionOLILandsatQA collectionOLILandsatQA = new CollectionOLILandsatQA();
                    return collectionOLILandsatQA;
                }
                if (isCollectionProduct && isTM) {
                    CollectionTMLandsatQA collectionTMLandsatQA = new CollectionTMLandsatQA();
                    return collectionTMLandsatQA;
                }
                if (!isCollectionProduct && isOLI) {
                    PreCollectionLandsatQA preCollectionLandsatQA = new PreCollectionLandsatQA();
                    return preCollectionLandsatQA;
                }
                line = reader.readLine();
            }
        }
        return null;
    }
}

