/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat.geotiff;

import java.awt.Dimension;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.esa.s3tbx.dataio.landsat.geotiff.AbstractLandsatMetadata;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;

class LandsatLegacyMetadata
extends AbstractLandsatMetadata {
    private static final Map<String, String> BAND_DESCRIPTIONS = new HashMap<String, String>();
    private static final String SENSOR_ID = "SENSOR_ID";
    private static final float[] WAVELENGTHS;
    private static final float[] BANDWIDTHS;

    LandsatLegacyMetadata(Reader mtlReader) throws IOException {
        super(mtlReader);
    }

    public LandsatLegacyMetadata(MetadataElement root) throws IOException {
        super(root);
    }

    @Override
    public Dimension getReflectanceDim() {
        return this.getDimension("PRODUCT_SAMPLES_REF", "PRODUCT_LINES_REF");
    }

    @Override
    public Dimension getThermalDim() {
        return this.getDimension("PRODUCT_SAMPLES_THM", "PRODUCT_LINES_THM");
    }

    @Override
    public Dimension getPanchromaticDim() {
        return this.getDimension("PRODUCT_SAMPLES_PAN", "PRODUCT_LINES_PAN");
    }

    @Override
    public String getProductType() {
        return this.getProductType("PRODUCT_TYPE");
    }

    @Override
    public MetadataElement getProductMetadata() {
        return this.getMetaDataElementRoot().getElement("PRODUCT_METADATA");
    }

    @Override
    public double getScalingFactor(String bandId) {
        return this.getScalingFactor(bandId, "MIN_MAX_RADIANCE", "LMIN_BAND", "LMAX_BAND", "MIN_MAX_PIXEL_VALUE", "QCALMIN_BAND", "QCALMAX_BAND");
    }

    @Override
    public double getScalingOffset(String bandId) {
        return this.getScalingOffset(bandId, "MIN_MAX_RADIANCE", "LMIN_BAND", "LMAX_BAND", "MIN_MAX_PIXEL_VALUE", "QCALMIN_BAND", "QCALMAX_BAND");
    }

    @Override
    public ProductData.UTC getCenterTime() {
        return this.getCenterTime("ACQUISITION_DATE", "SCENE_CENTER_SCAN_TIME");
    }

    @Override
    public Pattern getOpticalBandFileNamePattern() {
        return Pattern.compile("BAND(\\d{1,2})_FILE_NAME");
    }

    @Override
    public float getWavelength(String bandNumber) {
        String bandIndexNumber = bandNumber.substring(0, 1);
        int index = Integer.parseInt(bandIndexNumber) - 1;
        return WAVELENGTHS[index];
    }

    @Override
    public float getBandwidth(String bandNumber) {
        String bandIndexNumber = bandNumber.substring(0, 1);
        int index = Integer.parseInt(bandIndexNumber) - 1;
        return BANDWIDTHS[index];
    }

    @Override
    public String getBandDescription(String bandNumber) {
        return BAND_DESCRIPTIONS.get(bandNumber);
    }

    @Override
    public String getQualityBandNameKey() {
        return null;
    }

    @Override
    public String getBandNamePrefix(String bandNumber) {
        return "radiance_" + bandNumber;
    }

    boolean isLandsatTM() {
        MetadataElement productMetadata = this.getProductMetadata();
        return "TM".equals(productMetadata.getAttributeString(SENSOR_ID));
    }

    boolean isLandsatETM_Plus() {
        MetadataElement productMetadata = this.getProductMetadata();
        return "ETM+".equals(productMetadata.getAttributeString(SENSOR_ID));
    }

    boolean isLegacyFormat() {
        MetadataElement metadata = this.getProductMetadata();
        return metadata.getAttribute("BAND1_FILE_NAME") != null;
    }

    static {
        BAND_DESCRIPTIONS.put("1", "Visible (30m)");
        BAND_DESCRIPTIONS.put("2", "Visible (30m)");
        BAND_DESCRIPTIONS.put("3", "Visible (30m)");
        BAND_DESCRIPTIONS.put("4", "Near-Infrared (30m)");
        BAND_DESCRIPTIONS.put("5", "Near-Infrared (30m)");
        BAND_DESCRIPTIONS.put("6", "Thermal (120m)");
        BAND_DESCRIPTIONS.put("61", "Thermal - Low Gain (60m)");
        BAND_DESCRIPTIONS.put("62", "Thermal - High Gain (60m)");
        BAND_DESCRIPTIONS.put("7", "Mid-Infrared (30m)");
        BAND_DESCRIPTIONS.put("8", "Panchromatic (15m)");
        WAVELENGTHS = new float[]{490.0f, 560.0f, 660.0f, 830.0f, 1670.0f, 11500.0f, 2240.0f, 710.0f};
        BANDWIDTHS = new float[]{66.0f, 82.0f, 67.0f, 128.0f, 217.0f, 1000.0f, 252.0f, 380.0f};
    }
}

