/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat.geotiff;

import com.bc.ceres.core.VirtualDir;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import org.esa.s3tbx.dataio.landsat.geotiff.LandsatGeotiffReader;
import org.esa.s3tbx.dataio.landsat.geotiff.LandsatTypeInfo;
import org.esa.s3tbx.dataio.landsat.tgz.VirtualDirTgz;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.io.SnapFileFilter;

public class LandsatGeotiffReaderPlugin
implements ProductReaderPlugIn {
    private static final Class[] READER_INPUT_TYPES = new Class[]{String.class, File.class};
    private static final String[] FORMAT_NAMES = new String[]{"LandsatGeoTIFF"};
    private static final String[] DEFAULT_FILE_EXTENSIONS = new String[]{".txt", ".TXT", ".gz", ".tgz"};
    private static final String READER_DESCRIPTION = "Landsat Data Products (GeoTIFF)";

    public DecodeQualification getDecodeQualification(Object input) {
        VirtualDir virtualDir;
        String filename = new File(input.toString()).getName();
        if (!LandsatTypeInfo.isLandsat(filename)) {
            return DecodeQualification.UNABLE;
        }
        try {
            virtualDir = LandsatGeotiffReaderPlugin.getInput(input);
        }
        catch (IOException e) {
            return DecodeQualification.UNABLE;
        }
        return LandsatGeotiffReaderPlugin.getDecodeQualification(virtualDir);
    }

    static DecodeQualification getDecodeQualification(VirtualDir virtualDir) {
        String[] allFiles;
        if (virtualDir == null) {
            return DecodeQualification.UNABLE;
        }
        try {
            allFiles = virtualDir.listAllFiles();
            if (allFiles == null || allFiles.length == 0) {
                return DecodeQualification.UNABLE;
            }
        }
        catch (IOException e) {
            return DecodeQualification.UNABLE;
        }
        for (String filePath : allFiles) {
            try {
                InputStream inputStream;
                if (!LandsatGeotiffReaderPlugin.isMetadataFilename(new File(filePath).getName()) || !LandsatGeotiffReaderPlugin.isMetadataFile(inputStream = virtualDir.getInputStream(filePath))) continue;
                return DecodeQualification.INTENDED;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return DecodeQualification.UNABLE;
    }

    static boolean isMetadataFilename(String filename) {
        return filename.toLowerCase().endsWith("_mtl.txt");
    }

    static boolean isMetadataFile(InputStream inputStream) {
        String firstLine;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            firstLine = reader.readLine();
        }
        catch (IOException e) {
            return false;
        }
        return firstLine != null && firstLine.trim().matches("GROUP = L1_METADATA_FILE");
    }

    public Class[] getInputTypes() {
        return READER_INPUT_TYPES;
    }

    public ProductReader createReaderInstance() {
        return new LandsatGeotiffReader(this);
    }

    public String[] getFormatNames() {
        return FORMAT_NAMES;
    }

    public String[] getDefaultFileExtensions() {
        return DEFAULT_FILE_EXTENSIONS;
    }

    public String getDescription(Locale locale) {
        return READER_DESCRIPTION;
    }

    public SnapFileFilter getProductFileFilter() {
        return new SnapFileFilter(FORMAT_NAMES[0], DEFAULT_FILE_EXTENSIONS, READER_DESCRIPTION);
    }

    static VirtualDir getInput(Object input) throws IOException {
        File absoluteFile;
        File inputFile = LandsatGeotiffReaderPlugin.getFileInput(input);
        if (inputFile == null) {
            throw new IOException("Unknown input type.");
        }
        if (inputFile.isFile() && !LandsatGeotiffReaderPlugin.isCompressedFile(inputFile) && (inputFile = (absoluteFile = inputFile.getAbsoluteFile()).getParentFile()) == null) {
            throw new IOException("Unable to retrieve parent to file: " + absoluteFile.getAbsolutePath());
        }
        VirtualDir virtualDir = VirtualDir.create((File)inputFile);
        if (virtualDir == null) {
            virtualDir = new VirtualDirTgz(inputFile);
        }
        return virtualDir;
    }

    static File getFileInput(Object input) {
        if (input instanceof String) {
            return new File((String)input);
        }
        if (input instanceof File) {
            return (File)input;
        }
        return null;
    }

    static boolean isCompressedFile(File file) {
        String extension = FileUtils.getExtension((File)file);
        if (StringUtils.isNullOrEmpty((String)extension)) {
            return false;
        }
        return (extension = extension.toLowerCase()).contains("zip") || extension.contains("tar") || extension.contains("tgz") || extension.contains("gz") || extension.contains("tbz") || extension.contains("bz") || extension.contains("tbz2") || extension.contains("bz2");
    }
}

