/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat.geotiff;

import java.awt.Dimension;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import org.esa.s3tbx.dataio.landsat.geotiff.AbstractLandsatMetadata;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.runtime.Config;

class Landsat8Metadata
extends AbstractLandsatMetadata {
    private static final double DEFAULT_SCALE_FACTOR = 1.0;
    private static final double DEFAULT_OFFSET = 0.0;
    private static final Preferences PREFERENCES = Config.instance((String)"s3tbx").load().preferences();
    private static final Logger LOG = Logger.getLogger(Landsat8Metadata.class.getName());
    private static final String[] BAND_DESCRIPTIONS = new String[]{"Coastal Aerosol (Operational Land Imager (OLI))", "Blue (OLI)", "Green (OLI)", "Red (OLI)", "Near-Infrared (NIR) (OLI)", "Short Wavelength Infrared (SWIR) 1 (OLI)", "SWIR 2 (OLI)", "Panchromatic (OLI)", "Cirrus (OLI)", "Thermal Infrared Sensor (TIRS) 1", "TIRS 2"};
    private static final float[] WAVELENGTHS = new float[]{440.0f, 480.0f, 560.0f, 655.0f, 865.0f, 1610.0f, 2200.0f, 590.0f, 1370.0f, 10895.0f, 12005.0f};
    private static final String[] BAND_NAMES = new String[]{"coastal_aerosol", "blue", "green", "red", "near_infrared", "swir_1", "swir_2", "panchromatic", "cirrus", "thermal_infrared_(tirs)_1", "thermal_infrared_(tirs)_2"};
    private static final float[] BANDWIDTHS = new float[]{20.0f, 60.0f, 60.0f, 30.0f, 30.0f, 80.0f, 180.0f, 180.0f, 20.0f, 590.0f, 1010.0f};

    public Landsat8Metadata(Reader fileReader) throws IOException {
        super(fileReader);
    }

    public Landsat8Metadata(MetadataElement root) throws IOException {
        super(root);
    }

    @Override
    public MetadataElement getProductMetadata() {
        return this.getMetaDataElementRoot().getElement("PRODUCT_METADATA");
    }

    @Override
    public Dimension getReflectanceDim() {
        return this.getDimension("REFLECTIVE_SAMPLES", "REFLECTIVE_LINES");
    }

    @Override
    public Dimension getThermalDim() {
        return this.getDimension("THERMAL_SAMPLES", "THERMAL_LINES");
    }

    @Override
    public Dimension getPanchromaticDim() {
        return this.getDimension("PANCHROMATIC_SAMPLES", "PANCHROMATIC_LINES");
    }

    @Override
    public String getProductType() {
        return this.getProductType("DATA_TYPE");
    }

    @Override
    public double getScalingFactor(String bandId) {
        String spectralInput = Landsat8Metadata.getSpectralInputString();
        String attributeKey = String.format("%s_MULT_BAND_%s", spectralInput, bandId);
        MetadataElement radiometricRescalingElement = this.getMetaDataElementRoot().getElement("RADIOMETRIC_RESCALING");
        if (radiometricRescalingElement.getAttribute(attributeKey) == null) {
            return 1.0;
        }
        double scalingFactor = radiometricRescalingElement.getAttributeDouble(attributeKey);
        double sunAngleCorrectionFactor = this.getSunAngleCorrectionFactor(spectralInput);
        return scalingFactor / sunAngleCorrectionFactor;
    }

    @Override
    public double getScalingOffset(String bandId) {
        String spectralInput = Landsat8Metadata.getSpectralInputString();
        String attributeKey = String.format("%s_ADD_BAND_%s", spectralInput, bandId);
        MetadataElement radiometricRescalingElement = this.getMetaDataElementRoot().getElement("RADIOMETRIC_RESCALING");
        if (radiometricRescalingElement.getAttribute(attributeKey) == null) {
            return 0.0;
        }
        double scalingOffset = radiometricRescalingElement.getAttributeDouble(attributeKey);
        double sunAngleCorrectionFactor = this.getSunAngleCorrectionFactor(spectralInput);
        return scalingOffset / sunAngleCorrectionFactor;
    }

    @Override
    public ProductData.UTC getCenterTime() {
        return this.getCenterTime("DATE_ACQUIRED", "SCENE_CENTER_TIME");
    }

    @Override
    public Pattern getOpticalBandFileNamePattern() {
        return Pattern.compile("FILE_NAME_BAND_(\\d{1,2})");
    }

    @Override
    public String getQualityBandNameKey() {
        return "FILE_NAME_BAND_QUALITY";
    }

    @Override
    public float getWavelength(String bandIndexNumber) {
        int index = Landsat8Metadata.getIndex(bandIndexNumber);
        return WAVELENGTHS[index];
    }

    @Override
    public float getBandwidth(String bandIndexNumber) {
        int index = Landsat8Metadata.getIndex(bandIndexNumber);
        return BANDWIDTHS[index];
    }

    @Override
    public String getBandDescription(String bandNumber) {
        int index = Landsat8Metadata.getIndex(bandNumber);
        return BAND_DESCRIPTIONS[index];
    }

    @Override
    public String getBandNamePrefix(String bandNumber) {
        int index = Landsat8Metadata.getIndex(bandNumber);
        return BAND_NAMES[index];
    }

    private static int getIndex(String bandIndexNumber) {
        return Integer.parseInt(bandIndexNumber) - 1;
    }

    static String getSpectralInputString() {
        String spectralInput;
        Preferences preferences = Config.instance((String)"s3tbx").load().preferences();
        String readAs = preferences.get("s3tbx.landsat.readAs", null);
        if (readAs != null) {
            switch (readAs.toLowerCase()) {
                case "reflectance": {
                    spectralInput = "REFLECTANCE";
                    break;
                }
                case "radiance": {
                    spectralInput = "RADIANCE";
                    break;
                }
                default: {
                    spectralInput = "RADIANCE";
                    LOG.warning(String.format("Property '%s' has unsupported value '%s'.%nInterpreting values as radiance.", "s3tbx.landsat.readAs", readAs));
                    break;
                }
            }
        } else {
            spectralInput = "RADIANCE";
        }
        return spectralInput;
    }

    private double getSunAngleCorrectionFactor(String spectralInput) {
        MetadataElement imageAttributesElement;
        double sunAngleCorrectionFactor = 1.0;
        if (spectralInput.equals("REFLECTANCE") && (imageAttributesElement = this.getMetaDataElementRoot().getElement("IMAGE_ATTRIBUTES")) != null) {
            String sunElevationAttributeKey = "SUN_ELEVATION";
            if (imageAttributesElement.getAttribute("SUN_ELEVATION") != null) {
                double sunElevationAngle = imageAttributesElement.getAttributeDouble("SUN_ELEVATION");
                sunAngleCorrectionFactor = Math.sin(Math.toRadians(sunElevationAngle));
            }
        }
        return sunAngleCorrectionFactor;
    }
}

