/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat.geotiff;

import com.bc.ceres.core.VirtualDir;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.esa.s3tbx.dataio.landsat.geotiff.LandsatGeotiffReaderPlugin;
import org.esa.s3tbx.dataio.landsat.geotiff.LandsatTypeInfo;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.util.io.SnapFileFilter;

public abstract class AbstractLandsat8ScalingGeotiffReaderPlugin
implements ProductReaderPlugIn {
    private static final Class[] READER_INPUT_TYPES = new Class[]{String.class, File.class};
    private static final String[] DEFAULT_FILE_EXTENSIONS = new String[]{".txt", ".TXT", ".gz"};
    public static final String PRE_COLLECTION_FILENAME_PATTERN = "LT8\\d{13}.{3}\\d{2}_MTL.(txt|TXT)";

    public DecodeQualification getDecodeQualification(Object input) {
        VirtualDir virtualDir;
        String filename = new File(input.toString()).getName();
        if (!AbstractLandsat8ScalingGeotiffReaderPlugin.isLandsat8Filename(filename)) {
            return DecodeQualification.UNABLE;
        }
        try {
            virtualDir = LandsatGeotiffReaderPlugin.getInput(input);
        }
        catch (IOException e) {
            return DecodeQualification.UNABLE;
        }
        DecodeQualification decodeQualification = LandsatGeotiffReaderPlugin.getDecodeQualification(virtualDir);
        if (DecodeQualification.INTENDED.equals((Object)decodeQualification)) {
            return DecodeQualification.SUITABLE;
        }
        return decodeQualification;
    }

    private static boolean isLandsat8Filename(String filename) {
        return LandsatTypeInfo.isLandsat8(filename) && !filename.matches(PRE_COLLECTION_FILENAME_PATTERN);
    }

    public Class[] getInputTypes() {
        return READER_INPUT_TYPES;
    }

    public String[] getDefaultFileExtensions() {
        return DEFAULT_FILE_EXTENSIONS;
    }

    public SnapFileFilter getProductFileFilter() {
        return new SnapFileFilter(this.getFormatNames()[0], DEFAULT_FILE_EXTENSIONS, this.getDescription(Locale.getDefault()));
    }
}

