/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat.fast;

import java.util.ArrayList;
import org.esa.s3tbx.dataio.landsat.GeoPoint;
import org.esa.s3tbx.dataio.landsat.GeometricData;
import org.esa.s3tbx.dataio.landsat.LandsatConstants;
import org.esa.s3tbx.dataio.landsat.LandsatHeader;
import org.esa.s3tbx.dataio.landsat.LandsatLoc;
import org.esa.s3tbx.dataio.landsat.LandsatTMBand;
import org.esa.s3tbx.dataio.landsat.LandsatTMMetadata;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;

public final class Landsat5FASTMetadata
extends LandsatTMMetadata {
    private static final String EARTH_SUN_DISTANCE = "Earth Sun Distance";
    private static final String RADIANCE_DESCRIPTION = "The LANDSAT TM radiance values";
    private static final String RADIANCE = "Radiance";
    private static final String METADATA_GEOMETRIC_NODE_DESCRIPTION = "The LANDSAT TM geometric values";
    private static final String METADATA_ADMINISTRATIV_NODE_DESCRIPTION = "The LANDSAT TM header information";
    private static final String GEO_METADATA_DESC = "Geometric";
    private static final String ADMIN_METADATA_DESC = "Header information";

    public Landsat5FASTMetadata(LandsatHeader header, LandsatTMBand[] landsatBands) {
        this.addElement(this.setAdminstrationMetadata(header));
        this.addElement(this.setGeometricMetadata(header));
        this.addElement(Landsat5FASTMetadata.setRadianceMetadata(header, landsatBands));
    }

    private MetadataElement setGeometricMetadata(LandsatHeader landsatHeader) {
        MetadataElement geo = new MetadataElement(GEO_METADATA_DESC);
        geo.setDescription(METADATA_GEOMETRIC_NODE_DESCRIPTION);
        GeometricData geoData = landsatHeader.getGeoData();
        ArrayList<MetadataAttribute> attributContainer = new ArrayList<MetadataAttribute>();
        attributContainer.add(Landsat5FASTMetadata.createAttribute("Datum", geoData.getEllipsoid(), "Ellipsoid used"));
        attributContainer.add(Landsat5FASTMetadata.createAttribute("Horizontal offset ", geoData.getHorizontalOffset(), "Horizontal offset of the true", LandsatConstants.Unit.PIXEL));
        attributContainer.add(Landsat5FASTMetadata.createAttribute("Projection ", geoData.getMapProjection(), "Map projection Name"));
        attributContainer.add(Landsat5FASTMetadata.createAttribute("USG Projection", geoData.getProjectionNumber(), "USG projection number"));
        attributContainer.add(Landsat5FASTMetadata.createAttribute("Map zone", geoData.getMapZoneNumber(), "USG map zone number"));
        attributContainer.add(Landsat5FASTMetadata.createAttribute("Semi-Major-Axis", geoData.getSemiMajorAxis(), "Semi-Major-Axis of earth ellipsoid", LandsatConstants.Unit.METER));
        attributContainer.add(Landsat5FASTMetadata.createAttribute("Semi-Minor-Axis", geoData.getSemiMinorAxis(), "Semi-Major-Axis of earth ellipsoid", LandsatConstants.Unit.METER));
        attributContainer.add(Landsat5FASTMetadata.createAttribute("Sun azimuth", Float.valueOf(geoData.getSunAzimuthAngle()), "Sun azimuth at scene center", LandsatConstants.Unit.ANGLE));
        attributContainer.add(Landsat5FASTMetadata.createAttribute("Sun elevation", Float.valueOf(geoData.getSunElevationAngle()), "Sun elevation angle at scene center", LandsatConstants.Unit.ANGLE));
        attributContainer.add(Landsat5FASTMetadata.createAttribute("orientation angle", Float.valueOf(geoData.getLookAngle()), "", LandsatConstants.Unit.ANGLE));
        for (int i = 0; i < geoData.getProjectionParameter().length; ++i) {
            attributContainer.add(Landsat5FASTMetadata.createAttribute(i + 1 + ". USG Projections parameter", geoData.getProjectionParameter()[i], "The USG projections parameters in standard USGS order. The meaning of these values depends on the projection used"));
        }
        for (MetadataAttribute anAttributContainer : attributContainer) {
            geo.addAttribute(anAttributContainer);
        }
        for (int i = 0; i < geoData.getImagePoints().size(); ++i) {
            GeoPoint geoPoint = (GeoPoint)geoData.getImagePoints().get(i);
            MetadataElement geoPointElement = new MetadataElement(geoPoint.toString());
            geoPointElement.setDescription(geoPoint.toString());
            ArrayList<MetadataAttribute> geoAttri = new ArrayList<MetadataAttribute>();
            geoAttri.add(Landsat5FASTMetadata.createAttribute(LandsatConstants.geoPointsAttributes.LONGITUDE.toString(), geoPoint.getGeodicLongitude(), "", LandsatConstants.Unit.ANGLE));
            geoAttri.add(Landsat5FASTMetadata.createAttribute(LandsatConstants.geoPointsAttributes.LATITUDE.toString(), geoPoint.getGeodicLatitude(), "", LandsatConstants.Unit.ANGLE));
            geoAttri.add(Landsat5FASTMetadata.createAttribute(LandsatConstants.geoPointsAttributes.EASTING.toString(), geoPoint.getEasting(), "", LandsatConstants.Unit.METER));
            geoAttri.add(Landsat5FASTMetadata.createAttribute(LandsatConstants.geoPointsAttributes.NORTHING.toString(), geoPoint.getNorthing(), "", LandsatConstants.Unit.METER));
            if (geoPoint.getGeoPointID().equals(LandsatConstants.Points.CENTER)) {
                GeoPoint center = (GeoPoint)geoData.getImagePoints().get(i);
                geoAttri.add(Landsat5FASTMetadata.createAttribute(LandsatConstants.geoPointsAttributes.CENTER_LINE.toString(), center.getPixelY(), "", LandsatConstants.Unit.METER));
                geoAttri.add(Landsat5FASTMetadata.createAttribute(LandsatConstants.geoPointsAttributes.CENTER_PIXEL.toString(), center.getPixelX(), "", LandsatConstants.Unit.METER));
            }
            for (MetadataAttribute aGeoAttri : geoAttri) {
                geoPointElement.addAttribute(aGeoAttri);
            }
            geo.addElement(geoPointElement);
        }
        return geo;
    }

    private MetadataElement setAdminstrationMetadata(LandsatHeader landsatHeader) {
        MetadataElement adminEle = new MetadataElement(ADMIN_METADATA_DESC);
        adminEle.setDescription(METADATA_ADMINISTRATIV_NODE_DESCRIPTION);
        ArrayList<MetadataAttribute> attributContainer = new ArrayList<MetadataAttribute>();
        LandsatLoc location = landsatHeader.getLoc();
        for (int i = 0; i < location.locationRecord().length; ++i) {
            MetadataAttribute locRec = Landsat5FASTMetadata.createAttribute(location.locationRecordDescription()[i], location.locationRecord()[i]);
            adminEle.addAttribute(locRec);
        }
        attributContainer.add(Landsat5FASTMetadata.createAttribute("Product", landsatHeader.getProductID(), "Product ordernummer yydddnnn-cc"));
        attributContainer.add(Landsat5FASTMetadata.createAttribute("Aquisition date", landsatHeader.getAcquisitionDate()));
        attributContainer.add(Landsat5FASTMetadata.createAttribute("Instrument", landsatHeader.getInstrumentType()));
        attributContainer.add(Landsat5FASTMetadata.createAttribute("Instrument mode", landsatHeader.getInstrumentMode(), "mode number"));
        attributContainer.add(Landsat5FASTMetadata.createAttribute("Product Size", landsatHeader.getProductSize()));
        attributContainer.add(Landsat5FASTMetadata.createAttribute("Type of product", landsatHeader.getProductType()));
        attributContainer.add(Landsat5FASTMetadata.createAttribute("Resampling", landsatHeader.getResampling()));
        attributContainer.add(Landsat5FASTMetadata.createAttribute("Tape Spanning", landsatHeader.getTapeSpanningFlag(), "Tape volume number of volumes in tape set in 'n/m' format"));
        attributContainer.add(Landsat5FASTMetadata.createAttribute("Startline", landsatHeader.getStartLine(), "First image line number on this volume"));
        attributContainer.add(Landsat5FASTMetadata.createAttribute("Lines per Volumes", landsatHeader.getLinesPerVolume(), "Number of image lines on this volume "));
        attributContainer.add(Landsat5FASTMetadata.createAttribute("Pixel size", Float.valueOf(landsatHeader.getPixelSize()), "", LandsatConstants.Unit.METER));
        attributContainer.add(Landsat5FASTMetadata.createAttribute("Number of pixels", landsatHeader.getImageWidth(), "Number of pixels per image line", LandsatConstants.Unit.PIXEL));
        attributContainer.add(Landsat5FASTMetadata.createAttribute("Number of lines", landsatHeader.getImageHeight(), "Number of lines in the output image"));
        attributContainer.add(Landsat5FASTMetadata.createAttribute("Bands", landsatHeader.getBandsPresent(), "Bands present on the volume"));
        attributContainer.add(Landsat5FASTMetadata.createAttribute("Blocking factor", landsatHeader.getBlockingFactor(), "Tape blocking factor"));
        attributContainer.add(Landsat5FASTMetadata.createAttribute("Record length", landsatHeader.getRecordLength(), "Length of physical tape record"));
        attributContainer.add(Landsat5FASTMetadata.createAttribute("Version", landsatHeader.getFormatVersion(), "Format version code(A-Z)"));
        attributContainer.add(Landsat5FASTMetadata.createAttribute(EARTH_SUN_DISTANCE, landsatHeader.getEarthSunDistance()));
        for (MetadataAttribute anAttributContainer : attributContainer) {
            adminEle.addAttribute(anAttributContainer);
        }
        return adminEle;
    }

    private static MetadataElement setRadianceMetadata(LandsatHeader landsatHeader, LandsatTMBand[] landsatBand) {
        MetadataElement rad = new MetadataElement(RADIANCE);
        rad.setDescription(RADIANCE_DESCRIPTION);
        double[] radData = new double[10];
        for (int i = 1; i <= landsatHeader.getNumberOfBands(); ++i) {
            LandsatTMBand landsatTMBand = landsatBand[i - 1];
            MetadataElement band = new MetadataElement("Band" + landsatTMBand.getIndex());
            radData[0] = landsatTMBand.getMinRadiance();
            radData[1] = landsatTMBand.getMaxRadiance();
            radData[3] = landsatTMBand.getBias();
            radData[2] = landsatTMBand.getGain();
            radData[4] = landsatTMBand.getFormerNomMinRadiance();
            radData[5] = landsatTMBand.getFormerNomMaxRadiance();
            radData[6] = landsatTMBand.getFormerNominalGain();
            radData[7] = landsatTMBand.getNewerNomMinRadiance();
            radData[8] = landsatTMBand.getNewerNomMaxRadiance();
            radData[9] = landsatTMBand.getNewerNomGain();
            for (int j = 0; j < radData.length; ++j) {
                MetadataAttribute tempAttri = Landsat5FASTMetadata.createAttribute(LandsatConstants.RADIANCE_DESCRIPTION_SHORT[j], radData[j]);
                tempAttri.setUnit(LandsatConstants.Unit.RADIANCE.toString());
                tempAttri.setDescription(LandsatConstants.RADIANCE_DESCRIPTION[j]);
                band.addAttribute(tempAttri);
            }
            rad.addElement(band);
        }
        return rad;
    }
}

