/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat.fast;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.esa.s3tbx.dataio.landsat.AbstractLandsatImageSources;
import org.esa.s3tbx.dataio.landsat.LandsatTMFile;
import org.esa.s3tbx.dataio.landsat.LandsatUtils;

public final class Landsat5FASTImageSources
extends AbstractLandsatImageSources {
    public Landsat5FASTImageSources(LandsatTMFile file) throws IOException {
        super(file);
        this.setImageLocations();
    }

    @Override
    protected final void setImageFiles() {
        final Pattern bandFilenamePattern = Pattern.compile("band[\\d].dat");
        File folder = new File(this.file.getFileLocation());
        Object[] filesInFolder = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && bandFilenamePattern.matcher(file.getName().toLowerCase()).matches();
            }
        });
        Arrays.sort(filesInFolder);
        this.imageSources = Arrays.asList(filesInFolder).toArray();
    }

    @Override
    protected final void setImageZipEntries() throws IOException {
        File folder = this.file.getInputFile();
        ZipFile zipFolder = new ZipFile(folder);
        Enumeration<? extends ZipEntry> enumeration = zipFolder.entries();
        ArrayList<ZipEntry> tempSource = new ArrayList<ZipEntry>();
        Pattern bandFilenamePattern = Pattern.compile("band[\\d]");
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!bandFilenamePattern.matcher(LandsatUtils.getZipEntryFileName(zipEntry).toLowerCase()).matches()) continue;
            tempSource.add(zipEntry);
        }
        Collections.sort(tempSource, new Comparator<ZipEntry>(){

            @Override
            public int compare(ZipEntry entry1, ZipEntry entry2) {
                String entry1FileName = LandsatUtils.getZipEntryFileName(entry1);
                String entry2FileName = LandsatUtils.getZipEntryFileName(entry2);
                return entry1FileName.compareTo(entry2FileName);
            }
        });
        this.imageSources = tempSource.toArray();
    }
}

