/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat;

import java.io.File;
import java.util.Locale;
import org.esa.s3tbx.dataio.landsat.LandsatConstants;
import org.esa.s3tbx.dataio.landsat.LandsatTMFile;
import org.esa.s3tbx.dataio.landsat.LandsatTMReader;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.RGBImageProfile;
import org.esa.snap.core.datamodel.RGBImageProfileManager;
import org.esa.snap.core.util.io.SnapFileFilter;

public final class LandsatTMReaderPlugIn
implements ProductReaderPlugIn {
    public LandsatTMReaderPlugIn() {
        RGBImageProfileManager manager = RGBImageProfileManager.getInstance();
        manager.addProfile(new RGBImageProfile("Landsat-TM 3,2,1", new String[]{"radiance_3", "radiance_2", "radiance_1"}));
        manager.addProfile(new RGBImageProfile("Landsat-TM 4,3,2", new String[]{"radiance_4", "radiance_3", "radiance_2"}));
        manager.addProfile(new RGBImageProfile("Landsat-8 red,green,blue", new String[]{"red", "green", "blue"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DecodeQualification getDecodeQualification(Object input) {
        try (LandsatTMFile file = null;){
            if (input instanceof String) {
                file = new LandsatTMFile((String)input);
            } else if (input instanceof File) {
                file = new LandsatTMFile((File)input);
            } else {
                DecodeQualification decodeQualification = DecodeQualification.UNABLE;
                return decodeQualification;
            }
            if (file.canDecodeInput()) {
                DecodeQualification decodeQualification = DecodeQualification.INTENDED;
                return decodeQualification;
            }
        }
        return DecodeQualification.UNABLE;
    }

    public static File getInputFile(Object input) {
        File file = null;
        if (input instanceof String) {
            file = new File((String)input);
        } else if (input instanceof File) {
            file = (File)input;
        }
        return file;
    }

    public final Class[] getInputTypes() {
        return LandsatConstants.INPUT_TYPES;
    }

    public final ProductReader createReaderInstance() {
        return new LandsatTMReader(this);
    }

    public SnapFileFilter getProductFileFilter() {
        return new SnapFileFilter(this.getFormatNames()[0], this.getDefaultFileExtensions(), this.getDescription(Locale.getDefault()));
    }

    public final String[] getFormatNames() {
        return LandsatConstants.FILE_NAMES;
    }

    public final String[] getDefaultFileExtensions() {
        return LandsatConstants.LANDSAT_EXTENSIONS;
    }

    public final String getDescription(Locale locale) {
        return "Landsat 5 TM Product Reader";
    }
}

