/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.esa.s3tbx.dataio.landsat.GeoPoint;
import org.esa.s3tbx.dataio.landsat.GeometricData;
import org.esa.s3tbx.dataio.landsat.LandsatBandReader;
import org.esa.s3tbx.dataio.landsat.LandsatConstants;
import org.esa.s3tbx.dataio.landsat.LandsatHeader;
import org.esa.s3tbx.dataio.landsat.LandsatTMBand;
import org.esa.s3tbx.dataio.landsat.LandsatTMData;
import org.esa.s3tbx.dataio.landsat.LandsatTMFactory;
import org.esa.s3tbx.dataio.landsat.LandsatTMReaderPlugIn;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.MapGeoCoding;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.dataop.maptransf.Datum;
import org.esa.snap.core.dataop.maptransf.MapInfo;
import org.esa.snap.core.dataop.maptransf.MapProjection;
import org.esa.snap.core.dataop.maptransf.UTM;
import org.esa.snap.core.dataop.maptransf.UTMProjection;

final class LandsatTMReader
extends AbstractProductReader {
    private static final String LANDSAT_TM_PRODUCT = "Landsat 5 TM Product";
    private LandsatTMData landsatTM;
    private Product product;
    private File inputFile;

    public LandsatTMReader(LandsatTMReaderPlugIn ReaderPlugIn) {
        super((ProductReaderPlugIn)ReaderPlugIn);
    }

    protected final Product readProductNodesImpl() throws IOException {
        this.inputFile = LandsatTMReaderPlugIn.getInputFile(this.getInput());
        LandsatTMFactory landsatFact = new LandsatTMFactory(this.inputFile);
        this.landsatTM = landsatFact.createLandsatTMObject();
        this.initReader();
        return this.product;
    }

    protected synchronized void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destband, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor progressMonitor) throws IOException {
        LandsatBandReader reader = this.landsatTM.getBandReader(destband);
        if (reader == null) {
            throw new IOException("No band reader for band '" + destband.getName() + "' available!");
        }
        reader.readBandData(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, destOffsetX, destOffsetY, destWidth, destHeight, destBuffer, progressMonitor);
    }

    private void initReader() {
        LandsatHeader landsatHeader = this.landsatTM.getHeader();
        int height = landsatHeader.getImageHeight();
        int width = landsatHeader.getImageWidth();
        String formatName = this.landsatTM.getProductName();
        ProductData.UTC startTime = landsatHeader.getAcquisitionDate();
        this.product = new Product(formatName + " " + landsatHeader.getRawDate(), formatName, width, height, (ProductReader)this);
        this.product.setDescription(LANDSAT_TM_PRODUCT);
        this.product.setFileLocation(this.inputFile);
        this.product.setStartTime(startTime);
        this.product.setModified(false);
        this.addBands(landsatHeader, height, width, formatName);
        this.setMapGeoCoding();
        this.setMetadata();
    }

    private void addBands(LandsatHeader landsatHeader, int height, int width, String formatName) {
        int dataType = 20;
        for (int i = 0; i < landsatHeader.getNumberOfBands(); ++i) {
            LandsatTMBand band = this.landsatTM.getBandAt(i);
            Band radBand = new Band("radiance_" + band.getIndex(), 20, width, height);
            radBand.setDescription(formatName);
            radBand.setSpectralBandIndex(band.getIndex());
            radBand.setSpectralWavelength(band.getWavelength());
            radBand.setSpectralBandwidth(band.getBandwidth());
            radBand.setSolarFlux(band.getSolarFlux());
            radBand.setNoDataValue(0.0);
            radBand.setNoDataValueUsed(true);
            radBand.clearNoDataValue();
            radBand.setScalingFactor(band.getGain());
            radBand.setScalingOffset(band.getBias());
            radBand.setUnit(LandsatConstants.Unit.RADIANCE.toString());
            this.product.addBand(radBand);
        }
    }

    private void setMetadata() {
        List metadata = this.landsatTM.getMetadata();
        for (MetadataElement element : metadata) {
            this.product.getMetadataRoot().addElement(element);
        }
    }

    private void setMapGeoCoding() {
        LandsatHeader landsatHeader = this.landsatTM.getHeader();
        GeometricData geoData = landsatHeader.getGeoData();
        float pixelSize = landsatHeader.getPixelSize();
        GeoPoint projCenter = geoData.getGeoPointAt(LandsatConstants.Points.CENTER);
        float pcX = projCenter.getPixelX();
        float pcY = projCenter.getPixelY();
        UTMProjection mappro = UTM.createProjection((int)(geoData.getMapZoneNumber() - 1), (!projCenter.isNorthernHemisphere() ? 1 : 0) != 0);
        int width = landsatHeader.getImageWidth();
        int height = landsatHeader.getImageHeight();
        MapInfo map = new MapInfo((MapProjection)mappro, pcX, pcY, (float)projCenter.getEasting(), (float)projCenter.getNorthing(), pixelSize, pixelSize, Datum.WGS_84);
        map.setSceneWidth(width);
        map.setSceneHeight(height);
        map.setOrientation(geoData.getLookAngle() * -1.0f);
        MapGeoCoding mapGeocoding = new MapGeoCoding(map);
        this.product.setSceneGeoCoding((GeoCoding)mapGeocoding);
    }

    public final void close() throws IOException {
        super.close();
        this.landsatTM.close();
        this.landsatTM = null;
        this.product = null;
    }
}

