/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import org.esa.s3tbx.dataio.landsat.LandsatConstants;
import org.esa.s3tbx.dataio.landsat.LandsatHeaderStream;
import org.esa.s3tbx.dataio.landsat.LandsatImageInputStream;
import org.esa.s3tbx.dataio.landsat.LandsatUtils;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.io.FileUtils;

public final class LandsatTMFile {
    private int format = -1;
    private final File inputFile;
    private boolean header = false;
    private String instrument;
    private String satellite;
    private boolean zipped = false;
    private LandsatHeaderStream headerStream;

    public LandsatTMFile(String inputPath) throws IOException {
        this(new File(inputPath));
    }

    public LandsatTMFile(File inputFile) throws IOException {
        this.inputFile = inputFile;
        this.init();
    }

    private void init() throws IOException {
        this.analyseInputFile();
    }

    public final boolean canDecodeInput() {
        boolean decodable = false;
        if (this.getLandsatHeaderStream() != null && this.getHeaderInputStream() != null) {
            if (this.getFormat() == 0) {
                if (this.getSatellite().equalsIgnoreCase(LandsatConstants.SATELLITE_NAMES[0]) && this.getInstrument().equalsIgnoreCase("TM")) {
                    decodable = true;
                }
            } else if (this.getFormat() == 3 && this.getSatellite().equalsIgnoreCase("L5") && this.getInstrument().equalsIgnoreCase("T")) {
                decodable = true;
            }
        }
        return decodable;
    }

    public final File getFile() {
        return this.inputFile;
    }

    private boolean isHeader() {
        return this.header;
    }

    public final int getFormat() {
        return this.format;
    }

    private LandsatImageInputStream getHeaderInputStream() {
        return this.headerStream.getInputStream();
    }

    public final LandsatHeaderStream getLandsatHeaderStream() {
        return this.headerStream;
    }

    public final String getFileLocation() {
        return LandsatTMFile.getFolderOfFile(this.inputFile);
    }

    private String getInstrument() {
        return this.instrument;
    }

    private String getSatellite() {
        return this.satellite;
    }

    public final File getInputFile() {
        return this.inputFile;
    }

    public final boolean isZipped() {
        return this.zipped;
    }

    private void setHeader(boolean header) {
        this.header = header;
    }

    private void setFormat(int format) {
        assert (format == -1 || format == 0 || format == 3 || format == 1);
        this.format = format;
    }

    private File findLandsat5HeaderInFolder() {
        Guardian.assertNotNull((String)"inputFile", (Object)this.inputFile);
        String folderPathName = LandsatTMFile.getFolderOfFile(this.inputFile);
        File folder = new File(folderPathName);
        if (!folder.exists() || !folder.isDirectory()) {
            return null;
        }
        File[] filesInFolder = folder.listFiles();
        for (int i = 0; i < filesInFolder.length; ++i) {
            if (filesInFolder[i].length() == 1536L && this.format == 0) {
                return filesInFolder[i];
            }
            if (!LandsatTMFile.isFastCEOSHeader(FileUtils.getFilenameWithoutExtension((String)filesInFolder[i].getName())) || this.format != 3) continue;
            return filesInFolder[i];
        }
        return null;
    }

    private void setFormat(String format) {
        Guardian.assertNotNullOrEmpty((String)"format", (String)format);
        int formatValue = -1;
        for (int i = 0; i < LandsatConstants.LANDSAT_EXTENSIONS.length; ++i) {
            if (!LandsatConstants.LANDSAT_EXTENSIONS[i].equalsIgnoreCase(format)) continue;
            formatValue = i;
            break;
        }
        this.setFormat(formatValue);
    }

    private void setInstrument(InputStreamReader ipStreamReader, int offset, int size) throws IOException {
        this.instrument = LandsatUtils.getValueFromLandsatFile(ipStreamReader, offset, size);
    }

    private void setIsHeader(String fileNameWithoutExt) {
        Guardian.assertNotNullOrEmpty((String)"fileNameWithoutExt", (String)fileNameWithoutExt);
        boolean isHeader = false;
        switch (this.format) {
            case 0: {
                isHeader = this.isFastL5Header(fileNameWithoutExt);
                break;
            }
            case 3: {
                isHeader = LandsatTMFile.isFastCEOSHeader(fileNameWithoutExt);
                break;
            }
        }
        this.setHeader(isHeader);
    }

    private static boolean isFastCEOSHeader(String fileName) {
        Guardian.assertNotNullOrEmpty((String)"fileName", (String)fileName);
        return fileName.equalsIgnoreCase("VDF_DAT");
    }

    private boolean isFastL5Header(String fileNameWithoutExt) {
        Guardian.assertNotNullOrEmpty((String)"fileNameWithoutExt", (String)fileNameWithoutExt);
        return fileNameWithoutExt.equalsIgnoreCase("header") && this.inputFile.length() == 1536L;
    }

    private void analyseInputFile() throws IOException {
        String extension = FileUtils.getExtension((File)this.inputFile);
        if (extension == null) {
            return;
        }
        this.setFormat(extension);
        if (this.format == 1) {
            this.analyseZipFile();
        } else {
            this.analyseFileFolder();
        }
        byte[] headerBegin = LandsatTMFile.getHeaderBegin(this.format);
        try {
            if (headerBegin != null) {
                this.extractLandsatIdentifier(headerBegin);
            }
        }
        catch (IOException e) {
            this.headerStream.getInputStream().close();
        }
    }

    private static byte[] getHeaderBegin(int format) {
        switch (format) {
            case 0: {
                return new byte[93];
            }
            case 3: {
                return new byte[48];
            }
        }
        return null;
    }

    private void analyseFileFolder() throws IOException {
        String fileName = this.inputFile.getName();
        this.setIsHeader(FileUtils.getFilenameWithoutExtension((String)fileName));
        if (this.isHeader()) {
            this.initInputStream(this.inputFile);
        } else {
            File tempFile = this.findLandsat5HeaderInFolder();
            if (tempFile != null) {
                this.initInputStream(tempFile);
            }
        }
    }

    private void analyseZipFile() throws IOException {
        try {
            ZipFile zipFile = new ZipFile(this.inputFile, 1);
            ZipEntry headerEntry = this.getZipEntryLandsatHeader(zipFile);
            if (headerEntry != null) {
                this.initInputStream(zipFile, headerEntry);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            IOException e = new IOException(t.getMessage());
            e.initCause(t);
            throw e;
        }
    }

    private void extractLandsatIdentifier(byte[] headerBegin) throws IOException {
        this.headerStream.getInputStream().getImageInputStream().readFully(headerBegin, 0, headerBegin.length);
        InputStreamReader inputReader = new InputStreamReader(new ByteArrayInputStream(headerBegin));
        this.setSatellite(inputReader);
        this.setInstrument(inputReader);
    }

    private void initInputStream(File file) throws IOException {
        this.headerStream = new LandsatHeaderStream(file);
    }

    private void initInputStream(ZipFile zipFile, ZipEntry headerEntry) throws IOException {
        this.setHeader(true);
        InputStream inputStream = zipFile.getInputStream(headerEntry);
        LandsatImageInputStream input = new LandsatImageInputStream(ImageIO.createImageInputStream(inputStream), headerEntry.getSize());
        this.headerStream = new LandsatHeaderStream(input, LandsatUtils.getZipEntryFileName(headerEntry));
        this.zipped = true;
    }

    private void setSatellite(InputStreamReader inputReader) throws IOException {
        switch (this.format) {
            case 0: {
                this.setSatellite(inputReader, 75, 2);
                break;
            }
            case 3: {
                this.setSatellite(inputReader, 45, 2);
                break;
            }
        }
    }

    private void setSatellite(InputStreamReader inputReader, int offset, int size) throws IOException {
        this.satellite = LandsatUtils.getValueFromLandsatFile(inputReader, offset, size);
    }

    private void setInstrument(InputStreamReader ipStreamReader) throws IOException {
        switch (this.format) {
            case 0: {
                this.setInstrument(ipStreamReader, 14, 2);
                break;
            }
            case 3: {
                this.setInstrument(ipStreamReader, 1, 1);
                break;
            }
        }
    }

    private static String getFolderOfFile(File file) {
        String path = file.getParent();
        if (path == null) {
            path = "\".\"";
        }
        return path;
    }

    private ZipEntry getZipEntryLandsatHeader(ZipFile dataFile) {
        Guardian.assertNotNull((String)"dataFile", (Object)dataFile);
        boolean checkFormatFlag = true;
        Enumeration<? extends ZipEntry> enumeration = dataFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (checkFormatFlag) {
                this.setFormat(FileUtils.getExtension((String)zipEntry.getName()));
                checkFormatFlag = false;
            }
            if (zipEntry.getSize() != 1536L || !LandsatTMFile.isFASTFormat(zipEntry.getName())) continue;
            this.format = 0;
            return zipEntry;
        }
        return null;
    }

    private static boolean isFASTFormat(String FileName) {
        String fileExtension = FileUtils.getExtension((String)FileName);
        return LandsatConstants.LANDSAT_EXTENSIONS[0].equalsIgnoreCase(fileExtension);
    }

    public void close() {
        if (this.headerStream != null) {
            this.headerStream.close();
        }
    }
}

