/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat;

import java.io.File;
import java.io.IOException;
import org.esa.s3tbx.dataio.landsat.LandsatTMData;
import org.esa.s3tbx.dataio.landsat.LandsatTMFile;
import org.esa.s3tbx.dataio.landsat.ceos.Landsat5CEOS;
import org.esa.s3tbx.dataio.landsat.fast.Landsat5FAST;
import org.esa.snap.core.dataio.IllegalFileFormatException;

final class LandsatTMFactory {
    private final LandsatTMFile inputFile;

    LandsatTMFactory(File inputFile) throws IOException {
        this.inputFile = new LandsatTMFile(inputFile);
    }

    public final LandsatTMData createLandsatTMObject() throws IOException {
        if (this.inputFile.getFormat() == 0) {
            return new Landsat5FAST(this.inputFile);
        }
        if (this.inputFile.getFormat() == 3) {
            return new Landsat5CEOS(this.inputFile);
        }
        throw new IllegalFileFormatException("Unknown data format.");
    }
}

