/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat;

import java.io.File;
import java.io.IOException;
import org.esa.s3tbx.dataio.landsat.LandsatImageInputStream;
import org.esa.snap.core.util.io.FileUtils;

public final class LandsatHeaderStream {
    private LandsatImageInputStream inputStream;
    private String headerFileName;

    public LandsatHeaderStream(File header) throws IOException {
        LandsatImageInputStream inputStream = new LandsatImageInputStream(header);
        this.initLandsatHeaderStream(inputStream, FileUtils.getFilenameWithoutExtension((File)header));
    }

    public LandsatHeaderStream(LandsatImageInputStream inputStream, String fileName) {
        this.initLandsatHeaderStream(inputStream, fileName);
    }

    private void initLandsatHeaderStream(LandsatImageInputStream inputStream, String fileName) {
        this.inputStream = inputStream;
        this.headerFileName = fileName;
    }

    public final String getHeaderFileName() {
        return this.headerFileName;
    }

    public final LandsatImageInputStream getInputStream() {
        return this.inputStream;
    }

    public void close() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

