/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat;

import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.snap.core.datamodel.ProductData;

public abstract class LandsatBandReader {
    private final String bandName;
    final ImageInputStream stream;
    final int width;

    LandsatBandReader(int width, String bandName, ImageInputStream stream) {
        this.bandName = bandName;
        this.stream = stream;
        this.width = width;
    }

    public final String getBandName() {
        return this.bandName;
    }

    abstract void readBandData(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, ProductData var11, ProgressMonitor var12) throws IOException;

    final void setStreamPos(int sourceOffsetX, int sourceOffsetY, int pixelSize) throws IOException {
        long currentOffset = (sourceOffsetY * this.width + sourceOffsetX) * pixelSize;
        this.stream.seek(currentOffset);
    }

    final void updateStreamPos(int delta, int pixelSize) throws IOException {
        long currentOffset = (int)this.stream.getStreamPosition();
        this.stream.seek(currentOffset += (long)(delta * pixelSize));
    }

    public final void close() throws IOException {
        this.stream.close();
    }
}

