/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat.geotiff;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.VirtualDir;
import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import org.esa.s3tbx.dataio.landsat.geotiff.LandsatGeotiffReaderPlugin;
import org.esa.s3tbx.dataio.landsat.geotiff.LandsatMetadata;
import org.esa.s3tbx.dataio.landsat.geotiff.LandsatMetadataFactory;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.image.SourceImageScaler;
import org.esa.snap.dataio.geotiff.GeoTiffProductReaderPlugIn;
import org.esa.snap.runtime.Config;

public class LandsatGeotiffReader
extends AbstractProductReader {
    static final String SYSPROP_READ_AS = "s3tbx.landsat.readAs";
    private static final String READ_AS_REFLECTANCE = "reflectance";
    private static final Logger LOG = Logger.getLogger(LandsatGeotiffReader.class.getName());
    private static final String RADIANCE_UNITS = "W/(m^2*sr*\u00b5m)";
    private static final String REFLECTANCE_UNITS = "dl";
    private final Resolution targetResolution;
    private LandsatMetadata landsatMetadata;
    private List<Product> bandProducts;
    private VirtualDir virtualDir;
    private String basePath;

    public LandsatGeotiffReader(ProductReaderPlugIn readerPlugin) {
        this(readerPlugin, Resolution.DEFAULT);
    }

    public LandsatGeotiffReader(ProductReaderPlugIn readerPlugin, Resolution targetResolution) {
        super(readerPlugin);
        this.targetResolution = targetResolution;
    }

    protected Product readProductNodesImpl() throws IOException {
        Dimension productDim;
        this.virtualDir = LandsatGeotiffReaderPlugin.getInput(this.getInput());
        File mtlFile = this.getMtlFile();
        this.landsatMetadata = LandsatMetadataFactory.create(mtlFile);
        switch (this.targetResolution) {
            case L8_REFLECTIVE: {
                productDim = this.landsatMetadata.getReflectanceDim();
                if (productDim != null) break;
                productDim = this.landsatMetadata.getThermalDim();
                break;
            }
            case L8_PANCHROMATIC: {
                productDim = this.landsatMetadata.getPanchromaticDim();
                break;
            }
            default: {
                productDim = this.landsatMetadata.getPanchromaticDim();
                if (productDim == null) {
                    productDim = this.landsatMetadata.getReflectanceDim();
                }
                if (productDim != null) break;
                productDim = this.landsatMetadata.getThermalDim();
            }
        }
        MetadataElement metadataElement = this.landsatMetadata.getMetaDataElementRoot();
        Product product = new Product(LandsatGeotiffReader.getProductName(mtlFile), this.landsatMetadata.getProductType(), productDim.width, productDim.height);
        product.setFileLocation(mtlFile);
        product.getMetadataRoot().addElement(metadataElement);
        ProductData.UTC utcCenter = this.landsatMetadata.getCenterTime();
        product.setStartTime(utcCenter);
        product.setEndTime(utcCenter);
        this.addBands(product);
        return product;
    }

    protected File getMtlFile() throws IOException {
        File mtlFile = null;
        File fileInput = LandsatGeotiffReaderPlugin.getFileInput(this.getInput());
        if (fileInput != null && fileInput.exists() && LandsatGeotiffReaderPlugin.isMetadataFilename(fileInput.getName())) {
            this.basePath = "";
            mtlFile = fileInput;
        } else {
            String[] fileList;
            for (String filePath : fileList = this.virtualDir.listAllFiles()) {
                if (!LandsatGeotiffReaderPlugin.isMetadataFilename(filePath)) continue;
                this.basePath = new File(filePath).getParent();
                this.basePath = this.basePath == null ? "" : this.basePath + "/";
                mtlFile = this.virtualDir.getFile(filePath);
                break;
            }
        }
        if (mtlFile == null) {
            throw new IOException("Can not find metadata file.");
        }
        if (!mtlFile.canRead()) {
            throw new IOException("Can not read metadata file: " + mtlFile.getAbsolutePath());
        }
        return mtlFile;
    }

    private static String getProductName(File mtlfile) {
        String filename = mtlfile.getName();
        int extensionIndex = filename.toLowerCase().indexOf("_mtl.txt");
        return filename.substring(0, extensionIndex);
    }

    private void addBands(Product product) throws IOException {
        MultiLevelImage sourceImage;
        GeoTiffProductReaderPlugIn plugIn = new GeoTiffProductReaderPlugIn();
        MetadataAttribute[] productAttributes = this.landsatMetadata.getProductMetadata().getAttributes();
        Pattern pattern = this.landsatMetadata.getOpticalBandFileNamePattern();
        this.bandProducts = new ArrayList<Product>();
        for (MetadataAttribute metadataAttribute : productAttributes) {
            List<Mask> masks;
            String attributeName = metadataAttribute.getName();
            Matcher matcher = pattern.matcher(attributeName);
            if (matcher.matches()) {
                String bandNumber = matcher.group(1);
                String fileName = metadataAttribute.getData().getElemString();
                File bandFile = this.virtualDir.getFile(this.basePath + fileName);
                ProductReader productReader = plugIn.createReaderInstance();
                Product bandProduct = productReader.readProductNodes((Object)bandFile, null);
                if (bandProduct == null) continue;
                this.bandProducts.add(bandProduct);
                Band srcBand = bandProduct.getBandAt(0);
                String bandName = this.landsatMetadata.getBandNamePrefix(bandNumber);
                Band band = this.addBandToProduct(bandName, srcBand, product);
                band.setScalingFactor(this.landsatMetadata.getScalingFactor(bandNumber));
                band.setScalingOffset(this.landsatMetadata.getScalingOffset(bandNumber));
                band.setNoDataValue(0.0);
                band.setNoDataValueUsed(true);
                band.setSpectralWavelength(this.landsatMetadata.getWavelength(bandNumber));
                band.setSpectralBandwidth(this.landsatMetadata.getBandwidth(bandNumber));
                band.setDescription(this.landsatMetadata.getBandDescription(bandNumber));
                band.setUnit(RADIANCE_UNITS);
                Preferences preferences = Config.instance((String)"s3tbx").load().preferences();
                String readAs = preferences.get(SYSPROP_READ_AS, null);
                if (readAs == null) continue;
                switch (readAs.toLowerCase()) {
                    case "reflectance": {
                        band.setDescription(this.landsatMetadata.getBandDescription(bandNumber) + " , as TOA Reflectance");
                        band.setUnit(REFLECTANCE_UNITS);
                        break;
                    }
                    default: {
                        LOG.warning(String.format("Property '%s' has unsupported value '%s'", SYSPROP_READ_AS, readAs));
                    }
                }
                continue;
            }
            if (!attributeName.equals(this.landsatMetadata.getQualityBandNameKey())) continue;
            String fileName = metadataAttribute.getData().getElemString();
            File bandFile = this.virtualDir.getFile(this.basePath + fileName);
            ProductReader productReader = plugIn.createReaderInstance();
            Product bandProduct = productReader.readProductNodes((Object)bandFile, null);
            if (bandProduct == null) continue;
            this.bandProducts.add(bandProduct);
            Band srcBand = bandProduct.getBandAt(0);
            String bandName = "flags";
            Band band = this.addBandToProduct(bandName, srcBand, product);
            band.setNoDataValue(0.0);
            band.setNoDataValueUsed(true);
            band.setDescription("Quality Band");
            FlagCoding flagCoding = this.createFlagCoding(bandName);
            band.setSampleCoding((SampleCoding)flagCoding);
            product.getFlagCodingGroup().add((ProductNode)flagCoding);
            if (Resolution.DEFAULT.equals((Object)this.targetResolution)) {
                Dimension dimension = this.landsatMetadata.getReflectanceDim();
                if (dimension == null) {
                    dimension = this.landsatMetadata.getThermalDim();
                }
                masks = this.createMasks(dimension != null ? dimension : product.getSceneRasterSize());
            } else {
                masks = this.createMasks(product.getSceneRasterSize());
            }
            for (Mask mask : masks) {
                product.getMaskGroup().add((ProductNode)mask);
            }
        }
        ImageLayout imageLayout = new ImageLayout();
        for (Product bandProduct : this.bandProducts) {
            if (product.getSceneGeoCoding() != null || product.getSceneRasterWidth() != bandProduct.getSceneRasterWidth() || product.getSceneRasterHeight() != bandProduct.getSceneRasterHeight()) continue;
            product.setSceneGeoCoding(bandProduct.getSceneGeoCoding());
            Dimension tileSize = bandProduct.getPreferredTileSize();
            if (tileSize == null) {
                tileSize = ImageManager.getPreferredTileSize((Product)bandProduct);
            }
            product.setPreferredTileSize(tileSize);
            imageLayout.setTileWidth(tileSize.width);
            imageLayout.setTileHeight(tileSize.height);
            break;
        }
        if (Resolution.DEFAULT.equals((Object)this.targetResolution)) {
            for (int i = 0; i < this.bandProducts.size(); ++i) {
                Product bandProduct = this.bandProducts.get(i);
                Band band = product.getBandAt(i);
                sourceImage = bandProduct.getBandAt(0).getSourceImage();
                band.setSourceImage(sourceImage);
                band.setGeoCoding(bandProduct.getSceneGeoCoding());
            }
        } else {
            MultiLevelImage targetImage = null;
            for (Product bandProduct : this.bandProducts) {
                if (product.getSceneRasterWidth() != bandProduct.getSceneRasterWidth() || product.getSceneRasterHeight() != bandProduct.getSceneRasterHeight()) continue;
                targetImage = bandProduct.getBandAt(0).getSourceImage();
                break;
            }
            if (targetImage == null) {
                throw new IllegalStateException("Could not determine target image");
            }
            for (int i = 0; i < this.bandProducts.size(); ++i) {
                Product bandProduct;
                bandProduct = this.bandProducts.get(i);
                sourceImage = bandProduct.getBandAt(0).getSourceImage();
                RenderingHints renderingHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout);
                float[] scalings = new float[]{(float)product.getSceneRasterWidth() / (float)bandProduct.getSceneRasterWidth(), (float)product.getSceneRasterHeight() / (float)bandProduct.getSceneRasterHeight()};
                Band band = product.getBandAt(i);
                MultiLevelImage image = SourceImageScaler.scaleMultiLevelImage((MultiLevelImage)targetImage, (MultiLevelImage)sourceImage, (float[])scalings, null, (RenderingHints)renderingHints, (double)band.getNoDataValue(), (Interpolation)Interpolation.getInstance((int)0));
                band.setSourceImage((RenderedImage)image);
            }
        }
    }

    private Band addBandToProduct(String bandName, Band srcBand, Product product) {
        Dimension bandDimension = this.getBandDimension(srcBand, this.targetResolution);
        Band band = new Band(bandName, srcBand.getDataType(), bandDimension.width, bandDimension.height);
        product.addBand(band);
        return band;
    }

    private Dimension getBandDimension(Band srcBand, Resolution targetResolution) {
        switch (targetResolution) {
            case L8_REFLECTIVE: {
                return this.landsatMetadata.getReflectanceDim();
            }
            case L8_PANCHROMATIC: {
                return this.landsatMetadata.getPanchromaticDim();
            }
        }
        return srcBand.getRasterSize();
    }

    private List<Mask> createMasks(Dimension size) {
        ArrayList<Mask> masks = new ArrayList<Mask>();
        int width = size.width;
        int height = size.height;
        masks.add(Mask.BandMathsType.create((String)"designated_fill", (String)"Designated Fill", (int)width, (int)height, (String)"flags.designated_fill", (Color)ColorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"dropped_frame", (String)"Dropped Frame", (int)width, (int)height, (String)"flags.dropped_frame", (Color)ColorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)"terrain_occlusion", (String)"Terrain Occlusion", (int)width, (int)height, (String)"flags.terrain_occlusion", (Color)ColorIterator.next(), (double)0.5));
        masks.addAll(this.createConfidenceMasks("water_confidence", "Water confidence", width, height));
        masks.addAll(this.createConfidenceMasks("vegetation_confidence", "Vegetation confidence", width, height));
        masks.addAll(this.createConfidenceMasks("snow_ice_confidence", "Snow/ice confidence", width, height));
        masks.addAll(this.createConfidenceMasks("cirrus_confidence", "Cirrus confidence", width, height));
        masks.addAll(this.createConfidenceMasks("cloud_confidence", "Cloud confidence", width, height));
        return masks;
    }

    private List<Mask> createConfidenceMasks(String flagMaskBaseName, String descriptionBaseName, int width, int height) {
        ArrayList<Mask> masks = new ArrayList<Mask>();
        masks.add(Mask.BandMathsType.create((String)(flagMaskBaseName + "_low"), (String)(descriptionBaseName + " 0-35%"), (int)width, (int)height, (String)("flags." + flagMaskBaseName + "_one and not flags." + flagMaskBaseName + "_two"), (Color)ColorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)(flagMaskBaseName + "_mid"), (String)(descriptionBaseName + " 36-64%"), (int)width, (int)height, (String)("not flags." + flagMaskBaseName + "_one and flags." + flagMaskBaseName + "_two"), (Color)ColorIterator.next(), (double)0.5));
        masks.add(Mask.BandMathsType.create((String)(flagMaskBaseName + "_high"), (String)(descriptionBaseName + " 65-100%"), (int)width, (int)height, (String)("flags." + flagMaskBaseName + "_one and flags." + flagMaskBaseName + "_two"), (Color)ColorIterator.next(), (double)0.5));
        return masks;
    }

    private FlagCoding createFlagCoding(String bandName) {
        FlagCoding flagCoding = new FlagCoding(bandName);
        flagCoding.addFlag("designated_fill", 1, "Designated Fill");
        flagCoding.addFlag("dropped_frame", 2, "Dropped Frame");
        flagCoding.addFlag("terrain_occlusion", 4, "Terrain Occlusion");
        flagCoding.addFlag("reserved_1", 8, "Reserved for a future 1-bit class artifact designation");
        flagCoding.addFlag("water_confidence_one", 16, "Water confidence bit one");
        flagCoding.addFlag("water_confidence_two", 32, "Water confidence bit two");
        flagCoding.addFlag("reserved_2_one", 64, "Reserved for a future 2-bit class artifact designation");
        flagCoding.addFlag("reserved_2_two", 128, "Reserved for a future 2-bit class artifact designation");
        flagCoding.addFlag("vegetation_confidence_one", 256, "Vegetation confidence bit one");
        flagCoding.addFlag("vegetation_confidence_two", 512, "Vegetation confidence bit two");
        flagCoding.addFlag("snow_ice_confidence_one", 1024, "Snow/ice confidence bit one");
        flagCoding.addFlag("snow_ice_confidence_two", 2048, "Snow/ice confidence bit two");
        flagCoding.addFlag("cirrus_confidence_one", 4096, "Cirrus confidence bit one");
        flagCoding.addFlag("cirrus_confidence_two", 8192, "Cirrus confidence bit two");
        flagCoding.addFlag("cloud_confidence_one", 16384, "Cloud confidence bit one");
        flagCoding.addFlag("cloud_confidence_two", 32768, "Cloud confidence bit two");
        return flagCoding;
    }

    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        throw new IllegalStateException();
    }

    public void close() throws IOException {
        for (Product bandProduct : this.bandProducts) {
            bandProduct.closeIO();
        }
        this.bandProducts.clear();
        this.virtualDir.close();
        this.virtualDir = null;
        super.close();
    }

    private static class ColorIterator {
        static ArrayList<Color> colors = new ArrayList();
        static Iterator<Color> colorIterator;

        private ColorIterator() {
        }

        static Color next() {
            if (!colorIterator.hasNext()) {
                colorIterator = colors.iterator();
            }
            return colorIterator.next();
        }

        static {
            colors.add(Color.red);
            colors.add(Color.red.darker());
            colors.add(Color.red.darker().darker());
            colors.add(Color.blue);
            colors.add(Color.blue.darker());
            colors.add(Color.blue.darker().darker());
            colors.add(Color.green);
            colors.add(Color.green.darker());
            colors.add(Color.green.darker().darker());
            colors.add(Color.yellow);
            colors.add(Color.yellow.darker());
            colors.add(Color.yellow.darker().darker());
            colors.add(Color.magenta);
            colors.add(Color.magenta.darker());
            colors.add(Color.magenta.darker().darker());
            colors.add(Color.pink);
            colors.add(Color.pink.darker());
            colors.add(Color.pink.darker().darker());
            colorIterator = colors.iterator();
        }
    }

    static enum Resolution {
        DEFAULT,
        L8_PANCHROMATIC,
        L8_REFLECTIVE;

    }
}

