/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat.fast;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.s3tbx.dataio.landsat.GeoPoint;
import org.esa.s3tbx.dataio.landsat.GeometricData;
import org.esa.s3tbx.dataio.landsat.Landsat5TMBand;
import org.esa.s3tbx.dataio.landsat.LandsatBandReader;
import org.esa.s3tbx.dataio.landsat.LandsatByteBandReader;
import org.esa.s3tbx.dataio.landsat.LandsatConstants;
import org.esa.s3tbx.dataio.landsat.LandsatHeader;
import org.esa.s3tbx.dataio.landsat.LandsatImageInputStream;
import org.esa.s3tbx.dataio.landsat.LandsatTMBand;
import org.esa.s3tbx.dataio.landsat.LandsatTMData;
import org.esa.s3tbx.dataio.landsat.LandsatTMFile;
import org.esa.s3tbx.dataio.landsat.LandsatUtils;
import org.esa.s3tbx.dataio.landsat.RadiometricData;
import org.esa.s3tbx.dataio.landsat.fast.Landsat5FASTConstants;
import org.esa.s3tbx.dataio.landsat.fast.Landsat5FASTImageSources;
import org.esa.s3tbx.dataio.landsat.fast.Landsat5FASTMetadata;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.util.Debug;

public final class Landsat5FAST
extends Landsat5FASTConstants
implements LandsatTMData {
    private static final int DEFAULT_NUMBER = 7;
    private static final int SEPERATOR = 1;
    private static final int BLANK = 1;
    private static final String PRODUCTNAME = "LANDSAT 5 TM SCENE";
    private static final int FORMAT = 0;
    private LandsatHeader landsatHeader;
    private final LandsatTMFile inputFile;
    private LandsatTMBand[] landsatBands;
    private Landsat5FASTMetadata metadata;
    private Map<LandsatTMBand, LandsatBandReader> bandReaders;

    public Landsat5FAST(LandsatTMFile inputFile) throws IOException {
        this.inputFile = inputFile;
        this.init();
    }

    @Override
    public String getProductName() {
        return PRODUCTNAME;
    }

    @Override
    public LandsatHeader getHeader() {
        return this.landsatHeader;
    }

    @Override
    public LandsatBandReader getBandReader(LandsatConstants.ConstBand band) {
        LandsatTMBand landsatBand = this.extractLandsatTMBand(band);
        return this.bandReaders.get(landsatBand);
    }

    private void addBandReader(LandsatBandReader reader) {
        LandsatTMBand band = this.getBand(reader.getBandName());
        if (band != null) {
            this.bandReaders.put(band, reader);
        } else {
            Debug.trace((String)"band = null");
        }
    }

    @Override
    public List getMetadata() {
        return this.metadata.getLandsatMetadataElements();
    }

    @Override
    public LandsatTMBand getBandAt(int idx) {
        return this.landsatBands[idx];
    }

    @Override
    public int getFormat() {
        return 0;
    }

    @Override
    public void close() throws IOException {
        if (this.bandReaders != null) {
            for (LandsatBandReader element : this.bandReaders.values()) {
                element.close();
            }
        }
        if (this.landsatHeader != null) {
            this.landsatHeader.close();
        }
        if (this.inputFile != null) {
            this.inputFile.close();
        }
    }

    @Override
    public LandsatBandReader getBandReader(Band band) {
        return this.getBandReader(LandsatConstants.ConstBand.getConstBand(band));
    }

    private LandsatTMBand getBand(String BandName) {
        for (LandsatTMBand landsatBand : this.landsatBands) {
            if (!landsatBand.getBandName().equals(BandName)) continue;
            return landsatBand;
        }
        return null;
    }

    private void init() throws IOException {
        this.bandReaders = new HashMap<LandsatTMBand, LandsatBandReader>();
        this.readHeaderData();
        int[] presentBands = this.landsatHeader.getBandsPresent();
        this.landsatBands = new Landsat5TMBand[presentBands.length];
        Landsat5FASTImageSources sources = new Landsat5FASTImageSources(this.inputFile);
        if (presentBands.length > sources.getSize()) {
            throw new IOException("Not able to read product. At least one data file is missing.");
        }
        for (int i = 0; i < presentBands.length; ++i) {
            this.landsatBands[i] = new Landsat5TMBand(i, presentBands[i], sources.getLandsatImageSourceAt(i), this.landsatHeader.getRadData(), this.inputFile);
        }
        this.metadata = new Landsat5FASTMetadata(this.landsatHeader, this.landsatBands);
        this.createBandReaders();
    }

    private void readHeaderData() throws IOException {
        LandsatImageInputStream headerInputStream = null;
        try {
            this.landsatHeader = new LandsatHeader(this.inputFile);
            headerInputStream = this.landsatHeader.getHeaderInputStreamAt("header");
            if (headerInputStream == null) {
                throw new IOException("Failed to read LANDSAT-5 header data.");
            }
            this.landsatHeader.setAcquisitionDate(55, 8, headerInputStream, "yyyyMMdd");
            this.landsatHeader.setLoc(27, 9, 0, headerInputStream);
            this.landsatHeader.setInstrumentTyp(90, 2, headerInputStream);
            this.landsatHeader.setInstrumentMode(92, 2, headerInputStream);
            this.readAdministrationData(headerInputStream);
            this.readGeometricData(headerInputStream);
            this.readRadiometricData(headerInputStream);
        }
        finally {
            if (headerInputStream != null) {
                try {
                    headerInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void readAdministrationData(LandsatImageInputStream headerInputStream) throws IOException {
        this.landsatHeader.setBandsPresent(1361, 7, headerInputStream);
        this.landsatHeader.setBlockingFactor(1386, 4, headerInputStream);
        this.landsatHeader.setFormatVersion(1536, 1, headerInputStream);
        this.landsatHeader.setImageHeight(1108, 5, headerInputStream);
        this.landsatHeader.setLinesPerVolume(476, 5, headerInputStream);
        this.landsatHeader.setPixelSize(1064, 5, headerInputStream);
        this.landsatHeader.setImageWidth(1086, 5, headerInputStream);
        this.landsatHeader.setProductID(10, 11, headerInputStream);
        this.landsatHeader.setProductSize(138, 15, headerInputStream);
        this.landsatHeader.setProductType(109, 14, headerInputStream);
        this.landsatHeader.setRecordLength(1406, 5, headerInputStream);
        this.landsatHeader.setResampling(279, 2, headerInputStream);
        this.landsatHeader.setStartLine(456, 5, headerInputStream);
        this.landsatHeader.setTapeSpanningFlag(439, 3, headerInputStream);
        this.landsatHeader.setTypeOfProcessing(256, 10, headerInputStream);
    }

    private void readGeometricData(LandsatImageInputStream headerInputStream) throws IOException {
        GeometricData geoData = new GeometricData();
        geoData.setLookAngle(495, 6, headerInputStream);
        geoData.setSunElevationAngles(1427, 2, headerInputStream);
        geoData.setSunAzimuthAngles(1443, 3, headerInputStream);
        geoData.setHorizontalOffset(1528, 4, headerInputStream);
        geoData.setMapProjection(514, 4, headerInputStream);
        geoData.setEllipsoid(973, 20, headerInputStream);
        geoData.setSemiMajorAxis(1011, 11, headerInputStream);
        geoData.setSemiMinorAxis(1040, 11, headerInputStream);
        geoData.setMapZoneNumber(560, 6, headerInputStream);
        geoData.setProjectionNumber(538, 6, headerInputStream);
        geoData.setProjectionParameter(595, 360, headerInputStream);
        GeoPoint ul = new GeoPoint(LandsatConstants.Points.UPPER_LEFT);
        GeoPoint ll = new GeoPoint(LandsatConstants.Points.LOWER_LEFT);
        GeoPoint ur = new GeoPoint(LandsatConstants.Points.UPPER_RIGHT);
        GeoPoint lr = new GeoPoint(LandsatConstants.Points.LOWER_RIGHT);
        GeoPoint center = new GeoPoint(LandsatConstants.Points.CENTER);
        ul.setEasting(1144, 13, headerInputStream);
        ul.setNorthing(1158, 13, headerInputStream);
        ul.setGeodicLatitude(1131, 12, headerInputStream);
        ul.setGeodicLongitude(1117, 13, headerInputStream);
        ul.setPixelX(0);
        ul.sePixelY(0);
        ll.setEasting(1318, 13, headerInputStream);
        ll.setNorthing(1332, 13, headerInputStream);
        ll.setGeodicLatitude(1305, 12, headerInputStream);
        ll.setGeodicLongitude(1291, 13, headerInputStream);
        ll.setPixelX(0);
        ll.sePixelY(this.landsatHeader.getImageHeight() - 1);
        ur.setEasting(1202, 13, headerInputStream);
        ur.setNorthing(1216, 13, headerInputStream);
        ur.setGeodicLatitude(1189, 12, headerInputStream);
        ur.setGeodicLongitude(1175, 13, headerInputStream);
        ur.setPixelX(this.landsatHeader.getImageWidth() - 1);
        ur.sePixelY(0);
        lr.setEasting(1260, 13, headerInputStream);
        lr.setNorthing(1274, 13, headerInputStream);
        lr.setGeodicLatitude(1247, 12, headerInputStream);
        lr.setGeodicLongitude(1233, 13, headerInputStream);
        ur.setPixelX(this.landsatHeader.getImageWidth() - 1);
        ur.sePixelY(this.landsatHeader.getImageHeight() - 1);
        center.setEasting(1481, 13, headerInputStream);
        center.setNorthing(1495, 13, headerInputStream);
        center.setGeodicLatitude(1468, 12, headerInputStream);
        center.setGeodicLongitude(1454, 13, headerInputStream);
        String yString = LandsatUtils.getValueFromLandsatFile(headerInputStream, 1514, 6);
        center.sePixelY(Integer.parseInt(yString.trim()));
        String xString = LandsatUtils.getValueFromLandsatFile(headerInputStream, 1508, 6);
        center.setPixelX(Integer.parseInt(xString.trim()));
        geoData.addGeoPoint(ul);
        geoData.addGeoPoint(ur);
        geoData.addGeoPoint(ll);
        geoData.addGeoPoint(lr);
        geoData.addGeoPoint(center);
        this.landsatHeader.setGeoData(geoData);
    }

    private void readRadiometricData(LandsatImageInputStream headerInputStream) throws IOException {
        int[] bandsPresent = this.landsatHeader.getBandsPresent();
        int number = this.landsatHeader.getNumberOfBands();
        int size = 8;
        int offset = 301;
        int[] maxOffsets = Landsat5FAST.generateMaxRadianceOffsets(size, 301, number == 0 ? 7 : number);
        int[] minOffsets = Landsat5FAST.generateMinRadianceOffsets(size, 301 + size, number == 0 ? 7 : number);
        this.landsatHeader.setRadData(RadiometricData.createRadiometricData(maxOffsets, minOffsets, size, headerInputStream, bandsPresent));
    }

    private static int[] generateMaxRadianceOffsets(int sizeOfData, int startOffset, int numberOfBands) {
        int[] maxRad = new int[numberOfBands];
        for (int i = 0; i < numberOfBands; ++i) {
            maxRad[i] = i == 0 ? startOffset : maxRad[i - 1] + 2 * sizeOfData + 1;
        }
        return maxRad;
    }

    private static int[] generateMinRadianceOffsets(int sizeOfData, int startOffset, int numberOfBands) {
        int[] minRad = new int[numberOfBands];
        for (int i = 0; i < numberOfBands; ++i) {
            minRad[i] = i == 0 ? startOffset + 1 : minRad[i - 1] + 2 * sizeOfData + 1;
        }
        return minRad;
    }

    private void createBandReaders() throws IOException {
        if (this.landsatHeader != null) {
            int width = this.landsatHeader.getImageWidth();
            if (this.landsatBands != null) {
                for (LandsatTMBand tempBand : this.landsatBands) {
                    this.addBandReader(new LandsatByteBandReader(width, tempBand.getBandName(), tempBand.createStream()));
                }
            }
        } else {
            Debug.trace((String)"no landsat header object available!");
        }
    }

    private LandsatTMBand extractLandsatTMBand(LandsatConstants.ConstBand band) {
        for (LandsatTMBand element : this.landsatBands) {
            if (!element.toString().equalsIgnoreCase(band.toString())) continue;
            return element;
        }
        return null;
    }
}

