/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat.ceos;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.esa.s3tbx.dataio.landsat.GeometricData;
import org.esa.s3tbx.dataio.landsat.Landsat5TMBand;
import org.esa.s3tbx.dataio.landsat.LandsatBandReader;
import org.esa.s3tbx.dataio.landsat.LandsatConstants;
import org.esa.s3tbx.dataio.landsat.LandsatHeader;
import org.esa.s3tbx.dataio.landsat.LandsatImageInputStream;
import org.esa.s3tbx.dataio.landsat.LandsatLoc;
import org.esa.s3tbx.dataio.landsat.LandsatTMBand;
import org.esa.s3tbx.dataio.landsat.LandsatTMData;
import org.esa.s3tbx.dataio.landsat.LandsatTMFile;
import org.esa.s3tbx.dataio.landsat.LandsatUtils;
import org.esa.s3tbx.dataio.landsat.ceos.Landsat5CEOSConstants;
import org.esa.s3tbx.dataio.landsat.ceos.Landsat5CEOSImageSource;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.io.FileUtils;

public final class Landsat5CEOS
extends Landsat5CEOSConstants
implements LandsatTMData {
    private LandsatHeader landsatHeader;
    private LandsatTMBand[] landsatBands;
    private static final int FORMAT = 3;
    private static final String PRODUCT_NAME = "LANDSAT 5 TM SCENE";
    private LandsatTMFile inputFile = null;

    public Landsat5CEOS(LandsatTMFile inputFile) throws IOException {
        this.inputFile = inputFile;
        this.init();
    }

    @Override
    public final String getProductName() {
        return PRODUCT_NAME;
    }

    @Override
    public final LandsatHeader getHeader() {
        return this.landsatHeader;
    }

    @Override
    public final List getMetadata() {
        return new ArrayList();
    }

    @Override
    public final LandsatTMBand getBandAt(int idx) {
        return this.landsatBands[idx];
    }

    @Override
    public final int getFormat() {
        return 3;
    }

    private void init() throws IOException {
        this.landsatHeader = new LandsatHeader(this.inputFile);
        List<File> headerFiles = Landsat5CEOS.getHeaderFiles(this.landsatHeader.getPath());
        File aLeaderFile = Landsat5CEOS.getaLeaderFile(headerFiles);
        if (aLeaderFile == null) {
            Debug.trace((String)"No leader files could be found");
        }
        this.setHeaderFiles(headerFiles);
        LandsatImageInputStream leaderStream = this.landsatHeader.getHeaderInputStreamAt(aLeaderFile);
        if (leaderStream == null) {
            Debug.trace((String)"the stream of the leader file is not valid");
        }
        this.setLocation(leaderStream);
        this.setImageSize(leaderStream);
        this.setAdministrationData(leaderStream);
        this.setBandInformation(leaderStream);
        this.setGeoInformation(leaderStream);
    }

    private void setGeoInformation(LandsatImageInputStream inputStream) throws NumberFormatException, IOException {
        GeometricData geoData = new GeometricData();
        int RECORD_OFFSET = 8640;
        geoData.setSunElevationAngles(9245, Landsat5CEOSConstants.DataType.FLOAT16.toInt(), inputStream);
        geoData.setSunAzimuthAngles(9261, Landsat5CEOSConstants.DataType.FLOAT16.toInt(), inputStream);
        geoData.setLookAngle(8845, Landsat5CEOSConstants.DataType.DOUBLE16.toInt(), inputStream);
        this.landsatHeader.setGeoData(geoData);
    }

    private void setBandInformation(LandsatImageInputStream leaderStream) throws NumberFormatException, IOException {
        this.landsatHeader.setNumberOfBands(Integer.parseInt(LandsatUtils.getValueFromLandsatFile(leaderStream, 5733, 16).trim()));
        int number = this.landsatHeader.getNumberOfBands();
        if (number == 7) {
            this.landsatHeader.setBandsPresent(DEFAULT_BANDS);
        }
        Landsat5CEOSImageSource ceosImageSource = new Landsat5CEOSImageSource(this.inputFile);
        int[] presentBands = this.landsatHeader.getBandsPresent();
        this.landsatBands = new Landsat5TMBand[number];
        for (int i = 0; i < number; ++i) {
            ceosImageSource.getLandsatImageSourceAt(i);
            this.landsatBands[i] = new Landsat5TMBand(i, presentBands[i], ceosImageSource.getLandsatImageSourceAt(i), null, this.inputFile);
        }
    }

    private void setAdministrationData(LandsatImageInputStream leaderStream) throws NumberFormatException, IOException {
        this.landsatHeader.setAcquisitionDate(4437, Landsat5CEOSConstants.DataType.DATETIME14.toInt(), leaderStream, "yyyyMMddHHmmss");
        this.landsatHeader.setProductID(4341, 21, leaderStream);
    }

    private void setImageSize(LandsatImageInputStream leaderStream) throws IllegalArgumentException, IOException {
        this.landsatHeader.setImageWidth(5749, Landsat5CEOSConstants.DataType.INT16.toInt(), leaderStream);
        this.landsatHeader.setImageHeight(5765, Landsat5CEOSConstants.DataType.INT16.toInt(), leaderStream);
    }

    private void setLocation(LandsatImageInputStream leaderStream) throws IOException {
        String path = LandsatUtils.getValueFromLandsatFile(leaderStream, 4349, Landsat5CEOSConstants.DataType.STRING3);
        String row = LandsatUtils.getValueFromLandsatFile(leaderStream, 4352, Landsat5CEOSConstants.DataType.STRING3);
        this.landsatHeader.setLoc(new LandsatLoc(path, row));
    }

    private void setHeaderFiles(List<File> headerFiles) throws FileNotFoundException, IOException {
        for (File element : headerFiles) {
            this.landsatHeader.addHeaderFile(element);
        }
    }

    private static File getaLeaderFile(List<File> headerFiles) {
        String leaderFileString = "Lea";
        for (File element : headerFiles) {
            String fileName = element.getName();
            if (!fileName.contains(leaderFileString) && !fileName.contains(leaderFileString.toUpperCase())) continue;
            return element;
        }
        return null;
    }

    private static List<File> getHeaderFiles(String path) {
        Vector<File> headerFiles = new Vector<File>();
        File folder = new File(path);
        if (!folder.exists() || !folder.isDirectory()) {
            return null;
        }
        File[] filesInFolder = folder.listFiles();
        String[] headerNames = Landsat5CEOSConstants.CEOS_HEADER_NAMES;
        for (int i = 0; i < headerNames.length; ++i) {
            for (int j = 0; j < filesInFolder.length; ++j) {
                String fileName = FileUtils.getFilenameWithoutExtension((String)filesInFolder[j].getName());
                if (!fileName.equalsIgnoreCase(headerNames[i])) continue;
                headerFiles.add(filesInFolder[j]);
            }
        }
        return headerFiles;
    }

    @Override
    public final void close() {
        if (this.landsatHeader != null) {
            this.landsatHeader.close();
        }
    }

    @Override
    public final LandsatBandReader getBandReader(Band band) {
        return null;
    }

    @Override
    public final LandsatBandReader getBandReader(LandsatConstants.ConstBand band) {
        return null;
    }
}

