/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat;

import java.util.List;
import java.util.Vector;
import org.esa.s3tbx.dataio.landsat.LandsatConstants;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;

public class LandsatTMMetadata {
    private List<MetadataElement> landsatMetadataElements;

    private static MetadataAttribute createAttribute(String name, int intData) {
        ProductData data = ProductData.createInstance((int[])new int[]{intData});
        return new MetadataAttribute(name, data, true);
    }

    protected static MetadataAttribute createAttribute(String name, String stringData) {
        ProductData data = ProductData.createInstance((String)stringData);
        return new MetadataAttribute(name, data, true);
    }

    protected static MetadataAttribute createAttribute(String name, double doubleData) {
        ProductData data = ProductData.createInstance((double[])new double[]{doubleData});
        return new MetadataAttribute(name, data, true);
    }

    protected static MetadataAttribute createAttribute(String name, ProductData.UTC date) {
        return new MetadataAttribute(name, (ProductData)date, true);
    }

    private static MetadataAttribute createAttribute(String name, long longdata) {
        ProductData data = ProductData.createInstance((long[])new long[]{longdata});
        return new MetadataAttribute(name, data, true);
    }

    private static MetadataAttribute createAttribute(String name, float floatdata) {
        ProductData data = ProductData.createInstance((float[])new float[]{floatdata});
        return new MetadataAttribute(name, data, true);
    }

    protected static final MetadataAttribute createAttribute(String shortDescription, Object data, String description) {
        return LandsatTMMetadata.createAttribute(shortDescription, data, description, null);
    }

    protected static MetadataAttribute createAttribute(String shortDescription, Object data, String description, LandsatConstants.Unit unit) {
        MetadataAttribute attri;
        if (data instanceof String) {
            attri = LandsatTMMetadata.createAttribute(shortDescription, (String)data);
        } else if (data instanceof Integer) {
            attri = LandsatTMMetadata.createAttribute(shortDescription, (Integer)data);
        } else if (data instanceof Double) {
            attri = LandsatTMMetadata.createAttribute(shortDescription, (Double)data);
        } else if (data instanceof Long) {
            attri = LandsatTMMetadata.createAttribute(shortDescription, (Long)data);
        } else if (data instanceof Float) {
            attri = LandsatTMMetadata.createAttribute(shortDescription, ((Float)data).floatValue());
        } else if (data instanceof ProductData.UTC) {
            attri = LandsatTMMetadata.createAttribute(shortDescription, (ProductData.UTC)data);
        } else {
            return null;
        }
        attri.setDescription(description);
        if (unit != null) {
            attri.setUnit(unit.toString());
        }
        return attri;
    }

    public final List<MetadataElement> getLandsatMetadataElements() {
        return this.landsatMetadataElements;
    }

    protected final void addElement(MetadataElement element) {
        if (this.landsatMetadataElements == null) {
            this.landsatMetadataElements = new Vector<MetadataElement>();
        }
        this.landsatMetadataElements.add(element);
    }
}

