/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.esa.s3tbx.dataio.landsat.LandsatConstants;
import org.esa.s3tbx.dataio.landsat.LandsatTMBand;
import org.esa.s3tbx.dataio.landsat.LandsatTMFile;
import org.esa.s3tbx.dataio.landsat.RadiometricData;
import org.esa.snap.core.util.Guardian;

public final class Landsat5TMBand
implements LandsatTMBand {
    private static final int BEFORE1990 = 1;
    private static final int AFTER1990 = 0;
    private final int bandNumber;
    private final LandsatConstants.ConstBand bandConstants;
    private final LandsatConstants.NomRadiance radBefore2003Constants;
    private final LandsatConstants.NomRadiance radAfter2003Constants;
    private final Object imageSource;
    private double maxRadiance;
    private double minRadiance;
    private final LandsatTMFile file;

    public Landsat5TMBand(int index, int bandNumber, Object source, RadiometricData radData, LandsatTMFile file) {
        this.file = file;
        this.bandNumber = bandNumber;
        this.imageSource = source;
        this.bandConstants = LandsatConstants.ConstBand.getConstantBandAt(bandNumber);
        this.radBefore2003Constants = LandsatConstants.NomRadiance.getConstantRadAt(bandNumber, 1);
        this.radAfter2003Constants = LandsatConstants.NomRadiance.getConstantRadAt(bandNumber, 0);
        this.maxRadiance = 0.0;
        this.minRadiance = 0.0;
        if (radData != null && radData.isEnabled()) {
            this.maxRadiance = radData.getMaxRadianceAt(index);
            this.minRadiance = radData.getMinRadianceAt(index);
        }
    }

    @Override
    public Object getInputSource() {
        return this.imageSource;
    }

    @Override
    public final String getBandName() {
        return this.bandConstants.toString();
    }

    @Override
    public final String getBandDescription() {
        return this.bandConstants.getDescription();
    }

    @Override
    public final int getIndex() {
        return this.bandNumber;
    }

    @Override
    public final int getResolution() {
        return this.bandConstants.getResolution();
    }

    @Override
    public final float getBandwidth() {
        return this.bandConstants.getBandwidth();
    }

    @Override
    public final float getWavelength() {
        return this.bandConstants.getWavelength();
    }

    @Override
    public final double getMaxRadiance() {
        return this.maxRadiance;
    }

    @Override
    public final double getMinRadiance() {
        return this.minRadiance;
    }

    @Override
    public final double getFormerNomMaxRadiance() {
        return this.radBefore2003Constants.getLmax();
    }

    @Override
    public final double getFormerNomMinRadiance() {
        return this.radBefore2003Constants.getLmin();
    }

    @Override
    public final double getFormerNominalGain() {
        return this.radBefore2003Constants.getGain();
    }

    @Override
    public final double getNewerNomMaxRadiance() {
        return this.radAfter2003Constants.getLmax();
    }

    @Override
    public final double getNewerNomMinRadiance() {
        return this.radAfter2003Constants.getLmin();
    }

    @Override
    public final double getNewerNomGain() {
        return this.radAfter2003Constants.getGain();
    }

    @Override
    public final double getGain() {
        return Landsat5TMBand.calculateGain(this.minRadiance, this.maxRadiance, 0);
    }

    @Override
    public final double getBias() {
        return this.minRadiance;
    }

    public final String toString() {
        return this.bandConstants.toString();
    }

    @Override
    public final ImageInputStream createStream() throws IOException {
        Object bandSource = this.imageSource;
        ImageInputStream inputstream = null;
        if (bandSource instanceof File) {
            File file = (File)bandSource;
            inputstream = new FileImageInputStream(file);
        }
        if (bandSource instanceof ZipEntry) {
            ZipEntry entry = (ZipEntry)bandSource;
            ZipFile zipFile = new ZipFile(this.file.getInputFile());
            InputStream standardInputStream = zipFile.getInputStream(entry);
            inputstream = ImageIO.createImageInputStream(standardInputStream);
        }
        return inputstream;
    }

    @Override
    public final float getSolarFlux() {
        return this.bandConstants.getSolarFlux();
    }

    private static double calculateGain(double lMin, double lMax, int formular) {
        Guardian.assertTrue((String)"formular == AFTER1990 || formular == BEFORE1990", (formular == 0 || formular == 1 ? 1 : 0) != 0);
        double gain = 0.0;
        if (formular == 0) {
            gain = (lMax - lMin) / 255.0;
        }
        if (formular == 1) {
            gain = lMax / 254.0 - lMin / 244.0;
        }
        return gain;
    }

    @Override
    public final boolean isThermal() {
        return this.bandNumber == 6;
    }
}

