/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.insitu.ui;

import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.UriLabel;
import com.jidesoft.swing.MultilineLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.esa.s3tbx.insitu.server.InsituDataset;
import org.esa.snap.core.util.SystemUtils;

class DataPolicyPanel
extends JPanel {
    private ButtonModel acceptModel;

    public DataPolicyPanel(InsituDataset insituDataset) {
        TableLayout layout = new TableLayout(4);
        layout.setTableFill(TableLayout.Fill.HORIZONTAL);
        layout.setTableAnchor(TableLayout.Anchor.WEST);
        layout.setTablePadding(4, 4);
        layout.setRowWeightX(0, Double.valueOf(0.0));
        this.setLayout((LayoutManager)layout);
        String datasetLabelText = "<html><b>" + insituDataset.getName() + "</b>";
        if (insituDataset.getWebsite() != null && !insituDataset.getWebsite().isEmpty()) {
            URI websiteUri = null;
            try {
                websiteUri = new URI(insituDataset.getWebsite());
            }
            catch (URISyntaxException e) {
                SystemUtils.LOG.log(Level.SEVERE, "Could not create website url.", e);
            }
            UriLabel datasetNameLabel = new UriLabel(datasetLabelText, websiteUri);
            datasetNameLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.add((Component)datasetNameLabel);
        } else {
            this.add(new JLabel(datasetLabelText));
        }
        URI mailtoUri = null;
        try {
            mailtoUri = new URI("mailto:" + insituDataset.getContact());
        }
        catch (URISyntaxException e) {
            SystemUtils.LOG.log(Level.SEVERE, "Could not create mailto-url.", e);
        }
        UriLabel contact = new UriLabel(insituDataset.getPi(), mailtoUri);
        contact.setCursor(Cursor.getPredefinedCursor(12));
        this.add((Component)contact);
        this.add(layout.createHorizontalSpacer());
        JCheckBox accept = new JCheckBox("Accept");
        this.acceptModel = accept.getModel();
        this.add(accept);
        layout.setRowWeightY(1, Double.valueOf(1.0));
        layout.setCellColspan(1, 0, Integer.valueOf(4));
        layout.setRowFill(1, TableLayout.Fill.BOTH);
        MultilineLabel policyTextArea = new MultilineLabel();
        policyTextArea.setColumns(80);
        policyTextArea.setRows(6);
        policyTextArea.setBorder((Border)new LineBorder(Color.BLACK));
        policyTextArea.setText(insituDataset.getPolicy());
        this.add((Component)policyTextArea);
    }

    public boolean isAccepted() {
        return this.acceptModel.isSelected();
    }

    public void setAccepted(boolean accept) {
        this.acceptModel.setSelected(accept);
    }
}

