/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.insitu.ui;

import com.bc.ceres.core.ProgressMonitor;
import java.beans.PropertyChangeSupport;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.esa.s3tbx.insitu.server.InsituDataset;
import org.esa.s3tbx.insitu.server.InsituParameter;
import org.esa.s3tbx.insitu.server.InsituQuery;
import org.esa.s3tbx.insitu.server.InsituResponse;
import org.esa.s3tbx.insitu.server.InsituServer;
import org.esa.s3tbx.insitu.server.InsituServerException;
import org.esa.s3tbx.insitu.server.InsituServerRegistry;
import org.esa.s3tbx.insitu.server.InsituServerRunnable;
import org.esa.s3tbx.insitu.server.InsituServerSpi;
import org.esa.s3tbx.insitu.ui.Utils;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.ProgressHandleMonitor;

class InsituClientModel {
    static final InsituServerSpi NO_SELECTION_SERVER_SPI = new NoSelectionInsituServerSpi();
    static final String PROPERTY_START_DATE = "startDate";
    static final String PROPERTY_STOP_DATE = "stopDate";
    static final String PROPERTY_MIN_LON = "minLon";
    static final String PROPERTY_MAX_LON = "maxLon";
    static final String PROPERTY_MIN_LAT = "minLat";
    static final String PROPERTY_MAX_LAT = "maxLat";
    private final DefaultComboBoxModel<InsituServerSpi> insituServerModel;
    private final DefaultListModel<InsituDataset> datasetModel;
    private final ListSelectionModel datasetSelectionModel;
    private final DefaultListModel<InsituParameter> parameterModel;
    private final DefaultListSelectionModel parameterSelectionModel;
    private final DefaultListModel<Product> productListModel;
    private final DefaultListSelectionModel productSelectionModel;
    private Date startDate;
    private Date stopDate;
    private double minLon;
    private double maxLon;
    private double minLat;
    private double maxLat;
    private InsituServer selectedServer;
    private PMListener productManagerListener;
    private PropertyChangeSupport changeSupport;

    public InsituClientModel() {
        Product[] products;
        Set<InsituServerSpi> allRegisteredServers = InsituServerRegistry.getInstance().getAllRegisteredServers();
        InsituServerSpi[] servers = allRegisteredServers.toArray(new InsituServerSpi[0]);
        this.insituServerModel = new DefaultComboBoxModel<InsituServerSpi>(servers);
        this.insituServerModel.insertElementAt(NO_SELECTION_SERVER_SPI, 0);
        this.insituServerModel.setSelectedItem(NO_SELECTION_SERVER_SPI);
        this.insituServerModel.addListDataListener(new ServerListener());
        this.datasetModel = new DefaultListModel();
        this.datasetSelectionModel = new DefaultListSelectionModel();
        this.datasetSelectionModel.setSelectionMode(2);
        this.datasetSelectionModel.addListSelectionListener(new DatasetListSelectionListener());
        this.parameterModel = new DefaultListModel();
        this.parameterSelectionModel = new DefaultListSelectionModel();
        this.productListModel = new DefaultListModel();
        this.productSelectionModel = new DefaultListSelectionModel();
        this.productSelectionModel.setSelectionMode(2);
        this.productSelectionModel.addListSelectionListener(new ProductListSelectionListener());
        ProductManager productManager = SnapApp.getDefault().getProductManager();
        for (Product product : products = productManager.getProducts()) {
            this.productListModel.addElement(product);
        }
        this.productManagerListener = new PMListener(productManager);
        productManager.addListener((ProductManager.Listener)this.productManagerListener);
        TimeSpan timeSpan = TimeSpan.create(Collections.emptyList());
        this.startDate = timeSpan.startDate;
        this.stopDate = timeSpan.stopDate;
        MinMaxGeoCoordinates minMaxGeoCoordinates = MinMaxGeoCoordinates.create(Collections.emptyList());
        this.minLon = minMaxGeoCoordinates.getMinLon();
        this.maxLon = minMaxGeoCoordinates.getMaxLon();
        this.minLat = minMaxGeoCoordinates.getMinLat();
        this.maxLat = minMaxGeoCoordinates.getMaxLat();
        this.changeSupport = new PropertyChangeSupport(this);
    }

    public PropertyChangeSupport getChangeSupport() {
        return this.changeSupport;
    }

    public DefaultComboBoxModel<InsituServerSpi> getInsituServerModel() {
        return this.insituServerModel;
    }

    public InsituServerSpi getSelectedServerSpi() {
        return (InsituServerSpi)this.insituServerModel.getSelectedItem();
    }

    public DefaultListModel<InsituDataset> getDatasetModel() {
        return this.datasetModel;
    }

    public ListSelectionModel getDatasetSelectionModel() {
        return this.datasetSelectionModel;
    }

    public List<InsituDataset> getSelectedDatasets() {
        return Utils.getSelectedItems(this.datasetModel, this.datasetSelectionModel);
    }

    public String[] getSelectedDatasetNames() {
        List<InsituDataset> datasets = this.getSelectedDatasets();
        return (String[])datasets.stream().map(InsituDataset::getName).toArray(String[]::new);
    }

    public DefaultListModel<InsituParameter> getParameterModel() {
        return this.parameterModel;
    }

    public DefaultListSelectionModel getParameterSelectionModel() {
        return this.parameterSelectionModel;
    }

    public List<InsituParameter> getSelectedParameters() {
        return Utils.getSelectedItems(this.parameterModel, this.parameterSelectionModel);
    }

    public DefaultListModel<Product> getProductListModel() {
        return this.productListModel;
    }

    public DefaultListSelectionModel getProductSelectionModel() {
        return this.productSelectionModel;
    }

    public List<Product> getSelectedProducts() {
        return Utils.getSelectedItems(this.productListModel, this.productSelectionModel);
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        if (this.startDate.equals(startDate)) {
            return;
        }
        Date oldValue = this.startDate;
        this.startDate = startDate;
        this.changeSupport.firePropertyChange(PROPERTY_START_DATE, oldValue, startDate);
    }

    public Date getStopDate() {
        return this.stopDate;
    }

    public void setStopDate(Date stopDate) {
        if (this.stopDate.equals(stopDate)) {
            return;
        }
        Date oldValue = this.stopDate;
        this.stopDate = stopDate;
        this.changeSupport.firePropertyChange(PROPERTY_STOP_DATE, oldValue, stopDate);
    }

    public double getMinLon() {
        return this.minLon;
    }

    public void setMinLon(double minLon) {
        if (this.minLon == minLon) {
            return;
        }
        double oldValue = this.minLon;
        this.minLon = minLon;
        this.changeSupport.firePropertyChange(PROPERTY_MIN_LON, oldValue, minLon);
    }

    public double getMaxLon() {
        return this.maxLon;
    }

    public void setMaxLon(double maxLon) {
        if (this.maxLon == maxLon) {
            return;
        }
        double oldValue = this.maxLon;
        this.maxLon = maxLon;
        this.changeSupport.firePropertyChange(PROPERTY_MAX_LON, oldValue, maxLon);
    }

    public double getMinLat() {
        return this.minLat;
    }

    public void setMinLat(double minLat) {
        if (this.minLat == minLat) {
            return;
        }
        double oldValue = this.minLat;
        this.minLat = minLat;
        this.changeSupport.firePropertyChange(PROPERTY_MIN_LAT, oldValue, minLat);
    }

    public double getMaxLat() {
        return this.maxLat;
    }

    public void setMaxLat(double maxLat) {
        if (this.maxLat == maxLat) {
            return;
        }
        double oldValue = this.maxLat;
        this.maxLat = maxLat;
        this.changeSupport.firePropertyChange(PROPERTY_MAX_LAT, oldValue, maxLat);
    }

    static Calendar createUtcCalendar() {
        Calendar utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        utcCalendar.set(11, 12);
        utcCalendar.set(12, 0);
        utcCalendar.set(13, 0);
        utcCalendar.set(14, 0);
        return utcCalendar;
    }

    public void dispose() {
        SnapApp.getDefault().getProductManager().removeListener((ProductManager.Listener)this.productManagerListener);
    }

    private void updateDatasetModel(InsituServer server) throws InsituServerException {
        this.getDatasetModel().clear();
        InsituQuery query = new InsituQuery().subject(InsituQuery.SUBJECT.DATASETS);
        InsituServerRunnable runnable = new InsituServerRunnable(server, query);
        InsituServer.runWithProgress(runnable);
        runnable.getResponse().getDatasets().forEach(this.datasetModel::addElement);
    }

    private void updateParameterModel(InsituServer server) throws InsituServerException {
        this.getParameterModel().clear();
        InsituQuery query = new InsituQuery().subject(InsituQuery.SUBJECT.PARAMETERS);
        String[] datasetNames = this.getSelectedDatasetNames();
        if (datasetNames.length > 0) {
            query.datasets(datasetNames);
        }
        InsituResponse insituResponse = server.query(query);
        insituResponse.getParameters().forEach(this.parameterModel::addElement);
    }

    static class TimeSpan {
        private Date startDate;
        private Date stopDate;

        private TimeSpan() {
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public Date getStopDate() {
            return this.stopDate;
        }

        static TimeSpan create(List<Product> products) {
            TimeSpan timeSpan = new TimeSpan();
            Calendar utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            utcCalendar.set(11, 12);
            utcCalendar.set(12, 0);
            utcCalendar.set(13, 0);
            utcCalendar.set(14, 0);
            timeSpan.startDate = utcCalendar.getTime();
            utcCalendar.set(1970, 0, 1);
            timeSpan.stopDate = utcCalendar.getTime();
            for (Product product : products) {
                ProductData.UTC endTime;
                ProductData.UTC startTime = product.getStartTime();
                if (startTime != null) {
                    timeSpan.startDate = TimeSpan.min(timeSpan.startDate, startTime.getAsDate());
                }
                if ((endTime = product.getEndTime()) == null) continue;
                timeSpan.stopDate = TimeSpan.max(timeSpan.stopDate, endTime.getAsDate());
            }
            if (timeSpan.stopDate.before(timeSpan.startDate)) {
                Date temp = timeSpan.stopDate;
                timeSpan.stopDate = timeSpan.startDate;
                timeSpan.startDate = temp;
            }
            return timeSpan;
        }

        private static Date min(Date date1, Date date2) {
            return date1.before(date2) ? date1 : date2;
        }

        private static Date max(Date date1, Date date2) {
            return date1.after(date2) ? date1 : date2;
        }
    }

    static class MinMaxGeoCoordinates {
        private double minLat;
        private double maxLat;
        private double minLon;
        private double maxLon;

        private MinMaxGeoCoordinates() {
        }

        public double getMinLat() {
            return this.minLat;
        }

        public double getMaxLat() {
            return this.maxLat;
        }

        public double getMinLon() {
            return this.minLon;
        }

        public double getMaxLon() {
            return this.maxLon;
        }

        public static MinMaxGeoCoordinates create(List<Product> products) {
            MinMaxGeoCoordinates coordinates = new MinMaxGeoCoordinates();
            coordinates.minLat = 90.0;
            coordinates.maxLat = -90.0;
            coordinates.minLon = 180.0;
            coordinates.maxLon = -180.0;
            for (Product product : products) {
                GeoPos[] corners;
                if (product.getSceneGeoCoding() == null) continue;
                for (GeoPos corner : corners = MinMaxGeoCoordinates.createCornerCoordinates(product)) {
                    coordinates.minLat = Math.min(coordinates.minLat, corner.getLat());
                    coordinates.maxLat = Math.max(coordinates.maxLat, corner.getLat());
                    coordinates.minLon = Math.min(coordinates.minLon, corner.getLon());
                    coordinates.maxLon = Math.max(coordinates.maxLon, corner.getLon());
                }
            }
            if (coordinates.maxLat < coordinates.minLat) {
                double temp = coordinates.maxLat;
                coordinates.maxLat = coordinates.minLat;
                coordinates.minLat = temp;
            }
            if (coordinates.maxLon < coordinates.minLon) {
                double temp = coordinates.maxLon;
                coordinates.maxLon = coordinates.minLon;
                coordinates.minLon = temp;
            }
            return coordinates;
        }

        private static GeoPos[] createCornerCoordinates(Product product) {
            PixelPos sceneUL = new PixelPos(0.5, 0.5);
            PixelPos sceneUR = new PixelPos((double)((float)(product.getSceneRasterWidth() - 1) + 0.5f), 0.5);
            PixelPos sceneLL = new PixelPos(0.5, (double)((float)(product.getSceneRasterHeight() - 1) + 0.5f));
            PixelPos sceneLR = new PixelPos((double)((float)(product.getSceneRasterWidth() - 1) + 0.5f), (double)((float)(product.getSceneRasterHeight() - 1) + 0.5f));
            GeoCoding sceneGeoCoding = product.getSceneGeoCoding();
            GeoPos geoPosUL = sceneGeoCoding.getGeoPos(sceneUL, null);
            GeoPos geoPosUR = sceneGeoCoding.getGeoPos(sceneUR, null);
            GeoPos geoPosLL = sceneGeoCoding.getGeoPos(sceneLL, null);
            GeoPos geoPosLR = sceneGeoCoding.getGeoPos(sceneLR, null);
            return new GeoPos[]{geoPosUL, geoPosUR, geoPosLL, geoPosLR};
        }
    }

    private class ProductListSelectionListener
    implements ListSelectionListener {
        private ProductListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ProgressHandleMonitor handle = ProgressHandleMonitor.create((String)"In-Situ Data Access");
            Runnable runnable = () -> this.updateTemporalAndSpatialBounds((ProgressMonitor)handle);
            Utils.runWithProgress(runnable, handle);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateTemporalAndSpatialBounds(ProgressMonitor pm) {
            pm.beginTask("Computing temporal and spatial bounds", 2);
            try {
                List<Product> products = InsituClientModel.this.getSelectedProducts();
                TimeSpan timeSpan = TimeSpan.create(products);
                pm.worked(1);
                MinMaxGeoCoordinates minMaxGeoCoordinates = MinMaxGeoCoordinates.create(products);
                pm.worked(1);
                InsituClientModel.this.setStartDate(timeSpan.getStartDate());
                InsituClientModel.this.setStopDate(timeSpan.getStopDate());
                InsituClientModel.this.setMinLat(minMaxGeoCoordinates.getMinLat());
                InsituClientModel.this.setMaxLat(minMaxGeoCoordinates.getMaxLat());
                InsituClientModel.this.setMinLon(minMaxGeoCoordinates.getMinLon());
                InsituClientModel.this.setMaxLon(minMaxGeoCoordinates.getMaxLon());
            }
            finally {
                pm.done();
            }
        }
    }

    private class PMListener
    implements ProductManager.Listener {
        private final ProductManager productManager;

        public PMListener(ProductManager productManager) {
            this.productManager = productManager;
        }

        public void productAdded(ProductManager.Event event) {
            Product product = event.getProduct();
            int productIndex = this.productManager.getProductIndex(product);
            InsituClientModel.this.productListModel.add(productIndex, product);
        }

        public void productRemoved(ProductManager.Event event) {
            Product product = event.getProduct();
            int productIndex = InsituClientModel.this.productListModel.indexOf(product);
            InsituClientModel.this.productListModel.remove(productIndex);
        }
    }

    private class DatasetListSelectionListener
    implements ListSelectionListener {
        private DatasetListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (!event.getValueIsAdjusting() && InsituClientModel.this.selectedServer != null) {
                try {
                    InsituClientModel.this.updateParameterModel(InsituClientModel.this.selectedServer);
                }
                catch (InsituServerException e) {
                    SnapApp.getDefault().handleError("Failed to retrieve metadata from server", (Throwable)e);
                }
            }
        }
    }

    private class ServerListener
    implements ListDataListener {
        private ServerListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }

        @Override
        public void contentsChanged(ListDataEvent event) {
            if (event.getIndex0() == -1 && event.getIndex1() == -1) {
                InsituServerSpi insituServerSpi = InsituClientModel.this.getSelectedServerSpi();
                try {
                    InsituClientModel.this.selectedServer = insituServerSpi.createServer();
                    InsituClientModel.this.updateDatasetModel(InsituClientModel.this.selectedServer);
                    InsituClientModel.this.updateParameterModel(InsituClientModel.this.selectedServer);
                }
                catch (Exception e) {
                    InsituClientModel.this.insituServerModel.setSelectedItem(NO_SELECTION_SERVER_SPI);
                    throw new IllegalStateException("Could not create server instance for server '" + insituServerSpi.getName() + "'", e);
                }
            }
        }
    }

    private static class NoSelectionInsituServerSpi
    implements InsituServerSpi {
        private NoSelectionInsituServerSpi() {
        }

        @Override
        public String getName() {
            return "<NO_SERVER_CURRENTLY_SELECTED>";
        }

        @Override
        public String getDescription() {
            return "Please select one of the available in-situ server";
        }

        @Override
        public InsituServer createServer() throws InsituServerException {
            return new InsituServer(){

                @Override
                public String getName() {
                    return "NO_SERVER";
                }

                @Override
                public InsituResponse query(InsituQuery query) throws InsituServerException {
                    return InsituResponse.EMPTY_RESPONSE;
                }
            };
        }
    }
}

