/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.insitu.server.mermaid;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.esa.s3tbx.insitu.server.InsituQuery;
import org.esa.snap.core.util.StringUtils;

class MermaidQueryFormatter {
    private static final String PARAMETERS_SUBJECT = "parameters";
    private static final String CAMPAIGNS_SUBJECT = "campaigns";
    private static final String OBSERVATIONS_SUBJECT = "observations";
    private static final String PARAM_LON_MIN = "lon_min";
    private static final String PARAM_LAT_MIN = "lat_min";
    private static final String PARAM_LON_MAX = "lon_max=";
    private static final String PARAM_LAT_MAX = "lat_max";
    private static final String PARAM_START_DATE = "start_date";
    private static final String PARAM_STOP_DATE = "stop_date";
    private static final String PARAM_PARAM = "param";
    private static final String PARAM_CAMPAIGN = "campaign";
    private static final String PARAM_SHIFT = "shift";
    private static final String PARAM_LIMIT = "limit";
    private static final String PARAM_COUNT_ONLY = "count_only";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    MermaidQueryFormatter() {
    }

    public static String format(InsituQuery query) {
        ArrayList<String> queryParams = new ArrayList<String>();
        if (query.lonMin() != null) {
            queryParams.add("lon_min=" + query.lonMin());
        }
        if (query.latMin() != null) {
            queryParams.add("lat_min=" + query.latMin());
        }
        if (query.lonMax() != null) {
            queryParams.add(PARAM_LON_MAX + query.lonMax());
        }
        if (query.latMax() != null) {
            queryParams.add("lat_max=" + query.latMax());
        }
        if (query.startDate() != null) {
            try {
                queryParams.add("start_date=" + URLEncoder.encode(DATE_FORMAT.format(query.startDate()), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("start date could not be encoded", e);
            }
        }
        if (query.stopDate() != null) {
            try {
                queryParams.add("stop_date=" + URLEncoder.encode(DATE_FORMAT.format(query.stopDate()), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("stop date could not be encoded", e);
            }
        }
        if (query.param() != null && query.param().length > 0) {
            queryParams.add("param=" + StringUtils.arrayToCsv((Object)query.param()));
        }
        if (query.datasets() != null && query.datasets().length > 0) {
            queryParams.add("campaign=" + StringUtils.arrayToCsv((Object)query.datasets()));
        }
        if (query.shift() > 0) {
            queryParams.add("shift=" + query.shift());
        }
        if (query.limit() > 0) {
            queryParams.add("limit=" + query.limit());
        }
        if (query.countOnly()) {
            queryParams.add(PARAM_COUNT_ONLY);
        }
        if (query.subject() == null) {
            throw new IllegalArgumentException("subject must be specified");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("/");
        switch (query.subject()) {
            case DATASETS: {
                sb.append(CAMPAIGNS_SUBJECT);
                break;
            }
            case PARAMETERS: {
                sb.append(PARAMETERS_SUBJECT);
                break;
            }
            case OBSERVATIONS: {
                sb.append(OBSERVATIONS_SUBJECT);
            }
        }
        sb.append("?");
        for (int i = 0; i < queryParams.size(); ++i) {
            String queryParam = (String)queryParams.get(i);
            sb.append(queryParam);
            if (i >= queryParams.size() - 1) continue;
            sb.append("&");
        }
        return sb.toString();
    }
}

