/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.insitu.server;

import org.esa.s3tbx.insitu.server.InsituQuery;
import org.esa.s3tbx.insitu.server.InsituResponse;
import org.esa.s3tbx.insitu.server.InsituServer;
import org.esa.snap.rcp.util.ProgressHandleMonitor;
import org.openide.util.Cancellable;

public class InsituServerRunnable
implements Runnable,
Cancellable {
    private final ProgressHandleMonitor handle;
    private final InsituServer server;
    private final InsituQuery query;
    private Exception exception;
    private InsituResponse response;

    public InsituServerRunnable(InsituServer server, InsituQuery query) {
        this(ProgressHandleMonitor.create((String)"Accessing In-Situ Server"), server, query);
    }

    public InsituServerRunnable(ProgressHandleMonitor handle, InsituServer server, InsituQuery query) {
        this.handle = handle;
        this.server = server;
        this.query = query;
        this.response = InsituResponse.EMPTY_RESPONSE;
    }

    public ProgressHandleMonitor getHandle() {
        return this.handle;
    }

    public InsituResponse getResponse() {
        return this.response;
    }

    public Exception getException() {
        return this.exception;
    }

    @Override
    public final void run() {
        this.handle.beginTask("Contacting " + this.server.getName() + " in-situ server", -1);
        try {
            this.response = this.server.query(this.query);
        }
        catch (Exception e) {
            this.exception = e;
        }
        finally {
            this.handle.done();
        }
    }

    public boolean cancel() {
        return this.handle.cancel();
    }
}

