/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.insitu.server;

import com.bc.ceres.core.ServiceRegistry;
import com.bc.ceres.core.ServiceRegistryManager;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.esa.s3tbx.insitu.server.InsituServerSpi;
import org.esa.snap.SnapCoreActivator;

public class InsituServerRegistry {
    private ServiceRegistry<InsituServerSpi> registry = ServiceRegistryManager.getInstance().getServiceRegistry(InsituServerSpi.class);

    public static InsituServerRegistry getInstance() {
        return Holder.instance;
    }

    private InsituServerRegistry() {
        SnapCoreActivator.loadServices(this.registry);
    }

    public Set<InsituServerSpi> getAllRegisteredServers() {
        return Collections.unmodifiableSet(this.registry.getServices());
    }

    public InsituServerSpi getRegisteredServer(String serverName) {
        Optional<InsituServerSpi> optional = this.findSpi(serverName);
        return optional.isPresent() ? optional.get() : null;
    }

    boolean addServer(InsituServerSpi serverSpi) {
        Optional<InsituServerSpi> first = this.findSpi(serverSpi.getName());
        return !first.isPresent() && this.registry.addService((Object)serverSpi);
    }

    boolean removeServer(String serverName) {
        Optional<InsituServerSpi> first = this.findSpi(serverName);
        return first.isPresent() && this.removeServer(first.get());
    }

    boolean removeServer(InsituServerSpi serverSpi) {
        return this.registry.removeService((Object)serverSpi);
    }

    private Optional<InsituServerSpi> findSpi(String name) {
        return this.registry.getServices().stream().filter(inSituServerSpi -> inSituServerSpi.getName().equals(name)).findFirst();
    }

    private static class Holder {
        private static final InsituServerRegistry instance = new InsituServerRegistry();

        private Holder() {
        }
    }
}

