/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.idepix.ui;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.PropertyPane;
import com.bc.ceres.swing.selection.AbstractSelectionChangeListener;
import com.bc.ceres.swing.selection.Selection;
import com.bc.ceres.swing.selection.SelectionChangeEvent;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.esa.s3tbx.idepix.algorithms.landsat8.NNSelector;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.descriptor.OperatorDescriptor;
import org.esa.snap.core.gpf.internal.RasterDataNodeValues;
import org.esa.snap.core.gpf.ui.DefaultIOParametersPanel;
import org.esa.snap.core.gpf.ui.OperatorMenu;
import org.esa.snap.core.gpf.ui.OperatorParameterSupport;
import org.esa.snap.core.gpf.ui.SingleTargetProductDialog;
import org.esa.snap.core.gpf.ui.SourceProductSelector;
import org.esa.snap.core.gpf.ui.TargetProductSelectorModel;
import org.esa.snap.ui.AppContext;

public class IdepixLandsat8Dialog
extends SingleTargetProductDialog {
    private final String operatorName;
    private final OperatorDescriptor operatorDescriptor;
    private DefaultIOParametersPanel ioParametersPanel;
    private final OperatorParameterSupport parameterSupport;
    private final BindingContext bindingContext;
    private JTabbedPane form;
    private PropertyDescriptor[] rasterDataNodeTypeProperties;
    private String targetProductNameSuffix;
    private ProductChangedHandler productChangedHandler;
    private JPanel parametersPanel;
    private JComboBox nnSelectionComboBox;

    public IdepixLandsat8Dialog(String operatorName, AppContext appContext, String title, String helpID) {
        super(appContext, title, 24, helpID);
        this.operatorName = operatorName;
        this.targetProductNameSuffix = "";
        OperatorSpi operatorSpi = GPF.getDefaultInstance().getOperatorSpiRegistry().getOperatorSpi(operatorName);
        if (operatorSpi == null) {
            throw new IllegalArgumentException("No SPI found for operator name '" + operatorName + "'");
        }
        this.operatorDescriptor = operatorSpi.getOperatorDescriptor();
        this.ioParametersPanel = new DefaultIOParametersPanel(this.getAppContext(), this.operatorDescriptor, this.getTargetProductSelector());
        this.parameterSupport = new OperatorParameterSupport(this.operatorDescriptor);
        ArrayList sourceProductSelectorList = this.ioParametersPanel.getSourceProductSelectorList();
        PropertySet propertySet = this.parameterSupport.getPropertySet();
        this.bindingContext = new BindingContext(propertySet);
        if (propertySet.getProperties().length > 0 && !sourceProductSelectorList.isEmpty()) {
            Property[] properties = propertySet.getProperties();
            ArrayList<PropertyDescriptor> rdnTypeProperties = new ArrayList<PropertyDescriptor>(properties.length);
            for (Property property : properties) {
                PropertyDescriptor parameterDescriptor = property.getDescriptor();
                if (parameterDescriptor.getAttribute("rasterDataNodeType") == null) continue;
                rdnTypeProperties.add(parameterDescriptor);
            }
            this.rasterDataNodeTypeProperties = rdnTypeProperties.toArray(new PropertyDescriptor[rdnTypeProperties.size()]);
        }
        this.productChangedHandler = new ProductChangedHandler();
        if (!sourceProductSelectorList.isEmpty()) {
            ((SourceProductSelector)sourceProductSelectorList.get(0)).addSelectionChangeListener((SelectionChangeListener)this.productChangedHandler);
        }
    }

    public int show() {
        this.ioParametersPanel.initSourceProductSelectors();
        if (this.form == null) {
            this.initForm();
            if (this.getJDialog().getJMenuBar() == null) {
                OperatorMenu operatorMenu = this.createDefaultMenuBar();
                this.getJDialog().setJMenuBar(operatorMenu.createDefaultMenu());
            }
        }
        this.setContent(this.form);
        return super.show();
    }

    public void hide() {
        this.productChangedHandler.releaseProduct();
        this.ioParametersPanel.releaseSourceProductSelectors();
        super.hide();
    }

    protected Product createTargetProduct() throws Exception {
        HashMap sourceProducts = this.ioParametersPanel.createSourceProductsMap();
        return GPF.createProduct((String)this.operatorName, (Map)this.parameterSupport.getParameterMap(), (Map)sourceProducts);
    }

    public String getTargetProductNameSuffix() {
        return this.targetProductNameSuffix;
    }

    public void setTargetProductNameSuffix(String suffix) {
        this.targetProductNameSuffix = suffix;
    }

    private void initForm() {
        this.form = new JTabbedPane();
        this.form.add("I/O Parameters", (Component)this.ioParametersPanel);
        if (this.bindingContext.getPropertySet().getProperties().length > 0) {
            PropertyPane parametersPane = new PropertyPane(this.bindingContext);
            this.parametersPanel = parametersPane.createPanel();
            this.initNNSelectionComboBox();
            this.parametersPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
            this.form.add("Processing Parameters", new JScrollPane(this.parametersPanel));
            this.updateSourceProduct();
        }
    }

    private void initNNSelectionComboBox() {
        if (this.parametersPanel != null && this.parametersPanel.getComponents() != null) {
            final Component[] components = this.parametersPanel.getComponents();
            for (int i = 0; i < components.length - 1; ++i) {
                if (components[i].getName() == null || !components[i].getName().equals("nnSelector") || this.nnSelectionComboBox != null) continue;
                this.nnSelectionComboBox = (JComboBox)components[i];
                this.nnSelectionComboBox.setRenderer(new NNSelectionRenderer());
                this.nnSelectionComboBox.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        NNSelector nnSelector = (NNSelector)IdepixLandsat8Dialog.this.nnSelectionComboBox.getSelectedItem();
                        IdepixLandsat8Dialog.this.updateSeparationDefaultValues(nnSelector, components);
                    }
                });
            }
        }
    }

    private void updateSeparationDefaultValues(NNSelector nnSelector, Component[] components) {
        for (int i = 0; i < components.length - 1; ++i) {
            if (components[i].getName() != null && components[i].getName().equals("nnCloudAmbiguousLowerBoundaryValue")) {
                JTextField nnCloudAmbiguousLowerBoundaryValueTextField = (JTextField)components[i];
                nnCloudAmbiguousLowerBoundaryValueTextField.setText(String.valueOf(nnSelector.getSeparationValues()[0]));
            }
            if (components[i].getName() != null && components[i].getName().equals("nnCloudAmbiguousSureSeparationValue")) {
                JTextField nnCloudAmbiguousSureSeparationValueTextField = (JTextField)components[i];
                nnCloudAmbiguousSureSeparationValueTextField.setText(String.valueOf(nnSelector.getSeparationValues()[1]));
            }
            if (components[i].getName() == null || !components[i].getName().equals("nnCloudSureSnowSeparationValue")) continue;
            JTextField nnCloudSureSnowSeparationValueTextField = (JTextField)components[i];
            nnCloudSureSnowSeparationValueTextField.setText(String.valueOf(nnSelector.getSeparationValues()[2]));
        }
    }

    private OperatorMenu createDefaultMenuBar() {
        return new OperatorMenu((Component)this.getJDialog(), this.operatorDescriptor, this.parameterSupport, this.getAppContext(), this.getHelpID());
    }

    private void updateSourceProduct() {
        try {
            Property property = this.bindingContext.getPropertySet().getProperty("SOURCE_PRODUCT");
            if (property != null) {
                property.setValue((Object)this.productChangedHandler.currentProduct);
            }
        }
        catch (ValidationException e) {
            throw new IllegalStateException("Property 'SOURCE_PRODUCT' must be of type " + Product.class + ".", e);
        }
    }

    private static class NNSelectionRenderer
    extends DefaultListCellRenderer {
        private NNSelectionRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component cellRendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (cellRendererComponent instanceof JLabel && value instanceof NNSelector) {
                JLabel label = (JLabel)cellRendererComponent;
                NNSelector nn = (NNSelector)value;
                label.setText(nn.getLabel());
            }
            return cellRendererComponent;
        }
    }

    private class ProductChangedHandler
    extends AbstractSelectionChangeListener
    implements ProductNodeListener {
        private Product currentProduct;

        private ProductChangedHandler() {
        }

        public void releaseProduct() {
            if (this.currentProduct != null) {
                this.currentProduct.removeProductNodeListener((ProductNodeListener)this);
                this.currentProduct = null;
                IdepixLandsat8Dialog.this.updateSourceProduct();
            }
        }

        public void selectionChanged(SelectionChangeEvent event) {
            Product selectedProduct;
            Selection selection = event.getSelection();
            if (selection != null && (selectedProduct = (Product)selection.getSelectedValue()) != null && selectedProduct != this.currentProduct) {
                if (this.currentProduct != null) {
                    this.currentProduct.removeProductNodeListener((ProductNodeListener)this);
                }
                this.currentProduct = selectedProduct;
                this.currentProduct.addProductNodeListener((ProductNodeListener)this);
                this.updateTargetProductName();
                this.updateValueSets(this.currentProduct);
                IdepixLandsat8Dialog.this.updateSourceProduct();
            }
        }

        public void nodeAdded(ProductNodeEvent event) {
            this.handleProductNodeEvent();
        }

        public void nodeChanged(ProductNodeEvent event) {
            this.handleProductNodeEvent();
        }

        public void nodeDataChanged(ProductNodeEvent event) {
            this.handleProductNodeEvent();
        }

        public void nodeRemoved(ProductNodeEvent event) {
            this.handleProductNodeEvent();
        }

        private void updateTargetProductName() {
            String productName = "";
            if (this.currentProduct != null) {
                productName = this.currentProduct.getName();
            }
            TargetProductSelectorModel targetProductSelectorModel = IdepixLandsat8Dialog.this.getTargetProductSelector().getModel();
            targetProductSelectorModel.setProductName(productName + IdepixLandsat8Dialog.this.getTargetProductNameSuffix());
        }

        private void handleProductNodeEvent() {
            this.updateValueSets(this.currentProduct);
        }

        private void updateValueSets(Product product) {
            if (IdepixLandsat8Dialog.this.rasterDataNodeTypeProperties != null) {
                for (PropertyDescriptor propertyDescriptor : IdepixLandsat8Dialog.this.rasterDataNodeTypeProperties) {
                    this.updateValueSet(propertyDescriptor, product);
                }
            }
        }

        private void updateValueSet(PropertyDescriptor propertyDescriptor, Product product) {
            Object object;
            Object[] values = new String[]{};
            if (product != null && (object = propertyDescriptor.getAttribute("rasterDataNodeType")) != null) {
                Class rasterDataNodeType = (Class)object;
                boolean includeEmptyValue = !propertyDescriptor.isNotNull() && !propertyDescriptor.isNotEmpty() && !propertyDescriptor.getType().isArray();
                values = RasterDataNodeValues.getNames((Product)product, (Class)rasterDataNodeType, (boolean)includeEmptyValue);
            }
            propertyDescriptor.setValueSet(new ValueSet(values));
        }
    }
}

