/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.fu;

import com.bc.ceres.core.Assert;
import org.esa.s3tbx.fu.FuResult;
import org.esa.s3tbx.fu.FuResultImpl;
import org.esa.s3tbx.fu.Instrument;

class FuAlgo {
    public static final byte MAX_FU_VALUE = 21;
    private static final double CONST_WHITE_POINT = 0.333333;
    private static final double[] ANGLE_OF_TRANSITIONS = new double[]{232.0, 227.168, 220.977, 209.994, 190.779, 163.084, 132.999, 109.054, 94.037, 83.346, 74.572, 67.957, 62.186, 56.435, 50.665, 45.129, 39.769, 34.906, 30.439, 26.337, 22.741, 19.0, 19.0};
    private double[] x3Factors;
    private double[] y3Factors;
    private double[] z3Factors;
    private double[] polyCoeffs;

    public FuAlgo(Instrument instrument) {
        this.x3Factors = instrument.getXFactors();
        this.y3Factors = instrument.getYFactors();
        this.z3Factors = instrument.getZFactors();
        this.polyCoeffs = instrument.getPolynomCoefficients();
    }

    FuAlgo() {
    }

    void setPolyCoeffs(double[] polyCoeffs) {
        this.polyCoeffs = polyCoeffs;
    }

    void setZ3Factors(double[] z3Factors) {
        this.z3Factors = z3Factors;
    }

    void setY3Factors(double[] y3Factors) {
        this.y3Factors = y3Factors;
    }

    void setX3Factors(double[] x3Factors) {
        this.x3Factors = x3Factors;
    }

    public FuResult compute(double[] spectrum) {
        double x3 = this.getTristimulusValue(spectrum, this.x3Factors);
        double y3 = this.getTristimulusValue(spectrum, this.y3Factors);
        double z3 = this.getTristimulusValue(spectrum, this.z3Factors);
        double denominator = x3 + y3 + z3;
        double chrX = x3 / denominator;
        double chrY = y3 / denominator;
        double hue = this.getHue(chrX, chrY);
        double hue100 = hue / 100.0;
        double polyCorr = this.getPolyCorr(hue100, this.polyCoeffs);
        FuResultImpl result = new FuResultImpl();
        result.x3 = x3;
        result.y3 = y3;
        result.z3 = z3;
        result.chrX = chrX;
        result.chrY = chrY;
        result.hue = hue;
        result.polyCorr = polyCorr;
        result.hueAngle = hue + polyCorr;
        result.fuValue = FuAlgo.getFuValue(result.hueAngle);
        return result;
    }

    static byte getFuValue(double hueAngle) {
        for (byte i = 0; i < ANGLE_OF_TRANSITIONS.length; i = (byte)(i + 1)) {
            if (!(hueAngle > ANGLE_OF_TRANSITIONS[i])) continue;
            return i;
        }
        return 21;
    }

    double getTristimulusValue(double[] spectrum, double[] factors) {
        if (spectrum.length != factors.length) {
            throw new IllegalArgumentException("The spectrum must have equal length as factors.");
        }
        double summation = 0.0;
        for (int i = 0; i < spectrum.length; ++i) {
            summation = spectrum[i] * factors[i] + summation;
        }
        return summation;
    }

    double getHue(double chrX, double chrY) {
        double atan2 = Math.atan2(chrY - 0.333333, chrX - 0.333333);
        double hue = 180.0 * atan2 / Math.PI;
        return hue < 0.0 ? hue + 360.0 : hue;
    }

    double getPolyCorr(double hue100, double[] constPolyHue) {
        Assert.argument((constPolyHue.length == 6 ? 1 : 0) != 0, (String)"constPolyHue.length == 6");
        double value = 0.0;
        for (int i = 0; i < constPolyHue.length; ++i) {
            if (i + 1 == constPolyHue.length) {
                value += constPolyHue[i];
                break;
            }
            value += constPolyHue[i] * Math.pow(hue100, 5 - i);
        }
        return value;
    }
}

