/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.fu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.StringUtils;

enum Instrument {
    AUTO_DETECT(new double[0], new String[0], new double[0], new double[0], new double[0], new double[0], new String[0], false),
    OLCI(Constants.OLCI_WAVELENGTHS, Constants.OLCI_BAND_NAME_PATTERN, Constants.OLCI_XFACTORS, Constants.OLCI_YFACTORS, Constants.OLCI_ZFACTORS, Constants.OLCI_POLYFACTORS, Constants.OLCI_VALID_EXPRESSIONS, false),
    S2_MSI(Constants.MSI_WAVELENGTHS, Constants.MSI_BAND_NAME_PATTERN, Constants.MSI_XFACTORS, Constants.MSI_YFACTORS, Constants.MSI_ZFACTORS, Constants.MSI_POLYFACTORS, Constants.MSI_VALID_EXPRESSIONS, true),
    MERIS(Constants.MERIS_WAVELENGTHS, Constants.MERIS_BAND_NAME_PATTERN, Constants.MERIS_XFACTORS, Constants.MERIS_YFACTORS, Constants.MERIS_ZFACTORS, Constants.MERIS_POLYFACTORS, Constants.MERIS_VALID_EXPRESSIONS, true),
    MODIS(Constants.MODIS_WAVELENGTHS, Constants.MODIS_BAND_NAME_PATTERN, Constants.MODIS_XFACTORS, Constants.MODIS_YFACTORS, Constants.MODIS_ZFACTORS, Constants.MODIS_POLYFACTORS, Constants.MODIS_VALID_EXPRESSIONS, false),
    MODIS500(Constants.MODIS500_WAVELENGTHS, Constants.MODIS500_XFACTORS, Constants.MODIS500_YFACTORS, Constants.MODIS500_ZFACTORS, Constants.MODIS500_POLYFACTORS, Constants.MODIS500_VALID_EXPRESSIONS, new ModisReflectancesSelector(Constants.MODIS500_BAND_NAME_PATTERN), (p, nodes, spectrum) -> spectrum, false),
    SEAWIFS(Constants.SEAWIFS_WAVELENGTHS, Constants.SEAWIFS_BAND_NAME_PATTERN, Constants.SEAWIFS_XFACTORS, Constants.SEAWIFS_YFACTORS, Constants.SEAWIFS_ZFACTORS, Constants.SEAWIFS_POLYFACTORS, Constants.SEAWIFS_VALID_EXPRESSIONS, false),
    CZCS(Constants.CZCS_WAVELENGTHS, Constants.CZCS_BAND_NAME_PATTERN, Constants.CZCS_XFACTORS, Constants.CZCS_YFACTORS, Constants.CZCS_ZFACTORS, Constants.CZCS_POLYFACTORS, Constants.CZCS_VALID_EXPRESSIONS, false);

    private final double[] wavelengths;
    private final double[] xFactors;
    private final double[] yFactors;
    private final double[] zFactors;
    private final double[] polynomCoefficients;
    private final String[] validExpressions;
    private final boolean isIrradiance;
    private final ReflectancesSelector reflectanceSelector;
    private final PreProcess preProcess;

    private Instrument(double[] wavelengths, String[] bandNamePattern, double[] xFactors, double[] yFactors, double[] zFactors, double[] polynomCoefficients, String[] validExpressions, boolean isIrradiance) {
        this(wavelengths, xFactors, yFactors, zFactors, polynomCoefficients, validExpressions, new DefaultReflectancesSelector(wavelengths, bandNamePattern), (p, nodes, spectrum) -> spectrum, isIrradiance);
    }

    private Instrument(double[] wavelengths, double[] xFactors, double[] yFactors, double[] zFactors, double[] polynomCoefficients, String[] validExpressions, ReflectancesSelector reflSelector, PreProcess preProcess, boolean isIrradiance) {
        this.wavelengths = wavelengths;
        this.xFactors = xFactors;
        this.yFactors = yFactors;
        this.zFactors = zFactors;
        this.reflectanceSelector = reflSelector;
        this.preProcess = preProcess;
        this.polynomCoefficients = polynomCoefficients;
        this.validExpressions = validExpressions;
        this.isIrradiance = isIrradiance;
    }

    public String[] getValidExpressions() {
        return this.validExpressions;
    }

    public double[] getWavelengths() {
        return this.wavelengths;
    }

    public boolean isIrradiance() {
        return this.isIrradiance;
    }

    public double[] getXFactors() {
        return this.xFactors;
    }

    public double[] getYFactors() {
        return this.yFactors;
    }

    public double[] getZFactors() {
        return this.zFactors;
    }

    public double[] getPolynomCoefficients() {
        return this.polynomCoefficients;
    }

    public double[] preProcess(Product sourceProduct, RasterDataNode[] sourceNodes, double[] spectrum) {
        return this.preProcess.process(sourceProduct, sourceNodes, spectrum);
    }

    public String[] getReflectanceBandNames(Product sourceProduct, String userBandNameRegex) {
        String[] selected = this.reflectanceSelector.select(sourceProduct, userBandNameRegex);
        int bandNum = selected.length;
        if (bandNum != this.getWavelengths().length) {
            throw new IllegalStateException("Could not find all necessary wavelengths for processing the instrument " + this.name() + ".");
        }
        return selected;
    }

    private static class ModisReflectancesSelector
    implements ReflectancesSelector {
        private final String[] defaultBandNamePattern;

        public ModisReflectancesSelector(String[] modis500BandNamePattern) {
            this.defaultBandNamePattern = modis500BandNamePattern;
        }

        @Override
        public String[] select(Product product, String userBandNameRegex) {
            ArrayList<String> regularexpressions = new ArrayList<String>();
            if (StringUtils.isNotNullAndNotEmpty((String)userBandNameRegex)) {
                regularexpressions.add(userBandNameRegex);
            }
            regularexpressions.addAll(Arrays.asList(this.defaultBandNamePattern));
            regularexpressions.add(".*");
            Band[] bands = product.getBands();
            ArrayList<String> potentialBandNames = new ArrayList<String>();
            for (String regex : regularexpressions) {
                Pattern pattern = Pattern.compile(regex);
                for (Band band : bands) {
                    if (!pattern.matcher(band.getName()).matches()) continue;
                    potentialBandNames.add(band.getName());
                }
            }
            String band3 = this.getNameWithSuffix(potentialBandNames, "3");
            String band4 = this.getNameWithSuffix(potentialBandNames, "4");
            String band1 = this.getNameWithSuffix(potentialBandNames, "1");
            ArrayList<String> selected = new ArrayList<String>();
            if (band3 != null) {
                selected.add(band3);
            }
            if (band4 != null) {
                selected.add(band4);
            }
            if (band1 != null) {
                selected.add(band1);
            }
            return selected.toArray(new String[0]);
        }

        private String getNameWithSuffix(List<String> potentialBandNames, String suffix) {
            for (String potentialBandName : potentialBandNames) {
                if (!potentialBandName.endsWith(suffix)) continue;
                return potentialBandName;
            }
            return null;
        }
    }

    static class DefaultReflectancesSelector
    implements ReflectancesSelector {
        private static final int MAX_DELTA_WAVELENGTH = 3;
        private final double[] wavelengths;
        private final String[] defaultNameRegex;

        public DefaultReflectancesSelector(double[] wavelengths, String[] defaultNameRegex) {
            this.wavelengths = wavelengths;
            this.defaultNameRegex = defaultNameRegex;
        }

        @Override
        public String[] select(Product product, String userBandNameRegex) {
            Band[] bands = product.getBands();
            ArrayList<String> band_Names = new ArrayList<String>();
            ArrayList<String> regularexpressions = new ArrayList<String>();
            if (StringUtils.isNotNullAndNotEmpty((String)userBandNameRegex)) {
                regularexpressions.add(userBandNameRegex);
            }
            regularexpressions.addAll(Arrays.asList(this.defaultNameRegex));
            regularexpressions.add(".*");
            for (String regex : regularexpressions) {
                Pattern pattern = Pattern.compile(regex);
                for (double centralWl : this.wavelengths) {
                    String name = null;
                    double minDelta = Double.MAX_VALUE;
                    for (Band band : bands) {
                        double delta;
                        double bandWavelength;
                        if (!pattern.matcher(band.getName()).matches() || !((bandWavelength = (double)band.getSpectralWavelength()) > 0.0) || !((delta = Math.abs(bandWavelength - centralWl)) < minDelta) || !(delta <= 3.0)) continue;
                        name = band.getName();
                        minDelta = delta;
                    }
                    if (name == null) continue;
                    band_Names.add(name);
                }
                if (band_Names.size() == this.wavelengths.length) {
                    return band_Names.toArray(new String[0]);
                }
                band_Names.clear();
            }
            return band_Names.toArray(new String[0]);
        }
    }

    static class Constants {
        static final double[] MERIS_WAVELENGTHS = new double[]{412.691, 442.55902, 489.88202, 509.81903, 559.69403, 619.601, 664.57306, 680.82104, 708.32904};
        static final String[] MERIS_BAND_NAME_PATTERN = new String[]{"reflectance_\\d{1,2}"};
        static final String[] MERIS_VALID_EXPRESSIONS = new String[]{"l2_flags.WATER", "not l1p_flags.CC_LAND and not l1p_flags.CC_CLOUD", "NOT l1_flags.LAND_OCEAN"};
        static final double[] MERIS_XFACTORS = new double[]{2.957, 10.861, 3.744, 3.75, 34.687, 41.853, 7.619, 0.844, 0.189};
        static final double[] MERIS_YFACTORS = new double[]{0.112, 1.711, 5.672, 23.263, 48.791, 23.949, 2.944, 0.307, 0.068};
        static final double[] MERIS_ZFACTORS = new double[]{14.354, 58.356, 28.227, 4.022, 0.618, 0.026, 0.0, 0.0, 0.0};
        static final double[] MERIS_POLYFACTORS = new double[]{-12.0506, 88.9325, -244.696, 305.2361, -164.696, 28.5255};
        static final double[] OLCI_WAVELENGTHS = new double[]{400.0, 412.5, 442.5, 490.0, 510.0, 560.0, 620.0, 665.0, 673.75, 681.25, 708.75};
        static final String[] OLCI_BAND_NAME_PATTERN = new String[]{"Oa\\d{2}_reflectance"};
        static final String[] OLCI_VALID_EXPRESSIONS = new String[]{"WQSF_lsb.WATER and not WQSF_lsb.CLOUD", "LQSF.WATER"};
        static final double[] OLCI_XFACTORS = new double[]{0.154, 2.957, 10.861, 3.744, 3.75, 34.687, 41.853, 7.323, 0.591, 0.549, 0.189};
        static final double[] OLCI_YFACTORS = new double[]{0.004, 0.112, 1.711, 5.672, 23.263, 48.791, 23.949, 2.836, 0.216, 0.199, 0.068};
        static final double[] OLCI_ZFACTORS = new double[]{0.731, 14.354, 58.356, 28.227, 4.022, 0.618, 0.026, 0.0, 0.0, 0.0, 0.0};
        static final double[] OLCI_POLYFACTORS = new double[]{-12.5076, 91.6345, -249.848, 308.6561, -165.4818, 28.5608};
        static final double[] MSI_WAVELENGTHS = new double[]{443.0, 490.0, 560.0, 665.0, 705.0};
        static final String[] MSI_BAND_NAME_PATTERN = new String[]{"B\\d"};
        static final String[] MSI_VALID_EXPRESSIONS = new String[0];
        static final double[] MSI_XFACTORS = new double[]{11.756, 6.423, 53.696, 32.028, 0.529};
        static final double[] MSI_YFACTORS = new double[]{1.744, 22.289, 65.702, 16.808, 0.192};
        static final double[] MSI_ZFACTORS = new double[]{62.696, 31.101, 1.778, 0.015, 0.0};
        static final double[] MSI_POLYFACTORS = new double[]{-65.74, 477.16, -1279.99, 1524.96, -751.59, 116.56};
        static final double[] MODIS_WAVELENGTHS = new double[]{412.0, 443.0, 488.0, 531.0, 555.0, 667.0, 678.0};
        static final String[] MODIS_BAND_NAME_PATTERN = new String[]{"rrs_\\d{3}"};
        static final String[] MODIS_VALID_EXPRESSIONS = new String[]{"not l2_flags.LAND and not l2_flags.CLDICE"};
        static final double[] MODIS_XFACTORS = new double[]{2.957, 10.861, 4.031, 3.989, 49.037, 34.586, 0.829};
        static final double[] MODIS_YFACTORS = new double[]{0.112, 1.711, 11.106, 22.579, 51.477, 19.452, 0.301};
        static final double[] MODIS_ZFACTORS = new double[]{14.354, 58.356, 29.993, 2.618, 0.262, 0.0, 0.0};
        static final double[] MODIS_POLYFACTORS = new double[]{-48.088, 362.6179, -1011.7151, 1262.0348, -666.5981, 113.9215};
        static final double[] SEAWIFS_WAVELENGTHS = new double[]{412.0, 443.0, 490.0, 510.0, 555.0, 670.0};
        static final String[] SEAWIFS_BAND_NAME_PATTERN = new String[]{"Rrs_\\d{3}"};
        static final String[] SEAWIFS_VALID_EXPRESSIONS = new String[]{"not l2_flags.LAND and not l2_flags.CLDICE"};
        static final double[] SEAWIFS_XFACTORS = new double[]{2.957, 10.861, 3.744, 3.455, 52.304, 32.825};
        static final double[] SEAWIFS_YFACTORS = new double[]{0.112, 1.711, 5.672, 21.929, 59.454, 17.81};
        static final double[] SEAWIFS_ZFACTORS = new double[]{14.354, 58.356, 28.227, 3.967, 0.682, 0.018};
        static final double[] SEAWIFS_POLYFACTORS = new double[]{-49.4377, 363.277, -978.1648, 1154.603, -552.2701, 78.294};
        static final double[] CZCS_WAVELENGTHS = new double[]{443.0, 520.0, 550.0, 670.0};
        static final String[] CZCS_BAND_NAME_PATTERN = new String[]{"Rrs_\\d{3}"};
        static final String[] CZCS_VALID_EXPRESSIONS = new String[]{"not l2_flags.LAND and not l2_flags.CLDICE"};
        static final double[] CZCS_XFACTORS = new double[]{13.237, 5.195, 50.856, 34.797};
        static final double[] CZCS_YFACTORS = new double[]{4.825, 25.217, 56.997, 19.571};
        static final double[] CZCS_ZFACTORS = new double[]{74.083, 21.023, 0.462, 0.022};
        static final double[] CZCS_POLYFACTORS = new double[]{-65.9452, 510.3687, -1475.8008, 1927.6141, -1078.6236, 202.2455};
        static final double[] MODIS500_WAVELENGTHS = new double[]{466.0, 553.0, 647.0};
        static final String[] MODIS500_BAND_NAME_PATTERN = new String[]{"sur_refl_b0[134]"};
        static final String[] MODIS500_VALID_EXPRESSIONS = new String[0];
        static final double[] MODIS500_XFACTORS = new double[]{13.328, 46.3789, 40.2774};
        static final double[] MODIS500_YFACTORS = new double[]{15.756, 67.793, 22.459};
        static final double[] MODIS500_ZFACTORS = new double[]{73.374, 6.111, 0.024};
        static final double[] MODIS500_POLYFACTORS = new double[]{-68.3622, 534.0367, -1552.7614, 2042.4187, -1156.9981, 223.0369};

        Constants() {
        }
    }

    private static interface ReflectancesSelector {
        public static final String FALLBACK_PATTERN = ".*";

        public String[] select(Product var1, String var2);
    }

    private static interface PreProcess {
        public double[] process(Product var1, RasterDataNode[] var2, double[] var3);
    }
}

