/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.processor.flh_mci;

import org.esa.s3tbx.processor.flh_mci.BaselineAlgorithm;
import org.esa.snap.core.gpf.OperatorException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BaselineAlgorithmTest {
    private BaselineAlgorithm algo;

    @Before
    public void setUp() {
        this.algo = new BaselineAlgorithm();
    }

    @Test
    public void testSetWavelengths() {
        float correctLow = 650.0f;
        float correctSignal = 700.0f;
        float correctHigh = 800.0f;
        try {
            this.algo.setWavelengths(correctLow, correctHigh, correctSignal);
        }
        catch (OperatorException e) {
            Assert.fail((String)"no exception expected!");
        }
        try {
            this.algo.setWavelengths(correctLow, correctHigh, correctLow);
            Assert.fail((String)"exception expected!");
        }
        catch (OperatorException operatorException) {
            // empty catch block
        }
        try {
            this.algo.setWavelengths(correctLow, correctLow, correctSignal);
            Assert.fail((String)"exception expected!");
        }
        catch (OperatorException operatorException) {
            // empty catch block
        }
        try {
            this.algo.setWavelengths(-correctLow, correctHigh, correctSignal);
            Assert.fail((String)"exception expected!");
        }
        catch (OperatorException operatorException) {
            // empty catch block
        }
        try {
            this.algo.setWavelengths(correctLow, -correctHigh, correctSignal);
            Assert.fail((String)"exception expected!");
        }
        catch (OperatorException operatorException) {
            // empty catch block
        }
        try {
            this.algo.setWavelengths(correctLow, correctHigh, -correctSignal);
            Assert.fail((String)"exception expected!");
        }
        catch (OperatorException operatorException) {
            // empty catch block
        }
    }

    @Test
    public void testDefaultCloudCorrectionFactor() {
        Assert.assertEquals((double)1.005f, (double)1.005f, (double)1.0E-6);
    }
}

