/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.processor.flh_mci;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.esa.s3tbx.processor.flh_mci.BaselineAlgorithm;
import org.esa.snap.core.gpf.OperatorException;

public class BaselineAlgorithmTest
extends TestCase {
    private BaselineAlgorithm algo;

    public BaselineAlgorithmTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return new TestSuite(BaselineAlgorithmTest.class);
    }

    public void setUp() {
        this.algo = new BaselineAlgorithm();
    }

    public void testSetWavelengths() {
        float correctLow = 650.0f;
        float correctSignal = 700.0f;
        float correctHigh = 800.0f;
        try {
            this.algo.setWavelengths(correctLow, correctHigh, correctSignal);
        }
        catch (OperatorException e) {
            BaselineAlgorithmTest.fail((String)"no exception expected!");
        }
        try {
            this.algo.setWavelengths(correctLow, correctHigh, correctLow);
            BaselineAlgorithmTest.fail((String)"exception expected!");
        }
        catch (OperatorException operatorException) {
            // empty catch block
        }
        try {
            this.algo.setWavelengths(correctLow, correctLow, correctSignal);
            BaselineAlgorithmTest.fail((String)"exception expected!");
        }
        catch (OperatorException operatorException) {
            // empty catch block
        }
        try {
            this.algo.setWavelengths(-correctLow, correctHigh, correctSignal);
            BaselineAlgorithmTest.fail((String)"exception expected!");
        }
        catch (OperatorException operatorException) {
            // empty catch block
        }
        try {
            this.algo.setWavelengths(correctLow, -correctHigh, correctSignal);
            BaselineAlgorithmTest.fail((String)"exception expected!");
        }
        catch (OperatorException operatorException) {
            // empty catch block
        }
        try {
            this.algo.setWavelengths(correctLow, correctHigh, -correctSignal);
            BaselineAlgorithmTest.fail((String)"exception expected!");
        }
        catch (OperatorException operatorException) {
            // empty catch block
        }
    }

    public void testDefaultCloudCorrectionFactor() {
        BaselineAlgorithmTest.assertEquals((double)1.005f, (double)1.005f, (double)1.0E-6);
    }
}

