/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.processor.flh_mci;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.Validator;
import org.esa.s3tbx.processor.flh_mci.BaselineAlgorithm;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.pointop.PixelOperator;
import org.esa.snap.core.gpf.pointop.ProductConfigurer;
import org.esa.snap.core.gpf.pointop.Sample;
import org.esa.snap.core.gpf.pointop.SourceSampleConfigurer;
import org.esa.snap.core.gpf.pointop.TargetSampleConfigurer;
import org.esa.snap.core.gpf.pointop.WritableSample;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.converters.BooleanExpressionConverter;

@OperatorMetadata(alias="FlhMci", authors="Tom Block, Ralf Quast", copyright="Brockmann Consult GmbH", category="Optical/Thematic Water Processing", version="2.0", description="Computes fluorescence line height (FLH) or maximum chlorophyll index (MCI).")
public class FlhMciOp
extends PixelOperator {
    @SourceProduct(alias="source", label="Source product", description="The source product.")
    private Product sourceProduct;
    @Parameter(description="The name for the lower wavelength band defining the baseline", rasterDataNodeType=Band.class)
    private String lowerBaselineBandName;
    @Parameter(description="The name of the upper wavelength band defining the baseline", rasterDataNodeType=Band.class)
    private String upperBaselineBandName;
    @Parameter(description=" The name of the signal band, i.e. the band for which the baseline height is calculated", rasterDataNodeType=Band.class)
    private String signalBandName;
    @Parameter(description="The name of the line height band in the target product", validator=NodeNameValidator.class)
    private String lineHeightBandName;
    @Parameter(description="Activates or deactivates calculating the slope parameter", defaultValue="true", label="Generate slope parameter")
    private boolean slope;
    @Parameter(description="The name of the slope band in the target product", validator=NodeNameValidator.class)
    private String slopeBandName;
    @Parameter(description="A ROI-mask expression used to identify pixels of interest", converter=BooleanExpressionConverter.class)
    private String maskExpression;
    @Parameter(description="The cloud correction factor used during calculation", defaultValue="1.005")
    private float cloudCorrectionFactor;
    @Parameter(defaultValue="NaN", label="Invalid FLH/MCI value", description="Value used to fill invalid FLH/MCI pixels")
    private float invalidFlhMciValue;
    private transient BaselineAlgorithm algorithm;
    private transient int currentPixel = 0;

    protected void computePixel(int x, int y, Sample[] sourceSamples, WritableSample[] targetSamples) {
        this.checkCancellation();
        float signal = sourceSamples[0].getFloat();
        float lower = sourceSamples[1].getFloat();
        float upper = sourceSamples[2].getFloat();
        targetSamples[0].set(this.algorithm.computeLineHeight(lower, upper, signal));
        if (this.slope) {
            targetSamples[1].set(this.algorithm.computeSlope(lower, upper));
        }
    }

    private void checkCancellation() {
        if (this.currentPixel % 1000 == 0) {
            this.checkForCancellation();
            this.currentPixel = 0;
        }
        ++this.currentPixel;
    }

    protected void configureSourceSamples(SourceSampleConfigurer sc) throws OperatorException {
        sc.setValidPixelMask(this.maskExpression);
        sc.defineSample(0, this.signalBandName);
        sc.defineSample(1, this.lowerBaselineBandName);
        sc.defineSample(2, this.upperBaselineBandName);
    }

    protected void configureTargetSamples(TargetSampleConfigurer sc) throws OperatorException {
        sc.defineSample(0, this.lineHeightBandName);
        if (this.slope) {
            sc.defineSample(1, this.slopeBandName);
        }
    }

    protected void configureTargetProduct(ProductConfigurer productConfigurer) {
        super.configureTargetProduct(productConfigurer);
        String validPixelExpression = this.createValidMaskExpression();
        Band lineHeightBand = productConfigurer.addBand(this.lineHeightBandName, 30);
        Band signalBand = this.sourceProduct.getBand(this.signalBandName);
        lineHeightBand.setUnit(signalBand.getUnit());
        lineHeightBand.setDescription("Line height band");
        lineHeightBand.setValidPixelExpression(validPixelExpression);
        lineHeightBand.setNoDataValueUsed(true);
        lineHeightBand.setNoDataValue((double)this.invalidFlhMciValue);
        ProductUtils.copySpectralBandProperties((Band)signalBand, (Band)lineHeightBand);
        if (this.slope) {
            Band slopeBand = productConfigurer.addBand(this.slopeBandName, 30);
            slopeBand.setUnit(signalBand.getUnit() + " nm-1");
            slopeBand.setDescription("Baseline slope band");
            slopeBand.setNoDataValueUsed(true);
            slopeBand.setNoDataValue((double)this.invalidFlhMciValue);
            slopeBand.setValidPixelExpression(validPixelExpression);
        }
        ProductUtils.copyFlagBands((Product)this.sourceProduct, (Product)productConfigurer.getTargetProduct(), (boolean)true);
    }

    private String createValidMaskExpression() {
        String expression = this.sourceProduct.getBand("l1_flags") != null && this.sourceProduct.getFlagCodingGroup().get("l1_flags") != null ? "!l1_flags.INVALID && !l1_flags.LAND_OCEAN" : (this.sourceProduct.getBand("l2_flags") != null && this.sourceProduct.getFlagCodingGroup().get("l2_flags") != null ? "l2_flags.WATER && !l2_flags.CLOUD" : null);
        return expression;
    }

    protected void prepareInputs() throws OperatorException {
        super.prepareInputs();
        this.validateParameters();
        float lambda1 = this.getWavelength(this.lowerBaselineBandName);
        float lambda2 = this.getWavelength(this.signalBandName);
        float lambda3 = this.getWavelength(this.upperBaselineBandName);
        this.algorithm = new BaselineAlgorithm();
        this.algorithm.setWavelengths(lambda1, lambda3, lambda2);
        this.algorithm.setCloudCorrectionFactor(this.cloudCorrectionFactor);
    }

    private void validateParameters() throws OperatorException {
        this.assertParameterBandNameValid(this.lowerBaselineBandName, "lowerBaselineBandName");
        this.assertParameterBandNameValid(this.signalBandName, "signalBandName");
        this.assertParameterBandNameValid(this.upperBaselineBandName, "upperBaselineBandName");
        if (this.slope) {
            this.assertParameterBandNameValid(this.slopeBandName, "slopeBandName");
        }
    }

    private void assertParameterBandNameValid(String parameterValue, String parameterName) {
        if (StringUtils.isNullOrEmpty((String)parameterValue)) {
            throw new OperatorException(String.format("Parameter '%s' not specified", parameterName));
        }
    }

    private float getWavelength(String bandName) {
        Band band = this.sourceProduct.getBand(bandName);
        float wavelength = band.getSpectralWavelength();
        if (wavelength == 0.0f) {
            throw new OperatorException("The band '" + band.getName() + "' is not a spectral band.\nPlease select a spectral band for processing.");
        }
        return wavelength;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(FlhMciOp.class);
        }
    }

    public static class NodeNameValidator
    implements Validator {
        public void validateValue(Property property, Object value) throws ValidationException {
            ProductNode.isValidNodeName((String)value.toString());
        }
    }
}

