/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.chris.internal;

import java.awt.Rectangle;
import junit.framework.TestCase;
import org.esa.s3tbx.dataio.chris.Flags;
import org.esa.s3tbx.dataio.chris.internal.DropoutCorrection;

public class DropoutCorrectionTest
extends TestCase {
    private int[][] data;
    private short[][] mask;

    protected void setUp() throws Exception {
        this.data = new int[][]{{1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1}};
        this.mask = new short[3][9];
    }

    protected void tearDown() throws Exception {
        this.data = null;
        this.mask = null;
    }

    public void testDropoutCorrection() {
        DropoutCorrection dropoutCorrection = new DropoutCorrection();
        this.data[1][4] = 0;
        this.mask[1][4] = 1;
        Rectangle region = new Rectangle(0, 0, 3, 3);
        dropoutCorrection.compute((int[][])new int[][]{this.data[1], this.data[0], this.data[2]}, (short[][])new short[][]{this.mask[1], this.mask[0], this.mask[2]}, 3, 3, region);
        DropoutCorrectionTest.assertEquals((int)Flags.DROPOUT.getMask(), (int)this.data[1][4]);
        DropoutCorrectionTest.assertEquals((int)Flags.DROPOUT_CORRECTED.getMask(), (int)this.mask[1][4]);
        this.data[0][0] = 0;
        this.mask[0][0] = 1;
        dropoutCorrection.compute((int[][])new int[][]{this.data[0], this.data[1]}, (short[][])new short[][]{this.mask[0], this.mask[1]}, 3, 3, region);
        DropoutCorrectionTest.assertEquals((int)Flags.DROPOUT.getMask(), (int)this.data[0][0]);
        DropoutCorrectionTest.assertEquals((int)Flags.DROPOUT_CORRECTED.getMask(), (int)this.mask[0][0]);
        this.data[2][8] = 0;
        this.mask[2][8] = 1;
        dropoutCorrection.compute((int[][])new int[][]{this.data[2], this.data[1]}, (short[][])new short[][]{this.mask[2], this.mask[1]}, 3, 3, region);
        DropoutCorrectionTest.assertEquals((int)Flags.DROPOUT.getMask(), (int)this.data[2][8]);
        DropoutCorrectionTest.assertEquals((int)Flags.DROPOUT_CORRECTED.getMask(), (int)this.mask[2][8]);
    }
}

