/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.c2rcc.viirs;

import java.util.Date;
import org.esa.s3tbx.c2rcc.viirs.C2rccViirsAlgorithm;
import org.esa.s3tbx.c2rcc.viirs.C2rccViirsOperator;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class ViirsProductSignatureTest {
    private static final String[] EXPECTED_RHOW_BANDS = new String[]{"rhow_410", "rhow_443", "rhow_486", "rhow_551", "rhow_671", "rhow_745", "rhow_862"};
    private static final String[] EXPECTED_RRS_BANDS = new String[]{"rrs_410", "rrs_443", "rrs_486", "rrs_551", "rrs_671", "rrs_745", "rrs_862"};
    private static final String EXPECTED_RTOSA_RATION_MIN = "rtosa_ratio_min";
    private static final String EXPECTED_RTOSA_RATION_MAX = "rtosa_ratio_max";
    private static final String EXPECTED_IOP_APIG = "iop_apig";
    private static final String EXPECTED_IOP_ADET = "iop_adet";
    private static final String EXPECTED_IOP_AGELB = "iop_agelb";
    private static final String EXPECTED_IOP_BPART = "iop_bpart";
    private static final String EXPECTED_IOP_BWIT = "iop_bwit";
    private static final String EXPECTED_IOP_ADG = "iop_adg";
    private static final String EXPECTED_IOP_ATOT = "iop_atot";
    private static final String EXPECTED_IOP_BTOT = "iop_btot";
    private static final String EXPECTED_CONC_CHL = "conc_chl";
    private static final String EXPECTED_CONC_TSM = "conc_tsm";
    private static final String[] EXPECTED_RTOSA_IN_BANDS = new String[]{"rtosa_in_410", "rtosa_in_443", "rtosa_in_486", "rtosa_in_551", "rtosa_in_671", "rtosa_in_745", "rtosa_in_862"};
    private static final String[] EXPECTED_RTOSA_OUT_BANDS = new String[]{"rtosa_out_410", "rtosa_out_443", "rtosa_out_486", "rtosa_out_551", "rtosa_out_671", "rtosa_out_745", "rtosa_out_862"};
    private static final String EXPECTED_C2RCC_FLAGS = "c2rcc_flags";
    private static final String EXPECTED_VALID_PE_FLAG = "Valid_PE";
    private static final int EXPECTED_VPE_MASK = Integer.MIN_VALUE;
    private static final String EXPECTED_L2_FLAGS = "l2_flags";
    private static final String EXPECTED_PRODUCT_TYPE = "C2RCC_VIIRS";

    @Test
    public void testProductSignature_Default() throws FactoryException, TransformException {
        C2rccViirsOperator operator = this.createDefaultOperator();
        Product targetProduct = operator.getTargetProduct();
        this.assertMandatoryElements(targetProduct, false);
    }

    @Test
    public void testProductSignature_Default_AsRrs() throws FactoryException, TransformException {
        C2rccViirsOperator operator = this.createDefaultOperator();
        operator.setOutputAsRrs(true);
        Product targetProduct = operator.getTargetProduct();
        this.assertMandatoryElements(targetProduct, true);
    }

    @Test
    public void testProductSignature_WithRtosa() throws FactoryException, TransformException {
        C2rccViirsOperator operator = this.createDefaultOperator();
        operator.setOutputRtosa(true);
        Product targetProduct = operator.getTargetProduct();
        this.assertMandatoryElements(targetProduct, false);
        this.assertBands(targetProduct, EXPECTED_RTOSA_IN_BANDS);
        this.assertBands(targetProduct, EXPECTED_RTOSA_OUT_BANDS);
    }

    private void assertMandatoryElements(Product targetProduct, boolean asRrs) {
        if (asRrs) {
            this.assertBands(targetProduct, EXPECTED_RRS_BANDS);
            Assert.assertEquals((Object)"c2rcc_flags.Valid_PE", (Object)targetProduct.getBand(EXPECTED_RRS_BANDS[3]).getValidPixelExpression());
        } else {
            this.assertBands(targetProduct, EXPECTED_RHOW_BANDS);
            Assert.assertEquals((Object)"c2rcc_flags.Valid_PE", (Object)targetProduct.getBand(EXPECTED_RHOW_BANDS[3]).getValidPixelExpression());
        }
        this.assertBands(targetProduct, EXPECTED_RTOSA_RATION_MIN);
        this.assertBands(targetProduct, EXPECTED_RTOSA_RATION_MAX);
        this.assertBands(targetProduct, EXPECTED_IOP_APIG);
        Assert.assertEquals((Object)"c2rcc_flags.Valid_PE", (Object)targetProduct.getBand(EXPECTED_IOP_APIG).getValidPixelExpression());
        this.assertBands(targetProduct, EXPECTED_IOP_ADET);
        this.assertBands(targetProduct, EXPECTED_IOP_AGELB);
        this.assertBands(targetProduct, EXPECTED_IOP_BPART);
        this.assertBands(targetProduct, EXPECTED_IOP_BWIT);
        this.assertBands(targetProduct, EXPECTED_IOP_ADG);
        this.assertBands(targetProduct, EXPECTED_IOP_ATOT);
        this.assertBands(targetProduct, EXPECTED_IOP_BTOT);
        Assert.assertEquals((Object)"c2rcc_flags.Valid_PE", (Object)targetProduct.getBand(EXPECTED_IOP_BTOT).getValidPixelExpression());
        this.assertBands(targetProduct, EXPECTED_CONC_CHL);
        this.assertBands(targetProduct, EXPECTED_CONC_TSM);
        this.assertBands(targetProduct, EXPECTED_C2RCC_FLAGS);
        this.assertBands(targetProduct, EXPECTED_L2_FLAGS);
        FlagCoding flagCoding = (FlagCoding)targetProduct.getFlagCodingGroup().get(EXPECTED_C2RCC_FLAGS);
        Assert.assertNotNull((Object)flagCoding.getFlag(EXPECTED_VALID_PE_FLAG));
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)flagCoding.getFlagMask(EXPECTED_VALID_PE_FLAG));
        Assert.assertEquals((Object)EXPECTED_PRODUCT_TYPE, (Object)targetProduct.getProductType());
    }

    private void assertBands(Product targetProduct, String ... expectedBands) {
        for (String expectedBand : expectedBands) {
            Assert.assertTrue((String)("Expected band " + expectedBand + " in product"), (boolean)targetProduct.containsBand(expectedBand));
        }
    }

    private C2rccViirsOperator createDefaultOperator() throws FactoryException, TransformException {
        C2rccViirsOperator operator = new C2rccViirsOperator();
        operator.setParameterDefaultValues();
        operator.setSourceProduct(this.createSeawifsTestProduct());
        return operator;
    }

    private Product createSeawifsTestProduct() throws FactoryException, TransformException {
        int[] reflecWavelengths;
        Product product = new Product("test-seawifs", "t", 1, 1);
        for (int reflec_wavelength : reflecWavelengths = C2rccViirsAlgorithm.viirsWavelengths) {
            String expression = String.valueOf(reflec_wavelength);
            product.addBand("rhot_" + reflec_wavelength, expression);
        }
        Date time = new Date();
        product.setStartTime(ProductData.UTC.create((Date)time, (long)0L));
        product.setEndTime(ProductData.UTC.create((Date)time, (long)500L));
        for (String angleName : C2rccViirsOperator.GEOMETRY_ANGLE_NAMES) {
            product.addBand(angleName, "42");
        }
        Band flagBand = product.addBand(EXPECTED_L2_FLAGS, 10);
        FlagCoding l2FlagsCoding = new FlagCoding(EXPECTED_L2_FLAGS);
        l2FlagsCoding.addFlag("LAND", 1, "");
        product.getFlagCodingGroup().add((ProductNode)l2FlagsCoding);
        flagBand.setSampleCoding((SampleCoding)l2FlagsCoding);
        product.setSceneGeoCoding((GeoCoding)new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, 1, 1, 10.0, 50.0, 1.0, 1.0));
        return product;
    }
}

