/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.c2rcc.util;

import java.text.ParseException;
import org.esa.s3tbx.c2rcc.util.SolarFluxCorrectionFactorCalculator;
import org.esa.snap.core.datamodel.ProductData;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SolarFluxCorrectionFactorCalculatorTest {
    private final int endJan = 31;
    private final int endFeb = 59;
    private final int endMar = 90;
    private final int endApr = 120;
    private final int endMay = 151;
    private final int endJun = 181;
    private final int endJul = 212;
    private final int endAug = 243;
    private final int endSep = 273;
    private final int endOct = 304;
    private final int endNov = 334;
    private ProductData.UTC time1;
    private ProductData.UTC time2;

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() throws Exception {
        this.time1 = new ProductData.UTC(3.5);
        this.time2 = new ProductData.UTC(5.5);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testUTCCreation() throws ParseException {
        long millis1 = new ProductData.UTC(3.5).getAsCalendar().getTimeInMillis();
        long millis2 = ProductData.UTC.parse((String)"04-JAN-2000 12:00:00.000").getAsCalendar().getTimeInMillis();
        Assert.assertEquals((long)millis1, (long)millis2);
    }

    @Test
    public void testGetCenterUTC() {
        ProductData.UTC centerTime1 = SolarFluxCorrectionFactorCalculator.getCenterUTC((ProductData.UTC)this.time1, (ProductData.UTC)this.time2);
        ProductData.UTC centerTime2 = SolarFluxCorrectionFactorCalculator.getCenterUTC((ProductData.UTC)this.time2, (ProductData.UTC)this.time1);
        Assert.assertEquals((Object)"04-JAN-2000 12:00:00.000000", (Object)this.time1.format());
        Assert.assertEquals((Object)"06-JAN-2000 12:00:00.000000", (Object)this.time2.format());
        Assert.assertEquals((Object)"05-JAN-2000 12:00:00.000000", (Object)centerTime1.format());
        Assert.assertEquals((Object)"05-JAN-2000 12:00:00.000000", (Object)centerTime2.format());
    }

    @Test
    public void testSolFluxCorrFactor() {
        Assert.assertEquals((double)1.0351, (double)SolarFluxCorrectionFactorCalculator.computeFactorFor((ProductData.UTC)this.time1, (ProductData.UTC)this.time2), (double)1.0E-4);
    }

    @Test
    public void testGetSolarFluxDayCorrectionFactorForADay() {
        int nonLeapYear = 2007;
        Assert.assertEquals((double)1.035, (double)SolarFluxCorrectionFactorCalculator.getDayCorrectionFactorFor((int)1, (int)2007), (double)1.0E-4);
        Assert.assertEquals((double)1.0306, (double)SolarFluxCorrectionFactorCalculator.getDayCorrectionFactorFor((int)32, (int)2007), (double)1.0E-4);
        Assert.assertEquals((double)1.019, (double)SolarFluxCorrectionFactorCalculator.getDayCorrectionFactorFor((int)60, (int)2007), (double)1.0E-4);
        Assert.assertEquals((double)1.0014, (double)SolarFluxCorrectionFactorCalculator.getDayCorrectionFactorFor((int)91, (int)2007), (double)1.0E-4);
        Assert.assertEquals((double)0.9845, (double)SolarFluxCorrectionFactorCalculator.getDayCorrectionFactorFor((int)121, (int)2007), (double)1.0E-4);
        Assert.assertEquals((double)0.9717, (double)SolarFluxCorrectionFactorCalculator.getDayCorrectionFactorFor((int)152, (int)2007), (double)1.0E-4);
        Assert.assertEquals((double)0.9666, (double)SolarFluxCorrectionFactorCalculator.getDayCorrectionFactorFor((int)182, (int)2007), (double)1.0E-4);
        Assert.assertEquals((double)0.97, (double)SolarFluxCorrectionFactorCalculator.getDayCorrectionFactorFor((int)213, (int)2007), (double)1.0E-4);
        Assert.assertEquals((double)0.9814, (double)SolarFluxCorrectionFactorCalculator.getDayCorrectionFactorFor((int)244, (int)2007), (double)1.0E-4);
        Assert.assertEquals((double)0.9976, (double)SolarFluxCorrectionFactorCalculator.getDayCorrectionFactorFor((int)274, (int)2007), (double)1.0E-4);
        Assert.assertEquals((double)1.0155, (double)SolarFluxCorrectionFactorCalculator.getDayCorrectionFactorFor((int)305, (int)2007), (double)1.0E-4);
        Assert.assertEquals((double)1.0292, (double)SolarFluxCorrectionFactorCalculator.getDayCorrectionFactorFor((int)335, (int)2007), (double)1.0E-4);
        Assert.assertEquals((double)1.0309, (double)SolarFluxCorrectionFactorCalculator.getDayCorrectionFactorFor((int)31, (int)2007), (double)1.0E-4);
        Assert.assertEquals((double)1.0195, (double)SolarFluxCorrectionFactorCalculator.getDayCorrectionFactorFor((int)59, (int)2007), (double)1.0E-4);
        Assert.assertEquals((double)1.002, (double)SolarFluxCorrectionFactorCalculator.getDayCorrectionFactorFor((int)90, (int)2007), (double)1.0E-4);
        Assert.assertEquals((double)0.9851, (double)SolarFluxCorrectionFactorCalculator.getDayCorrectionFactorFor((int)120, (int)2007), (double)1.0E-4);
        Assert.assertEquals((double)0.972, (double)SolarFluxCorrectionFactorCalculator.getDayCorrectionFactorFor((int)151, (int)2007), (double)1.0E-4);
        Assert.assertEquals((double)0.9667, (double)SolarFluxCorrectionFactorCalculator.getDayCorrectionFactorFor((int)181, (int)2007), (double)1.0E-4);
        Assert.assertEquals((double)0.9698, (double)SolarFluxCorrectionFactorCalculator.getDayCorrectionFactorFor((int)212, (int)2007), (double)1.0E-4);
        Assert.assertEquals((double)0.9809, (double)SolarFluxCorrectionFactorCalculator.getDayCorrectionFactorFor((int)243, (int)2007), (double)1.0E-4);
        Assert.assertEquals((double)0.997, (double)SolarFluxCorrectionFactorCalculator.getDayCorrectionFactorFor((int)273, (int)2007), (double)1.0E-4);
        Assert.assertEquals((double)1.015, (double)SolarFluxCorrectionFactorCalculator.getDayCorrectionFactorFor((int)304, (int)2007), (double)1.0E-4);
        Assert.assertEquals((double)1.0288, (double)SolarFluxCorrectionFactorCalculator.getDayCorrectionFactorFor((int)334, (int)2007), (double)1.0E-4);
        Assert.assertEquals((double)1.035, (double)SolarFluxCorrectionFactorCalculator.getDayCorrectionFactorFor((int)365, (int)2007), (double)1.0E-4);
    }

    @Test
    public void testSolFluxCorrectionForADate() throws ParseException {
        int leapYearOffset;
        Assert.assertEquals((long)1L, (long)this.getDayOfYearFor("01-JAN-2011 12:00:00.000"));
        Assert.assertEquals((long)32L, (long)this.getDayOfYearFor("01-FEB-2011 12:00:00.000"));
        Assert.assertEquals((long)60L, (long)this.getDayOfYearFor("01-MAR-2011 12:00:00.000"));
        Assert.assertEquals((long)91L, (long)this.getDayOfYearFor("01-APR-2011 12:00:00.000"));
        Assert.assertEquals((long)121L, (long)this.getDayOfYearFor("01-MAY-2011 12:00:00.000"));
        Assert.assertEquals((long)152L, (long)this.getDayOfYearFor("01-JUN-2011 12:00:00.000"));
        Assert.assertEquals((long)182L, (long)this.getDayOfYearFor("01-JUL-2011 12:00:00.000"));
        Assert.assertEquals((long)213L, (long)this.getDayOfYearFor("01-AUG-2011 12:00:00.000"));
        Assert.assertEquals((long)244L, (long)this.getDayOfYearFor("01-SEP-2011 12:00:00.000"));
        Assert.assertEquals((long)274L, (long)this.getDayOfYearFor("01-OCT-2011 12:00:00.000"));
        Assert.assertEquals((long)305L, (long)this.getDayOfYearFor("01-NOV-2011 12:00:00.000"));
        Assert.assertEquals((long)335L, (long)this.getDayOfYearFor("01-DEC-2011 12:00:00.000"));
        int o = leapYearOffset = 1;
        Assert.assertEquals((long)1L, (long)this.getDayOfYearFor("01-JAN-2012 12:00:00.000"));
        Assert.assertEquals((long)32L, (long)this.getDayOfYearFor("01-FEB-2012 12:00:00.000"));
        Assert.assertEquals((long)(60 + o), (long)this.getDayOfYearFor("01-MAR-2012 12:00:00.000"));
        Assert.assertEquals((long)(91 + o), (long)this.getDayOfYearFor("01-APR-2012 12:00:00.000"));
        Assert.assertEquals((long)(121 + o), (long)this.getDayOfYearFor("01-MAY-2012 12:00:00.000"));
        Assert.assertEquals((long)(152 + o), (long)this.getDayOfYearFor("01-JUN-2012 12:00:00.000"));
        Assert.assertEquals((long)(182 + o), (long)this.getDayOfYearFor("01-JUL-2012 12:00:00.000"));
        Assert.assertEquals((long)(213 + o), (long)this.getDayOfYearFor("01-AUG-2012 12:00:00.000"));
        Assert.assertEquals((long)(244 + o), (long)this.getDayOfYearFor("01-SEP-2012 12:00:00.000"));
        Assert.assertEquals((long)(274 + o), (long)this.getDayOfYearFor("01-OCT-2012 12:00:00.000"));
        Assert.assertEquals((long)(305 + o), (long)this.getDayOfYearFor("01-NOV-2012 12:00:00.000"));
        Assert.assertEquals((long)(335 + o), (long)this.getDayOfYearFor("01-DEC-2012 12:00:00.000"));
    }

    @Test
    public void testGetNumDaysForTheYear() {
        Assert.assertEquals((long)365L, (long)SolarFluxCorrectionFactorCalculator.getNumDaysInTheYear((int)2007));
        Assert.assertEquals((long)366L, (long)SolarFluxCorrectionFactorCalculator.getNumDaysInTheYear((int)2008));
        Assert.assertEquals((long)365L, (long)SolarFluxCorrectionFactorCalculator.getNumDaysInTheYear((int)2009));
        Assert.assertEquals((long)365L, (long)SolarFluxCorrectionFactorCalculator.getNumDaysInTheYear((int)2010));
        Assert.assertEquals((long)365L, (long)SolarFluxCorrectionFactorCalculator.getNumDaysInTheYear((int)2011));
        Assert.assertEquals((long)366L, (long)SolarFluxCorrectionFactorCalculator.getNumDaysInTheYear((int)2012));
        Assert.assertEquals((long)365L, (long)SolarFluxCorrectionFactorCalculator.getNumDaysInTheYear((int)2013));
        Assert.assertEquals((long)365L, (long)SolarFluxCorrectionFactorCalculator.getNumDaysInTheYear((int)2014));
        Assert.assertEquals((long)365L, (long)SolarFluxCorrectionFactorCalculator.getNumDaysInTheYear((int)2015));
        Assert.assertEquals((long)366L, (long)SolarFluxCorrectionFactorCalculator.getNumDaysInTheYear((int)2016));
        Assert.assertEquals((long)365L, (long)SolarFluxCorrectionFactorCalculator.getNumDaysInTheYear((int)2017));
    }

    @Test
    public void testTimeDiff() {
        long diffMillies = this.time2.getAsCalendar().getTimeInMillis() - this.time1.getAsCalendar().getTimeInMillis();
        double diffSeconds = (double)diffMillies / 1000.0;
        double diffMinutes = diffSeconds / 60.0;
        double diffHours = diffMinutes / 60.0;
        double diffDays = diffHours / 24.0;
        Assert.assertEquals((Object)"2.0", (Object)("" + diffDays));
        Assert.assertEquals((Object)"48.0", (Object)("" + diffHours));
        Assert.assertEquals((Object)"2880.0", (Object)("" + diffMinutes));
        Assert.assertEquals((Object)"172800.0", (Object)("" + diffSeconds));
        Assert.assertEquals((Object)"172800000", (Object)("" + diffMillies));
    }

    private int getDayOfYearFor(String date) throws ParseException {
        return ProductData.UTC.parse((String)date).getAsCalendar().get(6);
    }
}

