/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.c2rcc.util;

import org.esa.s3tbx.c2rcc.util.RgbProfiles;
import org.esa.snap.core.datamodel.RGBImageProfile;
import org.esa.snap.core.datamodel.RGBImageProfileManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class RgbProfilesTest {
    private static RGBImageProfileManager profileManager = RGBImageProfileManager.getInstance();
    private static RGBImageProfile[] storedProfiles;

    @BeforeClass
    public static void setUpClass() throws Exception {
        storedProfiles = profileManager.getAllProfiles();
        RgbProfilesTest.removeProfiles(storedProfiles);
    }

    @Before
    public void setUp() throws Exception {
        RgbProfilesTest.removeProfiles(profileManager.getAllProfiles());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        RGBImageProfile[] allProfiles = profileManager.getAllProfiles();
        RgbProfilesTest.removeProfiles(allProfiles);
        for (RGBImageProfile profile : storedProfiles) {
            profileManager.addProfile(profile);
        }
    }

    @Test
    public void installMerisRgbProfiles() throws Exception {
        Assert.assertEquals((long)0L, (long)profileManager.getProfileCount());
        RgbProfiles.installMerisRgbProfiles();
        Assert.assertEquals((long)9L, (long)profileManager.getProfileCount());
    }

    @Test
    public void installMeris4RgbProfiles() throws Exception {
        Assert.assertEquals((long)0L, (long)profileManager.getProfileCount());
        RgbProfiles.installMeris4RgbProfiles();
        Assert.assertEquals((long)9L, (long)profileManager.getProfileCount());
    }

    @Test
    public void installS2MsiRgbProfiles() throws Exception {
        Assert.assertEquals((long)0L, (long)profileManager.getProfileCount());
        RgbProfiles.installS2MsiRgbProfiles();
        Assert.assertEquals((long)9L, (long)profileManager.getProfileCount());
    }

    private static void removeProfiles(RGBImageProfile[] storedProfiles) {
        for (RGBImageProfile profile : storedProfiles) {
            profileManager.removeProfile(profile);
        }
    }
}

