/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.c2rcc.util;

import com.google.common.jimfs.Jimfs;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.esa.s3tbx.c2rcc.util.NNUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NNUtilsTest {
    private Path testDir;
    private String sep;

    @Before
    public void setUp() throws Exception {
        FileSystem fileSystem = Jimfs.newFileSystem();
        this.sep = fileSystem.getSeparator();
        this.testDir = fileSystem.getPath("test-dir", new String[0]);
        Files.createDirectories(this.testDir, new FileAttribute[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.testDir.getFileSystem().close();
    }

    @Test
    public void testGetNNFilePaths() throws Exception {
        for (int i = 0; i < 10; ++i) {
            Path nnDir = this.testDir.resolve(NNUtils.ALTERNATIVE_NET_DIR_NAMES[i]);
            Files.createDirectories(nnDir, new FileAttribute[0]);
            Path nnfile = nnDir.resolve("nnFile_" + i + ".net");
            Files.createFile(nnfile, new FileAttribute[0]);
        }
        String[] nnFilePaths = NNUtils.getNNFilePaths((Path)this.testDir, (String[])NNUtils.ALTERNATIVE_NET_DIR_NAMES);
        Assert.assertNotNull((Object)nnFilePaths);
        Assert.assertEquals((long)10L, (long)nnFilePaths.length);
        for (int i = 0; i < NNUtils.ALTERNATIVE_NET_DIR_NAMES.length; ++i) {
            String alternativeNetDirName = NNUtils.ALTERNATIVE_NET_DIR_NAMES[i];
            Assert.assertTrue((boolean)nnFilePaths[i].contains(this.sep + alternativeNetDirName + this.sep));
        }
    }

    @Test
    public void testGetNNFilePaths_ignoringUpperCase() throws Exception {
        String[] alternativeNetDirNamesWithUpperCase = new String[]{"rtosa_aaNN", "rtosa_rw", "rw_iop", "iop_rw", "rw_kd", "iop_unCIop", "iop_uncsumiop_unckd", "rw_rwNORM", "rtosa_trans", "rtosa_rpath"};
        for (int i = 0; i < 10; ++i) {
            Path nnDir = this.testDir.resolve(alternativeNetDirNamesWithUpperCase[i]);
            Files.createDirectories(nnDir, new FileAttribute[0]);
            Path nnfile = nnDir.resolve("nnFile_" + i + ".net");
            Files.createFile(nnfile, new FileAttribute[0]);
        }
        String[] nnFilePaths = NNUtils.getNNFilePaths((Path)this.testDir, (String[])NNUtils.ALTERNATIVE_NET_DIR_NAMES);
        Assert.assertNotNull((Object)nnFilePaths);
        Assert.assertEquals((long)10L, (long)nnFilePaths.length);
        for (int i = 0; i < NNUtils.ALTERNATIVE_NET_DIR_NAMES.length; ++i) {
            String nameWithUpperCase = alternativeNetDirNamesWithUpperCase[i];
            Assert.assertTrue((boolean)nnFilePaths[i].contains(this.sep + nameWithUpperCase + this.sep));
        }
    }
}

