/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.c2rcc.msi;

import org.esa.s3tbx.c2rcc.msi.C2rccMsiAlgorithm;
import org.esa.s3tbx.c2rcc.msi.C2rccMsiOperator;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class MsiProductSignatureTest {
    private static final String[] EXPECTED_RHOW_BANDS = new String[]{"rhow_B1", "rhow_B2", "rhow_B3", "rhow_B4", "rhow_B5", "rhow_B6", "rhow_B7", "rhow_B8A"};
    private static final String[] EXPECTED_RRS_BANDS = new String[]{"rrs_B1", "rrs_B2", "rrs_B3", "rrs_B4", "rrs_B5", "rrs_B6", "rrs_B7", "rrs_B8A"};
    private static final String[] EXPECTED_NORM_REFLEC_BANDS = new String[]{"rhown_B1", "rhown_B2", "rhown_B3", "rhown_B4", "rhown_B5", "rhown_B6"};
    private static final String EXPECTED_IOP_APIG = "iop_apig";
    private static final String EXPECTED_IOP_ADET = "iop_adet";
    private static final String EXPECTED_IOP_AGELB = "iop_agelb";
    private static final String EXPECTED_IOP_BPART = "iop_bpart";
    private static final String EXPECTED_IOP_BWIT = "iop_bwit";
    private static final String EXPECTED_IOP_ADG = "iop_adg";
    private static final String EXPECTED_IOP_ATOT = "iop_atot";
    private static final String EXPECTED_IOP_BTOT = "iop_btot";
    private static final String EXPECTED_CONC_CHL = "conc_chl";
    private static final String EXPECTED_CONC_TSM = "conc_tsm";
    private static final String[] EXPECTED_KD_BANDS = new String[]{"kd489", "kdmin", "kd_z90max"};
    private static final String EXPECTED_OOS_RTOSA = "oos_rtosa";
    private static final String EXPECTED_OOS_RHOW = "oos_rhow";
    private static final String EXPECTED_OOS_RRS = "oos_rrs";
    private static final String[] EXPECTED_IOP_UNC_BANDS = new String[]{"unc_apig", "unc_adet", "unc_agelb", "unc_bpart", "unc_bwit", "unc_adg", "unc_atot", "unc_btot"};
    private static final String[] EXPECTED_KD_UNC_BANDS = new String[]{"unc_kd489", "unc_kdmin"};
    private static final String[] EXPECTED_RTOSA_GC_BANDS = new String[]{"rtosa_gc_B1", "rtosa_gc_B2", "rtosa_gc_B3", "rtosa_gc_B4", "rtosa_gc_B5", "rtosa_gc_B6", "rtosa_gc_B7", "rtosa_gc_B8A"};
    private static final String[] EXPECTED_RTOSA_GCAANN_BANDS = new String[]{"rtosagc_aann_B1", "rtosagc_aann_B2", "rtosagc_aann_B3", "rtosagc_aann_B4", "rtosagc_aann_B5", "rtosagc_aann_B6", "rtosagc_aann_B7", "rtosagc_aann_B8A"};
    private static final String[] EXPECTED_RTOA_BANDS = new String[]{"rtoa_B1", "rtoa_B2", "rtoa_B3", "rtoa_B4", "rtoa_B5", "rtoa_B6", "rtoa_B7", "rtoa_B8", "rtoa_B8A", "rtoa_B9", "rtoa_B10", "rtoa_B11", "rtoa_B12"};
    private static final String[] EXPECTED_RPATH_BANDS = new String[]{"rpath_B1", "rpath_B2", "rpath_B3", "rpath_B4", "rpath_B5", "rpath_B6", "rpath_B7", "rpath_B8A"};
    private static final String[] EXPECTED_TDOWN_BANDS = new String[]{"tdown_B1", "tdown_B2", "tdown_B3", "tdown_B4", "tdown_B5", "tdown_B6", "tdown_B7", "tdown_B8A"};
    private static final String[] EXPECTED_TUP_BANDS = new String[]{"tup_B1", "tup_B2", "tup_B3", "tup_B4", "tup_B5", "tup_B6", "tup_B7", "tup_B8A"};
    private static final String EXPECTED_C2RCC_FLAGS = "c2rcc_flags";
    private static final String EXPECTED_PRODUCT_TYPE = "C2RCC_S2-MSI";

    @Test
    public void testProductSignature_Default() throws FactoryException, TransformException {
        C2rccMsiOperator operator = this.createDefaultOperator();
        Product targetProduct = operator.getTargetProduct();
        this.assertDefaults(targetProduct, false);
    }

    @Test
    public void testProductSignature_Default_AsRrs() throws FactoryException, TransformException {
        C2rccMsiOperator operator = this.createDefaultOperator();
        operator.setOutputAsRrs(true);
        operator.setOutputOos(true);
        Product targetProduct = operator.getTargetProduct();
        this.assertDefaults(targetProduct, true);
        this.assertBands(targetProduct, EXPECTED_OOS_RTOSA);
        this.assertBands(targetProduct, EXPECTED_OOS_RRS);
    }

    @Test
    public void testProductSignature_OnlyMandatory() throws FactoryException, TransformException {
        C2rccMsiOperator operator = this.createDefaultOperator();
        operator.setOutputRtoa(false);
        operator.setOutputUncertainties(false);
        operator.setOutputAcReflectance(false);
        operator.setOutputRhown(false);
        operator.setOutputKd(false);
        Product targetProduct = operator.getTargetProduct();
        this.assertMandatoryBands(targetProduct);
        Assert.assertEquals((long)11L, (long)targetProduct.getNumBands());
    }

    @Test
    public void testProductSignature_DefaultWithRtosa() throws FactoryException, TransformException {
        C2rccMsiOperator operator = this.createDefaultOperator();
        operator.setOutputRtosa(true);
        operator.setOutputRtosaGcAann(true);
        Product targetProduct = operator.getTargetProduct();
        this.assertDefaults(targetProduct, false);
        this.assertBands(targetProduct, EXPECTED_RTOSA_GC_BANDS);
        this.assertBands(targetProduct, EXPECTED_RTOSA_GCAANN_BANDS);
    }

    @Test
    public void testProductSignature_DefaultWithRtoa() throws FactoryException, TransformException {
        C2rccMsiOperator operator = this.createDefaultOperator();
        operator.setOutputRtoa(true);
        Product targetProduct = operator.getTargetProduct();
        this.assertDefaults(targetProduct, false);
        this.assertBands(targetProduct, EXPECTED_RTOA_BANDS);
    }

    @Test
    public void testProductSignature_DefaultWithOthers() throws FactoryException, TransformException {
        C2rccMsiOperator operator = this.createDefaultOperator();
        operator.setOutputRpath(true);
        operator.setOutputTdown(true);
        operator.setOutputTup(true);
        operator.setOutputOos(true);
        Product targetProduct = operator.getTargetProduct();
        this.assertDefaults(targetProduct, false);
        this.assertBands(targetProduct, EXPECTED_RPATH_BANDS);
        this.assertBands(targetProduct, EXPECTED_TDOWN_BANDS);
        this.assertBands(targetProduct, EXPECTED_TUP_BANDS);
        this.assertBands(targetProduct, EXPECTED_OOS_RTOSA);
        this.assertBands(targetProduct, EXPECTED_OOS_RHOW);
    }

    @Test
    public void testProductSignature_DeriveRwAlternative() throws FactoryException, TransformException {
        C2rccMsiOperator operator = this.createDefaultOperator();
        operator.setDeriveRwFromPathAndTransmittance(true);
        Product targetProduct = operator.getTargetProduct();
        this.assertDefaults(targetProduct, false);
    }

    @Test
    public void testProductSignature_DefaultWithKd() throws FactoryException, TransformException {
        C2rccMsiOperator operator = this.createDefaultOperator();
        operator.setOutputKd(true);
        Product targetProduct = operator.getTargetProduct();
        this.assertDefaults(targetProduct, false);
        this.assertBands(targetProduct, EXPECTED_KD_BANDS);
    }

    private void assertDefaults(Product targetProduct, boolean asRrs) {
        this.assertMandatoryBands(targetProduct);
        if (asRrs) {
            this.assertBands(targetProduct, EXPECTED_RRS_BANDS);
        } else {
            this.assertBands(targetProduct, EXPECTED_RHOW_BANDS);
        }
        this.assertBands(targetProduct, EXPECTED_RTOA_BANDS);
        this.assertBands(targetProduct, EXPECTED_NORM_REFLEC_BANDS);
        this.assertBands(targetProduct, EXPECTED_KD_BANDS);
        this.assertBands(targetProduct, EXPECTED_IOP_UNC_BANDS);
        this.assertBands(targetProduct, EXPECTED_KD_UNC_BANDS);
        Assert.assertEquals((Object)EXPECTED_PRODUCT_TYPE, (Object)targetProduct.getProductType());
    }

    private void assertMandatoryBands(Product targetProduct) {
        this.assertBands(targetProduct, EXPECTED_IOP_APIG);
        this.assertBands(targetProduct, EXPECTED_IOP_ADET);
        this.assertBands(targetProduct, EXPECTED_IOP_AGELB);
        this.assertBands(targetProduct, EXPECTED_IOP_BPART);
        this.assertBands(targetProduct, EXPECTED_IOP_BWIT);
        this.assertBands(targetProduct, EXPECTED_IOP_ADG);
        this.assertBands(targetProduct, EXPECTED_IOP_ATOT);
        this.assertBands(targetProduct, EXPECTED_IOP_BTOT);
        this.assertBands(targetProduct, EXPECTED_CONC_CHL);
        this.assertBands(targetProduct, EXPECTED_CONC_TSM);
        this.assertBands(targetProduct, EXPECTED_C2RCC_FLAGS);
    }

    private void assertBands(Product targetProduct, String ... expectedBands) {
        for (String expectedBand : expectedBands) {
            Assert.assertTrue((String)("Expected band " + expectedBand + " in product"), (boolean)targetProduct.containsBand(expectedBand));
        }
    }

    private C2rccMsiOperator createDefaultOperator() throws FactoryException, TransformException {
        C2rccMsiOperator operator = new C2rccMsiOperator();
        operator.setParameterDefaultValues();
        operator.setSourceProduct(this.createMsiTestProduct());
        return operator;
    }

    private Product createMsiTestProduct() throws FactoryException, TransformException {
        Product product = new Product("test-msi", "S2_MSI_Level-1C", 1, 1);
        for (String reflBandName : C2rccMsiAlgorithm.SOURCE_BAND_REFL_NAMES) {
            product.addBand(reflBandName, "3863");
        }
        product.addBand("sun_azimuth", "42");
        product.addBand("sun_zenith", "42");
        product.addBand("view_azimuth_mean", "42");
        product.addBand("view_zenith_mean", "42");
        product.setSceneGeoCoding((GeoCoding)new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, 1, 1, 10.0, 50.0, 1.0, 1.0));
        MetadataElement l1cUserProduct = new MetadataElement("Level-1C_User_Product");
        MetadataElement generalInfo = new MetadataElement("General_Info");
        MetadataElement productInfo = new MetadataElement("Product_Info");
        productInfo.addAttribute(new MetadataAttribute("PRODUCT_START_TIME", ProductData.createInstance((String)"2015-08-12T10:40:21.459Z"), true));
        productInfo.addAttribute(new MetadataAttribute("PRODUCT_STOP_TIME", ProductData.createInstance((String)"2015-08-12T10:40:21.459Z"), true));
        MetadataElement imageCharacteristics = new MetadataElement("Product_Image_Characteristics");
        imageCharacteristics.addAttribute(new MetadataAttribute("QUANTIFICATION_VALUE", ProductData.createInstance((String)"1000"), true));
        l1cUserProduct.addElement(generalInfo);
        generalInfo.addElement(productInfo);
        generalInfo.addElement(imageCharacteristics);
        product.getMetadataRoot().addElement(l1cUserProduct);
        return product;
    }
}

