/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.c2rcc.meris;

import java.util.Date;
import org.esa.s3tbx.c2rcc.meris.C2rccMerisAlgorithm;
import org.esa.s3tbx.c2rcc.meris.C2rccMerisOperator;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class MerisProductSignatureTest {
    private static final String[] EXPECTED_RHOW_BANDS = new String[]{"rhow_1", "rhow_2", "rhow_3", "rhow_4", "rhow_5", "rhow_6", "rhow_7", "rhow_8", "rhow_9", "rhow_10", "rhow_12", "rhow_13"};
    private static final String[] EXPECTED_RRS_BANDS = new String[]{"rrs_1", "rrs_2", "rrs_3", "rrs_4", "rrs_5", "rrs_6", "rrs_7", "rrs_8", "rrs_9", "rrs_10", "rrs_12", "rrs_13"};
    private static final String[] EXPECTED_NORM_REFLEC_BANDS = new String[]{"rhown_1", "rhown_2", "rhown_3", "rhown_4", "rhown_5", "rhown_6", "rhown_7", "rhown_8", "rhown_9", "rhown_10", "rhown_12", "rhown_13"};
    private static final String EXPECTED_IOP_APIG = "iop_apig";
    private static final String EXPECTED_IOP_ADET = "iop_adet";
    private static final String EXPECTED_IOP_AGELB = "iop_agelb";
    private static final String EXPECTED_IOP_BPART = "iop_bpart";
    private static final String EXPECTED_IOP_BWIT = "iop_bwit";
    private static final String EXPECTED_IOP_ADG = "iop_adg";
    private static final String EXPECTED_IOP_ATOT = "iop_atot";
    private static final String EXPECTED_IOP_BTOT = "iop_btot";
    private static final String EXPECTED_CONC_CHL = "conc_chl";
    private static final String EXPECTED_CONC_TSM = "conc_tsm";
    private static final String[] EXPECTED_KD_BANDS = new String[]{"kd489", "kdmin", "kd_z90max"};
    private static final String EXPECTED_OOS_RTOSA = "oos_rtosa";
    private static final String EXPECTED_OOS_RHOW = "oos_rhow";
    private static final String EXPECTED_OOS_RRS = "oos_rrs";
    private static final String[] EXPECTED_IOP_UNC_BANDS = new String[]{"unc_apig", "unc_adet", "unc_agelb", "unc_bpart", "unc_bwit", "unc_adg", "unc_atot", "unc_btot"};
    private static final String[] EXPECTED_KD_UNC_BANDS = new String[]{"unc_kd489", "unc_kdmin"};
    private static final String[] EXPECTED_RTOSA_GC_BANDS = new String[]{"rtosa_gc_1", "rtosa_gc_2", "rtosa_gc_3", "rtosa_gc_4", "rtosa_gc_5", "rtosa_gc_6", "rtosa_gc_7", "rtosa_gc_8", "rtosa_gc_9", "rtosa_gc_10", "rtosa_gc_12", "rtosa_gc_13"};
    private static final String[] EXPECTED_RTOSA_GCAANN_BANDS = new String[]{"rtosagc_aann_1", "rtosagc_aann_2", "rtosagc_aann_3", "rtosagc_aann_4", "rtosagc_aann_5", "rtosagc_aann_6", "rtosagc_aann_7", "rtosagc_aann_8", "rtosagc_aann_9", "rtosagc_aann_10", "rtosagc_aann_12", "rtosagc_aann_13"};
    private static final String[] EXPECTED_RTOA_BANDS = new String[]{"rtoa_1", "rtoa_2", "rtoa_3", "rtoa_4", "rtoa_5", "rtoa_6", "rtoa_7", "rtoa_8", "rtoa_9", "rtoa_10", "rtoa_11", "rtoa_12", "rtoa_13", "rtoa_14", "rtoa_15"};
    private static final String[] EXPECTED_RPATH_BANDS = new String[]{"rpath_1", "rpath_2", "rpath_3", "rpath_4", "rpath_5", "rpath_6", "rpath_7", "rpath_8", "rpath_9", "rpath_10", "rpath_12", "rpath_13"};
    private static final String[] EXPECTED_TDOWN_BANDS = new String[]{"tdown_1", "tdown_2", "tdown_3", "tdown_4", "tdown_5", "tdown_6", "tdown_7", "tdown_8", "tdown_9", "tdown_10", "tdown_12", "tdown_13"};
    private static final String[] EXPECTED_TUP_BANDS = new String[]{"tup_1", "tup_2", "tup_3", "tup_4", "tup_5", "tup_6", "tup_7", "tup_8", "tup_9", "tup_10", "tup_12", "tup_13"};
    private static final String EXPECTED_L1_FLAGS = "l1_flags";
    private static final String EXPECTED_C2RCC_FLAGS = "c2rcc_flags";
    private static final String EXPECTED_PRODUCT_TYPE = "C2RCC_MERIS";

    @Test
    public void testProductSignature_Default() throws FactoryException, TransformException {
        C2rccMerisOperator operator = this.createDefaultOperator();
        Product targetProduct = operator.getTargetProduct();
        this.assertDefaults(targetProduct, false);
    }

    @Test
    public void testProductSignature_Default_Rrs() throws FactoryException, TransformException {
        C2rccMerisOperator operator = this.createDefaultOperator();
        operator.setOutputAsRrs(true);
        operator.setOutputOos(true);
        Product targetProduct = operator.getTargetProduct();
        this.assertDefaults(targetProduct, true);
        this.assertBands(targetProduct, EXPECTED_OOS_RTOSA);
        this.assertBands(targetProduct, EXPECTED_OOS_RRS);
    }

    @Test
    public void testProductSignature_OnlyMandatory() throws FactoryException, TransformException {
        C2rccMerisOperator operator = this.createDefaultOperator();
        operator.setOutputRtoa(false);
        operator.setOutputUncertainties(false);
        operator.setOutputAcReflectance(false);
        operator.setOutputRhown(false);
        operator.setOutputKd(false);
        Product targetProduct = operator.getTargetProduct();
        this.assertMandatoryBands(targetProduct);
        Assert.assertEquals((long)12L, (long)targetProduct.getNumBands());
    }

    @Test
    public void testProductSignature_DefaultWithRtosa() throws FactoryException, TransformException {
        C2rccMerisOperator operator = this.createDefaultOperator();
        operator.setOutputRtosa(true);
        operator.setOutputRtosaGcAann(true);
        Product targetProduct = operator.getTargetProduct();
        this.assertDefaults(targetProduct, false);
        this.assertBands(targetProduct, EXPECTED_RTOSA_GC_BANDS);
        this.assertBands(targetProduct, EXPECTED_RTOSA_GCAANN_BANDS);
    }

    @Test
    public void testProductSignature_DefaultWithRtoa() throws FactoryException, TransformException {
        C2rccMerisOperator operator = this.createDefaultOperator();
        operator.setOutputRtoa(true);
        Product targetProduct = operator.getTargetProduct();
        this.assertDefaults(targetProduct, false);
        this.assertBands(targetProduct, EXPECTED_RTOA_BANDS);
    }

    @Test
    public void testProductSignature_DefaultWithOthers() throws FactoryException, TransformException {
        C2rccMerisOperator operator = this.createDefaultOperator();
        operator.setOutputRpath(true);
        operator.setOutputTdown(true);
        operator.setOutputTup(true);
        operator.setOutputOos(true);
        Product targetProduct = operator.getTargetProduct();
        this.assertDefaults(targetProduct, false);
        this.assertBands(targetProduct, EXPECTED_RPATH_BANDS);
        this.assertBands(targetProduct, EXPECTED_TDOWN_BANDS);
        this.assertBands(targetProduct, EXPECTED_TUP_BANDS);
        this.assertBands(targetProduct, EXPECTED_OOS_RTOSA);
        this.assertBands(targetProduct, EXPECTED_OOS_RHOW);
    }

    @Test
    public void testProductSignature_DeriveRwAlternative() throws FactoryException, TransformException {
        C2rccMerisOperator operator = this.createDefaultOperator();
        operator.setDeriveRwFromPathAndTransmittance(true);
        Product targetProduct = operator.getTargetProduct();
        this.assertDefaults(targetProduct, false);
    }

    @Test
    public void testProductSignature_DefaultWithUncertainties() throws FactoryException, TransformException {
        C2rccMerisOperator operator = this.createDefaultOperator();
        operator.setOutputUncertainties(true);
        Product targetProduct = operator.getTargetProduct();
        this.assertDefaults(targetProduct, false);
        this.assertBands(targetProduct, EXPECTED_IOP_UNC_BANDS);
    }

    @Test
    public void testProductSignature_DefaultWithUncertaintiesAndKd() throws FactoryException, TransformException {
        C2rccMerisOperator operator = this.createDefaultOperator();
        operator.setOutputUncertainties(true);
        operator.setOutputKd(true);
        Product targetProduct = operator.getTargetProduct();
        this.assertDefaults(targetProduct, false);
        this.assertBands(targetProduct, EXPECTED_IOP_UNC_BANDS);
        this.assertBands(targetProduct, EXPECTED_KD_UNC_BANDS);
        this.assertBands(targetProduct, EXPECTED_KD_BANDS);
    }

    private void assertDefaults(Product targetProduct, boolean asRrs) {
        this.assertMandatoryBands(targetProduct);
        if (asRrs) {
            this.assertBands(targetProduct, EXPECTED_RRS_BANDS);
        } else {
            this.assertBands(targetProduct, EXPECTED_RHOW_BANDS);
        }
        this.assertBands(targetProduct, EXPECTED_RTOA_BANDS);
        this.assertBands(targetProduct, EXPECTED_NORM_REFLEC_BANDS);
        this.assertBands(targetProduct, EXPECTED_KD_BANDS);
        this.assertBands(targetProduct, EXPECTED_KD_UNC_BANDS);
        this.assertBands(targetProduct, EXPECTED_IOP_UNC_BANDS);
        Assert.assertEquals((Object)EXPECTED_PRODUCT_TYPE, (Object)targetProduct.getProductType());
    }

    private void assertMandatoryBands(Product targetProduct) {
        this.assertBands(targetProduct, EXPECTED_IOP_APIG);
        this.assertBands(targetProduct, EXPECTED_IOP_ADET);
        this.assertBands(targetProduct, EXPECTED_IOP_AGELB);
        this.assertBands(targetProduct, EXPECTED_IOP_BPART);
        this.assertBands(targetProduct, EXPECTED_IOP_BWIT);
        this.assertBands(targetProduct, EXPECTED_IOP_ADG);
        this.assertBands(targetProduct, EXPECTED_IOP_ATOT);
        this.assertBands(targetProduct, EXPECTED_IOP_BTOT);
        this.assertBands(targetProduct, EXPECTED_CONC_CHL);
        this.assertBands(targetProduct, EXPECTED_CONC_TSM);
        this.assertBands(targetProduct, EXPECTED_L1_FLAGS);
        this.assertBands(targetProduct, EXPECTED_C2RCC_FLAGS);
    }

    private void assertBands(Product targetProduct, String ... expectedBands) {
        for (String expectedBand : expectedBands) {
            Assert.assertTrue((String)("Expected band " + expectedBand + " in product"), (boolean)targetProduct.containsBand(expectedBand));
        }
    }

    private C2rccMerisOperator createDefaultOperator() throws FactoryException, TransformException {
        C2rccMerisOperator operator = new C2rccMerisOperator();
        operator.setParameterDefaultValues();
        operator.setSourceProduct(this.createMerisTestProduct());
        return operator;
    }

    private Product createMerisTestProduct() throws FactoryException, TransformException {
        Product product = new Product("test-meris", "t", 1, 1);
        for (int i = 1; i <= 15; ++i) {
            String expression = String.valueOf(i);
            Band radiance = product.addBand("radiance_" + i, expression);
            radiance.setSolarFlux((float)C2rccMerisAlgorithm.DEFAULT_SOLAR_FLUX[i - 1]);
        }
        Date time = new Date();
        product.setStartTime(ProductData.UTC.create((Date)time, (long)0L));
        product.setEndTime(ProductData.UTC.create((Date)time, (long)500L));
        product.addBand("dem_alt", "500");
        product.addBand("sun_azimuth", "42");
        product.addBand("sun_zenith", "42");
        product.addBand("view_azimuth", "42");
        product.addBand("view_zenith", "42");
        product.addBand("atm_press", "980");
        product.addBand("ozone", "306");
        Band flagBand = product.addBand(EXPECTED_L1_FLAGS, 10);
        FlagCoding l1FlagsCoding = new FlagCoding(EXPECTED_L1_FLAGS);
        l1FlagsCoding.addFlag("INVALID", 1, "description");
        l1FlagsCoding.addFlag("LAND_OCEAN", 2, "description");
        product.getFlagCodingGroup().add((ProductNode)l1FlagsCoding);
        flagBand.setSampleCoding((SampleCoding)l1FlagsCoding);
        product.setSceneGeoCoding((GeoCoding)new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, 1, 1, 10.0, 50.0, 1.0, 1.0));
        return product;
    }
}

