/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.c2rcc.ancillary;

import junit.framework.Assert;
import org.esa.s3tbx.c2rcc.ancillary.InterpolationBorderComputer6H;
import org.esa.snap.core.datamodel.ProductData;
import org.junit.Before;
import org.junit.Test;

public class InterpolationBorderComputer6HTest {
    private InterpolationBorderComputer6H computer;
    private ProductData.UTC utc;

    @Before
    public void setUp() throws Exception {
        this.computer = new InterpolationBorderComputer6H();
    }

    @Test
    public void testFirstJanuar2000() throws Exception {
        this.computer.setInterpolationTimeMJD(ProductData.UTC.parse((String)"01-JAN-2000 12:00:00").getMJD());
        Assert.assertEquals((Object)0.375, (Object)this.computer.getStartBorderTimeMDJ());
        Assert.assertEquals((Object)0.625, (Object)this.computer.getEndBorderTimeMJD());
        Assert.assertEquals((String)"N200000106", (String)this.computer.getStartAncFilePrefix());
        Assert.assertEquals((String)"N200000112", (String)this.computer.getEndAncFilePrefix());
    }

    @Test
    public void testTimeNearUpperBorder() throws Exception {
        this.computer.setInterpolationTimeMJD(ProductData.UTC.parse((String)"01-JAN-2000 14:59:00").getMJD());
        Assert.assertEquals((Object)0.375, (Object)this.computer.getStartBorderTimeMDJ());
        Assert.assertEquals((Object)0.625, (Object)this.computer.getEndBorderTimeMJD());
        Assert.assertEquals((String)"N200000106", (String)this.computer.getStartAncFilePrefix());
        Assert.assertEquals((String)"N200000112", (String)this.computer.getEndAncFilePrefix());
    }

    @Test
    public void testTimeNearLowerBorder() throws Exception {
        this.computer.setInterpolationTimeMJD(ProductData.UTC.parse((String)"01-JAN-2000 15:00:01").getMJD());
        Assert.assertEquals((Object)0.625, (Object)this.computer.getStartBorderTimeMDJ());
        Assert.assertEquals((Object)0.875, (Object)this.computer.getEndBorderTimeMJD());
        Assert.assertEquals((String)"N200000112", (String)this.computer.getStartAncFilePrefix());
        Assert.assertEquals((String)"N200000118", (String)this.computer.getEndAncFilePrefix());
    }
}

