/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.c2rcc.ancillary;

import junit.framework.Assert;
import org.esa.s3tbx.c2rcc.ancillary.InterpolationBorderComputer24H;
import org.esa.snap.core.datamodel.ProductData;
import org.junit.Before;
import org.junit.Test;

public class InterpolationBorderComputer24HTest {
    private InterpolationBorderComputer24H computer;
    private ProductData.UTC utc;

    @Before
    public void setUp() throws Exception {
        this.computer = new InterpolationBorderComputer24H();
        this.utc = ProductData.UTC.parse((String)"03-AUG-2008 13:30:00");
    }

    @Test
    public void testUTCmjd() throws Exception {
        Assert.assertEquals((double)3137.0, (double)5625.0, (double)this.utc.getMJD());
    }

    @Test
    public void testFirstJanuar2000_before_twelve() throws Exception {
        this.computer.setInterpolationTimeMJD(ProductData.UTC.parse((String)"01-JAN-2000 11:59:59").getMJD());
        Assert.assertEquals((Object)-0.5, (Object)this.computer.getStartBorderTimeMDJ());
        Assert.assertEquals((Object)0.5, (Object)this.computer.getEndBorderTimeMJD());
        Assert.assertEquals((String)"N199936500", (String)this.computer.getStartAncFilePrefix());
        Assert.assertEquals((String)"N200000100", (String)this.computer.getEndAncFilePrefix());
    }

    @Test
    public void testFirstJanuar2000_twelve() throws Exception {
        this.computer.setInterpolationTimeMJD(ProductData.UTC.parse((String)"01-JAN-2000 12:00:00").getMJD());
        Assert.assertEquals((Object)0.5, (Object)this.computer.getStartBorderTimeMDJ());
        Assert.assertEquals((Object)1.5, (Object)this.computer.getEndBorderTimeMJD());
        Assert.assertEquals((String)"N200000100", (String)this.computer.getStartAncFilePrefix());
        Assert.assertEquals((String)"N200000200", (String)this.computer.getEndAncFilePrefix());
    }

    @Test
    public void testFirstJanuar2000_after_twelve() throws Exception {
        this.computer.setInterpolationTimeMJD(ProductData.UTC.parse((String)"01-JAN-2000 12:00:01").getMJD());
        Assert.assertEquals((Object)0.5, (Object)this.computer.getStartBorderTimeMDJ());
        Assert.assertEquals((Object)1.5, (Object)this.computer.getEndBorderTimeMJD());
        Assert.assertEquals((String)"N200000100", (String)this.computer.getStartAncFilePrefix());
        Assert.assertEquals((String)"N200000200", (String)this.computer.getEndAncFilePrefix());
    }

    @Test
    public void testBorderStartAndEndTime() throws Exception {
        this.computer.setInterpolationTimeMJD(this.utc.getMJD());
        Assert.assertEquals((String)"03-AUG-2008 13:30:00.000000", (String)this.utc.format());
        Assert.assertEquals((Object)3137.5, (Object)this.computer.getStartBorderTimeMDJ());
        Assert.assertEquals((Object)3138.5, (Object)this.computer.getEndBorderTimeMJD());
    }

    @Test
    public void testStartAndEndFilePr\u00e4fix() throws Exception {
        this.computer.setInterpolationTimeMJD(this.utc.getMJD());
        Assert.assertEquals((String)"03-AUG-2008 13:30:00.000000", (String)this.utc.format());
        Assert.assertEquals((String)"N200821600", (String)this.computer.getStartAncFilePrefix());
        Assert.assertEquals((String)"N200821700", (String)this.computer.getEndAncFilePrefix());
    }
}

