/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.c2rcc.ancillary;

import junit.framework.Assert;
import org.esa.s3tbx.c2rcc.ancillary.DataInterpolator;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class DataInterpolator_GeocodingTest {
    private GeoPos gPos;
    private PixelPos pPos;

    @Before
    public void setUp() {
        this.gPos = new GeoPos();
        this.pPos = new PixelPos();
    }

    @After
    public void tearDown() {
        this.gPos.setInvalid();
        this.pPos.setInvalid();
    }

    @Test
    public void testGetPixelPos_aroundTheCenter_140x70_Product_0_0() {
        DataInterpolator.GlobalGeoCoding gc = new DataInterpolator.GlobalGeoCoding(140, 70);
        this.gPos.setLocation(1.0E-4, -1.0E-4);
        Assert.assertSame((Object)this.pPos, (Object)gc.getPixelPos(this.gPos, this.pPos));
        Assert.assertEquals((Object)69.5, (Object)this.pPos.getX());
        Assert.assertEquals((Object)34.5, (Object)this.pPos.getY());
        this.gPos.setLocation(1.0E-4, 1.0E-4);
        Assert.assertSame((Object)this.pPos, (Object)gc.getPixelPos(this.gPos, this.pPos));
        Assert.assertEquals((Object)70.5, (Object)this.pPos.getX());
        Assert.assertEquals((Object)34.5, (Object)this.pPos.getY());
        this.gPos.setLocation(-1.0E-4, 1.0E-4);
        Assert.assertSame((Object)this.pPos, (Object)gc.getPixelPos(this.gPos, this.pPos));
        Assert.assertEquals((Object)70.5, (Object)this.pPos.getX());
        Assert.assertEquals((Object)35.5, (Object)this.pPos.getY());
        this.gPos.setLocation(-1.0E-4, -1.0E-4);
        Assert.assertSame((Object)this.pPos, (Object)gc.getPixelPos(this.gPos, this.pPos));
        Assert.assertEquals((Object)69.5, (Object)this.pPos.getX());
        Assert.assertEquals((Object)35.5, (Object)this.pPos.getY());
    }

    @Test
    public void testGetPixelPos_alongTheBorder_140x70_Product_0_0() {
        DataInterpolator.GlobalGeoCoding gc = new DataInterpolator.GlobalGeoCoding(140, 70);
        this.gPos.setLocation(90.0, -180.0);
        Assert.assertSame((Object)this.pPos, (Object)gc.getPixelPos(this.gPos, this.pPos));
        Assert.assertEquals((Object)0.5, (Object)this.pPos.getX());
        Assert.assertEquals((Object)0.5, (Object)this.pPos.getY());
        this.gPos.setLocation(90.0, 180.0);
        Assert.assertSame((Object)this.pPos, (Object)gc.getPixelPos(this.gPos, this.pPos));
        Assert.assertEquals((Object)139.5, (Object)this.pPos.getX());
        Assert.assertEquals((Object)0.5, (Object)this.pPos.getY());
        this.gPos.setLocation(-90.0, 180.0);
        Assert.assertSame((Object)this.pPos, (Object)gc.getPixelPos(this.gPos, this.pPos));
        Assert.assertEquals((Object)139.5, (Object)this.pPos.getX());
        Assert.assertEquals((Object)69.5, (Object)this.pPos.getY());
        this.gPos.setLocation(-90.0, -180.0);
        Assert.assertSame((Object)this.pPos, (Object)gc.getPixelPos(this.gPos, this.pPos));
        Assert.assertEquals((Object)0.5, (Object)this.pPos.getX());
        Assert.assertEquals((Object)69.5, (Object)this.pPos.getY());
    }

    @Test
    public void testGetPixelPos_aroundTheCenter_144x73_Product_0_0() {
        DataInterpolator.GlobalGeoCoding gc = new DataInterpolator.GlobalGeoCoding(144, 73);
        this.gPos.setLocation(1.0E-4, -1.0E-4);
        Assert.assertSame((Object)this.pPos, (Object)gc.getPixelPos(this.gPos, this.pPos));
        Assert.assertEquals((Object)71.5, (Object)this.pPos.getX());
        Assert.assertEquals((Object)36.5, (Object)this.pPos.getY());
        this.gPos.setLocation(1.0E-4, 1.0E-4);
        Assert.assertSame((Object)this.pPos, (Object)gc.getPixelPos(this.gPos, this.pPos));
        Assert.assertEquals((Object)72.5, (Object)this.pPos.getX());
        Assert.assertEquals((Object)36.5, (Object)this.pPos.getY());
        this.gPos.setLocation(-1.0E-4, 1.0E-4);
        Assert.assertSame((Object)this.pPos, (Object)gc.getPixelPos(this.gPos, this.pPos));
        Assert.assertEquals((Object)72.5, (Object)this.pPos.getX());
        Assert.assertEquals((Object)36.5, (Object)this.pPos.getY());
        this.gPos.setLocation(-1.0E-4, -1.0E-4);
        Assert.assertSame((Object)this.pPos, (Object)gc.getPixelPos(this.gPos, this.pPos));
        Assert.assertEquals((Object)71.5, (Object)this.pPos.getX());
        Assert.assertEquals((Object)36.5, (Object)this.pPos.getY());
    }

    @Test
    public void testGetPixelPos_alongTheBorder_144x73_Product_0_0() {
        DataInterpolator.GlobalGeoCoding gc = new DataInterpolator.GlobalGeoCoding(144, 73);
        this.gPos.setLocation(90.0, -180.0);
        Assert.assertSame((Object)this.pPos, (Object)gc.getPixelPos(this.gPos, this.pPos));
        Assert.assertEquals((Object)0.5, (Object)this.pPos.getX());
        Assert.assertEquals((Object)0.5, (Object)this.pPos.getY());
        this.gPos.setLocation(90.0, 180.0);
        Assert.assertSame((Object)this.pPos, (Object)gc.getPixelPos(this.gPos, this.pPos));
        Assert.assertEquals((Object)143.5, (Object)this.pPos.getX());
        Assert.assertEquals((Object)0.5, (Object)this.pPos.getY());
        this.gPos.setLocation(-90.0, 180.0);
        Assert.assertSame((Object)this.pPos, (Object)gc.getPixelPos(this.gPos, this.pPos));
        Assert.assertEquals((Object)143.5, (Object)this.pPos.getX());
        Assert.assertEquals((Object)72.5, (Object)this.pPos.getY());
        this.gPos.setLocation(-90.0, -180.0);
        Assert.assertSame((Object)this.pPos, (Object)gc.getPixelPos(this.gPos, this.pPos));
        Assert.assertEquals((Object)0.5, (Object)this.pPos.getX());
        Assert.assertEquals((Object)72.5, (Object)this.pPos.getY());
    }

    @Test
    public void testGetPixelPos_aroundTheCenter_360x180_Product_0_0() {
        DataInterpolator.GlobalGeoCoding gc = new DataInterpolator.GlobalGeoCoding(360, 180);
        this.gPos.setLocation(1.0E-4, -1.0E-4);
        Assert.assertSame((Object)this.pPos, (Object)gc.getPixelPos(this.gPos, this.pPos));
        Assert.assertEquals((Object)179.5, (Object)this.pPos.getX());
        Assert.assertEquals((Object)89.5, (Object)this.pPos.getY());
        this.gPos.setLocation(1.0E-4, 1.0E-4);
        Assert.assertSame((Object)this.pPos, (Object)gc.getPixelPos(this.gPos, this.pPos));
        Assert.assertEquals((Object)180.5, (Object)this.pPos.getX());
        Assert.assertEquals((Object)89.5, (Object)this.pPos.getY());
        this.gPos.setLocation(-1.0E-4, 1.0E-4);
        Assert.assertSame((Object)this.pPos, (Object)gc.getPixelPos(this.gPos, this.pPos));
        Assert.assertEquals((Object)180.5, (Object)this.pPos.getX());
        Assert.assertEquals((Object)90.5, (Object)this.pPos.getY());
        this.gPos.setLocation(-1.0E-4, -1.0E-4);
        Assert.assertSame((Object)this.pPos, (Object)gc.getPixelPos(this.gPos, this.pPos));
        Assert.assertEquals((Object)179.5, (Object)this.pPos.getX());
        Assert.assertEquals((Object)90.5, (Object)this.pPos.getY());
    }

    @Test
    public void testGetPixelPos_alongTheBorder_360x181_Product_0_0() {
        DataInterpolator.GlobalGeoCoding gc = new DataInterpolator.GlobalGeoCoding(360, 181);
        this.gPos.setLocation(90.0, -180.0);
        Assert.assertSame((Object)this.pPos, (Object)gc.getPixelPos(this.gPos, this.pPos));
        Assert.assertEquals((Object)0.5, (Object)this.pPos.getX());
        Assert.assertEquals((Object)0.5, (Object)this.pPos.getY());
        this.gPos.setLocation(90.0, 180.0);
        Assert.assertSame((Object)this.pPos, (Object)gc.getPixelPos(this.gPos, this.pPos));
        Assert.assertEquals((Object)359.5, (Object)this.pPos.getX());
        Assert.assertEquals((Object)0.5, (Object)this.pPos.getY());
        this.gPos.setLocation(-90.0, 180.0);
        Assert.assertSame((Object)this.pPos, (Object)gc.getPixelPos(this.gPos, this.pPos));
        Assert.assertEquals((Object)359.5, (Object)this.pPos.getX());
        Assert.assertEquals((Object)180.5, (Object)this.pPos.getY());
        this.gPos.setLocation(-90.0, -180.0);
        Assert.assertSame((Object)this.pPos, (Object)gc.getPixelPos(this.gPos, this.pPos));
        Assert.assertEquals((Object)0.5, (Object)this.pPos.getX());
        Assert.assertEquals((Object)180.5, (Object)this.pPos.getY());
    }
}

