/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.c2rcc.ancillary;

import java.io.File;
import java.io.IOException;
import org.esa.s3tbx.c2rcc.ancillary.AncRepository;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AncRepositoryTest_ValidFileNamePattern {
    private AncRepository ancRepository;
    private String validFilename;

    @Before
    public void setUp() throws Exception {
        this.ancRepository = new AncRepository(new File("asd"));
        this.validFilename = "N200136524_lsmf";
    }

    @Test
    public void testValidFilename() throws IOException {
        try {
            this.ancRepository.getProduct(new String[]{this.validFilename});
        }
        catch (IllegalArgumentException notExpected) {
            Assert.fail((String)"IllegalArgumentException not expected.");
        }
    }

    @Test
    public void testCharacter_0_invalid_S() throws Exception {
        String invalidFilename = this.replaceCharacter(0, 'S');
        try {
            this.ancRepository.getProduct(new String[]{invalidFilename});
            Assert.fail((String)"IllegalArgumentException expected.");
        }
        catch (IllegalArgumentException expected) {
            Assert.assertThat((Object)expected.getMessage(), (Matcher)CoreMatchers.containsString((String)"is not a valid ancillary filename"));
        }
    }

    @Test
    public void testCharacter_1_invalid_0() throws Exception {
        String invalidFilename = this.replaceCharacter(1, '0');
        try {
            this.ancRepository.getProduct(new String[]{invalidFilename});
            Assert.fail((String)"IllegalArgumentException expected.");
        }
        catch (IllegalArgumentException expected) {
            Assert.assertThat((Object)expected.getMessage(), (Matcher)CoreMatchers.containsString((String)"is not a valid ancillary filename"));
        }
    }

    @Test
    public void testCharacter_1_invalid_3() throws Exception {
        String invalidFilename = this.replaceCharacter(1, '3');
        try {
            this.ancRepository.getProduct(new String[]{invalidFilename});
            Assert.fail((String)"IllegalArgumentException expected.");
        }
        catch (IllegalArgumentException expected) {
            Assert.assertThat((Object)expected.getMessage(), (Matcher)CoreMatchers.containsString((String)"is not a valid ancillary filename"));
        }
    }

    @Test
    public void testCharacter_2_invalid_1() throws Exception {
        String invalidFilename = this.replaceCharacter(2, '1');
        try {
            this.ancRepository.getProduct(new String[]{invalidFilename});
            Assert.fail((String)"IllegalArgumentException expected.");
        }
        catch (IllegalArgumentException expected) {
            Assert.assertThat((Object)expected.getMessage(), (Matcher)CoreMatchers.containsString((String)"is not a valid ancillary filename"));
        }
    }

    @Test
    public void testCharacter_2_invalid_8() throws Exception {
        String invalidFilename = this.replaceCharacter(2, '8');
        try {
            this.ancRepository.getProduct(new String[]{invalidFilename});
            Assert.fail((String)"IllegalArgumentException expected.");
        }
        catch (IllegalArgumentException expected) {
            Assert.assertThat((Object)expected.getMessage(), (Matcher)CoreMatchers.containsString((String)"is not a valid ancillary filename"));
        }
    }

    @Test
    public void testCharacter_3_invalid_x() throws Exception {
        String invalidFilename = this.replaceCharacter(3, 'x');
        try {
            this.ancRepository.getProduct(new String[]{invalidFilename});
            Assert.fail((String)"IllegalArgumentException expected.");
        }
        catch (IllegalArgumentException expected) {
            Assert.assertThat((Object)expected.getMessage(), (Matcher)CoreMatchers.containsString((String)"is not a valid ancillary filename"));
        }
    }

    @Test
    public void testCharacter_4_invalid_x() throws Exception {
        String invalidFilename = this.replaceCharacter(4, 'x');
        try {
            this.ancRepository.getProduct(new String[]{invalidFilename});
            Assert.fail((String)"IllegalArgumentException expected.");
        }
        catch (IllegalArgumentException expected) {
            Assert.assertThat((Object)expected.getMessage(), (Matcher)CoreMatchers.containsString((String)"is not a valid ancillary filename"));
        }
    }

    @Test
    public void testCharacter_5_invalid_4() throws Exception {
        String invalidFilename = this.replaceCharacter(5, '4');
        try {
            this.ancRepository.getProduct(new String[]{invalidFilename});
            Assert.fail((String)"IllegalArgumentException expected.");
        }
        catch (IllegalArgumentException expected) {
            Assert.assertThat((Object)expected.getMessage(), (Matcher)CoreMatchers.containsString((String)"is not a valid ancillary filename"));
        }
    }

    @Test
    public void testCharacter_5_invalid_9() throws Exception {
        String invalidFilename = this.replaceCharacter(5, '9');
        try {
            this.ancRepository.getProduct(new String[]{invalidFilename});
            Assert.fail((String)"IllegalArgumentException expected.");
        }
        catch (IllegalArgumentException expected) {
            Assert.assertThat((Object)expected.getMessage(), (Matcher)CoreMatchers.containsString((String)"is not a valid ancillary filename"));
        }
    }

    @Test
    public void testCharacter_6_invalid_x() throws Exception {
        String invalidFilename = this.replaceCharacter(6, 'x');
        try {
            this.ancRepository.getProduct(new String[]{invalidFilename});
            Assert.fail((String)"IllegalArgumentException expected.");
        }
        catch (IllegalArgumentException expected) {
            Assert.assertThat((Object)expected.getMessage(), (Matcher)CoreMatchers.containsString((String)"is not a valid ancillary filename"));
        }
    }

    @Test
    public void testCharacter_7_invalid_x() throws Exception {
        String invalidFilename = this.replaceCharacter(7, 'x');
        try {
            this.ancRepository.getProduct(new String[]{invalidFilename});
            Assert.fail((String)"IllegalArgumentException expected.");
        }
        catch (IllegalArgumentException expected) {
            Assert.assertThat((Object)expected.getMessage(), (Matcher)CoreMatchers.containsString((String)"is not a valid ancillary filename"));
        }
    }

    @Test
    public void testCharacter_8_invalid_3() throws Exception {
        String invalidFilename = this.replaceCharacter(8, '3');
        try {
            this.ancRepository.getProduct(new String[]{invalidFilename});
            Assert.fail((String)"IllegalArgumentException expected.");
        }
        catch (IllegalArgumentException expected) {
            Assert.assertThat((Object)expected.getMessage(), (Matcher)CoreMatchers.containsString((String)"is not a valid ancillary filename"));
        }
    }

    @Test
    public void testCharacter_9_invalid_x() throws Exception {
        String invalidFilename = this.replaceCharacter(9, 'x');
        try {
            this.ancRepository.getProduct(new String[]{invalidFilename});
            Assert.fail((String)"IllegalArgumentException expected.");
        }
        catch (IllegalArgumentException expected) {
            Assert.assertThat((Object)expected.getMessage(), (Matcher)CoreMatchers.containsString((String)"is not a valid ancillary filename"));
        }
    }

    @Test
    public void testCharacter_10_invalid_x() throws Exception {
        String invalidFilename = this.replaceCharacter(10, 'x');
        try {
            this.ancRepository.getProduct(new String[]{invalidFilename});
            Assert.fail((String)"IllegalArgumentException expected.");
        }
        catch (IllegalArgumentException expected) {
            Assert.assertThat((Object)expected.getMessage(), (Matcher)CoreMatchers.containsString((String)"is not a valid ancillary filename"));
        }
    }

    private String replaceCharacter(int pos, char character) {
        char[] chars = this.validFilename.toCharArray();
        chars[pos] = character;
        return new String(chars);
    }
}

