/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.c2rcc.util;

import org.esa.s3tbx.c2rcc.util.SolarFluxCorrectionFactorCalculator;
import org.esa.s3tbx.c2rcc.util.SolarFluxLazyLookup;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SolarFluxLazyLookupTest {
    private SolarFluxLazyLookup lookup;

    @Before
    public void setUp() throws Exception {
        this.lookup = new SolarFluxLazyLookup(new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0});
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testCreationWithDefaultFlux() {
        SolarFluxLazyLookup lookup = new SolarFluxLazyLookup(new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0});
        Assert.assertArrayEquals((double[])new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0}, (double[])lookup.solFlux, (double)1.0E-12);
    }

    @Test
    public void testRightValuesForNoneLeapYear() {
        Assert.assertArrayEquals((double[])this.computeCorrectedFlux(0, 2005), (double[])this.lookup.getCorrectedFluxFor(0, 2005), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.computeCorrectedFlux(23, 2005), (double[])this.lookup.getCorrectedFluxFor(23, 2005), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.computeCorrectedFlux(50, 2005), (double[])this.lookup.getCorrectedFluxFor(50, 2005), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.computeCorrectedFlux(77, 2005), (double[])this.lookup.getCorrectedFluxFor(77, 2005), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.computeCorrectedFlux(100, 2005), (double[])this.lookup.getCorrectedFluxFor(100, 2005), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.computeCorrectedFlux(119, 2005), (double[])this.lookup.getCorrectedFluxFor(119, 2005), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.computeCorrectedFlux(150, 2005), (double[])this.lookup.getCorrectedFluxFor(150, 2005), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.computeCorrectedFlux(176, 2005), (double[])this.lookup.getCorrectedFluxFor(176, 2005), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.computeCorrectedFlux(200, 2005), (double[])this.lookup.getCorrectedFluxFor(200, 2005), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.computeCorrectedFlux(250, 2005), (double[])this.lookup.getCorrectedFluxFor(250, 2005), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.computeCorrectedFlux(300, 2005), (double[])this.lookup.getCorrectedFluxFor(300, 2005), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.computeCorrectedFlux(325, 2005), (double[])this.lookup.getCorrectedFluxFor(325, 2005), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.computeCorrectedFlux(365, 2005), (double[])this.lookup.getCorrectedFluxFor(365, 2005), (double)1.0E-12);
    }

    @Test
    public void testEqualValuesForDifferentNoneLeapYears() {
        Assert.assertArrayEquals((double[])this.lookup.getCorrectedFluxFor(0, 2007), (double[])this.lookup.getCorrectedFluxFor(0, 2005), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.lookup.getCorrectedFluxFor(23, 2007), (double[])this.lookup.getCorrectedFluxFor(23, 2005), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.lookup.getCorrectedFluxFor(50, 2007), (double[])this.lookup.getCorrectedFluxFor(50, 2005), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.lookup.getCorrectedFluxFor(77, 2007), (double[])this.lookup.getCorrectedFluxFor(77, 2005), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.lookup.getCorrectedFluxFor(100, 2006), (double[])this.lookup.getCorrectedFluxFor(100, 2005), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.lookup.getCorrectedFluxFor(119, 2006), (double[])this.lookup.getCorrectedFluxFor(119, 2005), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.lookup.getCorrectedFluxFor(150, 2006), (double[])this.lookup.getCorrectedFluxFor(150, 2005), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.lookup.getCorrectedFluxFor(176, 2006), (double[])this.lookup.getCorrectedFluxFor(176, 2005), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.lookup.getCorrectedFluxFor(200, 2006), (double[])this.lookup.getCorrectedFluxFor(200, 2005), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.lookup.getCorrectedFluxFor(250, 2006), (double[])this.lookup.getCorrectedFluxFor(250, 2005), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.lookup.getCorrectedFluxFor(300, 2006), (double[])this.lookup.getCorrectedFluxFor(300, 2005), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.lookup.getCorrectedFluxFor(325, 2006), (double[])this.lookup.getCorrectedFluxFor(325, 2005), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.lookup.getCorrectedFluxFor(365, 2006), (double[])this.lookup.getCorrectedFluxFor(365, 2005), (double)1.0E-12);
    }

    @Test
    public void testSameArrayInstanceForDifferentNoneLeapYears() {
        Assert.assertSame((Object)this.lookup.getCorrectedFluxFor(0, 2010), (Object)this.lookup.getCorrectedFluxFor(0, 2009));
        Assert.assertSame((Object)this.lookup.getCorrectedFluxFor(23, 2010), (Object)this.lookup.getCorrectedFluxFor(23, 2009));
        Assert.assertSame((Object)this.lookup.getCorrectedFluxFor(50, 2010), (Object)this.lookup.getCorrectedFluxFor(50, 2009));
        Assert.assertSame((Object)this.lookup.getCorrectedFluxFor(77, 2010), (Object)this.lookup.getCorrectedFluxFor(77, 2009));
        Assert.assertSame((Object)this.lookup.getCorrectedFluxFor(100, 2001), (Object)this.lookup.getCorrectedFluxFor(100, 2009));
        Assert.assertSame((Object)this.lookup.getCorrectedFluxFor(119, 2001), (Object)this.lookup.getCorrectedFluxFor(119, 2009));
        Assert.assertSame((Object)this.lookup.getCorrectedFluxFor(150, 2001), (Object)this.lookup.getCorrectedFluxFor(150, 2009));
        Assert.assertSame((Object)this.lookup.getCorrectedFluxFor(176, 2001), (Object)this.lookup.getCorrectedFluxFor(176, 2009));
        Assert.assertSame((Object)this.lookup.getCorrectedFluxFor(200, 2001), (Object)this.lookup.getCorrectedFluxFor(200, 2009));
        Assert.assertSame((Object)this.lookup.getCorrectedFluxFor(250, 2001), (Object)this.lookup.getCorrectedFluxFor(250, 2009));
        Assert.assertSame((Object)this.lookup.getCorrectedFluxFor(300, 2001), (Object)this.lookup.getCorrectedFluxFor(300, 2009));
        Assert.assertSame((Object)this.lookup.getCorrectedFluxFor(325, 2001), (Object)this.lookup.getCorrectedFluxFor(325, 2009));
        Assert.assertSame((Object)this.lookup.getCorrectedFluxFor(365, 2001), (Object)this.lookup.getCorrectedFluxFor(365, 2009));
    }

    @Test
    public void testRightValuesForLeapYear() {
        Assert.assertArrayEquals((double[])this.computeCorrectedFlux(0, 2004), (double[])this.lookup.getCorrectedFluxFor(0, 2004), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.computeCorrectedFlux(23, 2004), (double[])this.lookup.getCorrectedFluxFor(23, 2004), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.computeCorrectedFlux(50, 2004), (double[])this.lookup.getCorrectedFluxFor(50, 2004), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.computeCorrectedFlux(77, 2004), (double[])this.lookup.getCorrectedFluxFor(77, 2004), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.computeCorrectedFlux(100, 2004), (double[])this.lookup.getCorrectedFluxFor(100, 2004), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.computeCorrectedFlux(119, 2004), (double[])this.lookup.getCorrectedFluxFor(119, 2004), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.computeCorrectedFlux(150, 2004), (double[])this.lookup.getCorrectedFluxFor(150, 2004), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.computeCorrectedFlux(176, 2004), (double[])this.lookup.getCorrectedFluxFor(176, 2004), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.computeCorrectedFlux(200, 2004), (double[])this.lookup.getCorrectedFluxFor(200, 2004), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.computeCorrectedFlux(250, 2004), (double[])this.lookup.getCorrectedFluxFor(250, 2004), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.computeCorrectedFlux(300, 2004), (double[])this.lookup.getCorrectedFluxFor(300, 2004), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.computeCorrectedFlux(325, 2004), (double[])this.lookup.getCorrectedFluxFor(325, 2004), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.computeCorrectedFlux(365, 2004), (double[])this.lookup.getCorrectedFluxFor(365, 2004), (double)1.0E-12);
    }

    @Test
    public void testEqualValuesForDifferentLeapYears() {
        Assert.assertArrayEquals((double[])this.lookup.getCorrectedFluxFor(0, 2008), (double[])this.lookup.getCorrectedFluxFor(0, 2004), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.lookup.getCorrectedFluxFor(23, 2008), (double[])this.lookup.getCorrectedFluxFor(23, 2004), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.lookup.getCorrectedFluxFor(50, 2008), (double[])this.lookup.getCorrectedFluxFor(50, 2004), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.lookup.getCorrectedFluxFor(77, 2008), (double[])this.lookup.getCorrectedFluxFor(77, 2004), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.lookup.getCorrectedFluxFor(100, 2012), (double[])this.lookup.getCorrectedFluxFor(100, 2004), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.lookup.getCorrectedFluxFor(119, 2012), (double[])this.lookup.getCorrectedFluxFor(119, 2004), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.lookup.getCorrectedFluxFor(150, 2012), (double[])this.lookup.getCorrectedFluxFor(150, 2004), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.lookup.getCorrectedFluxFor(176, 2012), (double[])this.lookup.getCorrectedFluxFor(176, 2004), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.lookup.getCorrectedFluxFor(200, 2012), (double[])this.lookup.getCorrectedFluxFor(200, 2004), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.lookup.getCorrectedFluxFor(250, 2012), (double[])this.lookup.getCorrectedFluxFor(250, 2004), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.lookup.getCorrectedFluxFor(300, 2012), (double[])this.lookup.getCorrectedFluxFor(300, 2004), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.lookup.getCorrectedFluxFor(325, 2012), (double[])this.lookup.getCorrectedFluxFor(325, 2004), (double)1.0E-12);
        Assert.assertArrayEquals((double[])this.lookup.getCorrectedFluxFor(365, 2012), (double[])this.lookup.getCorrectedFluxFor(365, 2004), (double)1.0E-12);
    }

    @Test
    public void testSameArrayInstanceForDifferentLeapYears() {
        Assert.assertSame((Object)this.lookup.getCorrectedFluxFor(0, 2008), (Object)this.lookup.getCorrectedFluxFor(0, 2004));
        Assert.assertSame((Object)this.lookup.getCorrectedFluxFor(23, 2008), (Object)this.lookup.getCorrectedFluxFor(23, 2004));
        Assert.assertSame((Object)this.lookup.getCorrectedFluxFor(50, 2008), (Object)this.lookup.getCorrectedFluxFor(50, 2004));
        Assert.assertSame((Object)this.lookup.getCorrectedFluxFor(77, 2008), (Object)this.lookup.getCorrectedFluxFor(77, 2004));
        Assert.assertSame((Object)this.lookup.getCorrectedFluxFor(100, 2012), (Object)this.lookup.getCorrectedFluxFor(100, 2004));
        Assert.assertSame((Object)this.lookup.getCorrectedFluxFor(119, 2012), (Object)this.lookup.getCorrectedFluxFor(119, 2004));
        Assert.assertSame((Object)this.lookup.getCorrectedFluxFor(150, 2012), (Object)this.lookup.getCorrectedFluxFor(150, 2004));
        Assert.assertSame((Object)this.lookup.getCorrectedFluxFor(176, 2012), (Object)this.lookup.getCorrectedFluxFor(176, 2004));
        Assert.assertSame((Object)this.lookup.getCorrectedFluxFor(200, 2012), (Object)this.lookup.getCorrectedFluxFor(200, 2004));
        Assert.assertSame((Object)this.lookup.getCorrectedFluxFor(250, 2012), (Object)this.lookup.getCorrectedFluxFor(250, 2004));
        Assert.assertSame((Object)this.lookup.getCorrectedFluxFor(300, 2012), (Object)this.lookup.getCorrectedFluxFor(300, 2004));
        Assert.assertSame((Object)this.lookup.getCorrectedFluxFor(325, 2012), (Object)this.lookup.getCorrectedFluxFor(325, 2004));
        Assert.assertSame((Object)this.lookup.getCorrectedFluxFor(365, 2012), (Object)this.lookup.getCorrectedFluxFor(365, 2004));
    }

    private double[] computeCorrectedFlux(int doy, int year) {
        double correctionFactor = SolarFluxCorrectionFactorCalculator.getDayCorrectionFactorFor((int)doy, (int)year);
        double[] solFlux = this.lookup.solFlux;
        double[] corrected = new double[solFlux.length];
        for (int i = 0; i < solFlux.length; ++i) {
            double v = solFlux[i];
            corrected[i] = v * correctionFactor;
        }
        return corrected;
    }
}

