/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.c2rcc.landsat;

import java.util.Date;
import org.esa.s3tbx.c2rcc.landsat.C2rccLandsat7Operator;
import org.esa.s3tbx.c2rcc.landsat.C2rccLandsat8Operator;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class Landsat7ProductSignatureTest {
    private static final String[] EXPECTED_RHOW_BANDS = new String[]{"rhow_1", "rhow_2", "rhow_3", "rhow_4"};
    private static final String[] EXPECTED_RRS_BANDS = new String[]{"rrs_1", "rrs_2", "rrs_3", "rrs_4"};
    private static final String[] EXPECTED_NORM_REFLEC_BANDS = new String[]{"rhown_1", "rhown_2", "rhown_3", "rhown_4"};
    private static final String EXPECTED_IOP_APIG = "iop_apig";
    private static final String EXPECTED_IOP_ADET = "iop_adet";
    private static final String EXPECTED_IOP_AGELB = "iop_agelb";
    private static final String EXPECTED_IOP_BPART = "iop_bpart";
    private static final String EXPECTED_IOP_BWIT = "iop_bwit";
    private static final String EXPECTED_IOP_ADG = "iop_adg";
    private static final String EXPECTED_IOP_ATOT = "iop_atot";
    private static final String EXPECTED_IOP_BTOT = "iop_btot";
    private static final String EXPECTED_CONC_CHL = "conc_chl";
    private static final String EXPECTED_CONC_TSM = "conc_tsm";
    private static final String[] EXPECTED_KD_BANDS = new String[]{"kd489", "kdmin", "kd_z90max"};
    private static final String EXPECTED_OOS_RTOSA = "oos_rtosa";
    private static final String EXPECTED_OOS_RHOW = "oos_rhow";
    private static final String EXPECTED_OOS_RRS = "oos_rrs";
    private static final String[] EXPECTED_IOP_UNC_BANDS = new String[]{"unc_apig", "unc_adet", "unc_agelb", "unc_bpart", "unc_bwit", "unc_adg", "unc_atot", "unc_btot"};
    private static final String[] EXPECTED_KD_UNC_BANDS = new String[]{"unc_kd489", "unc_kdmin"};
    private static final String[] EXPECTED_RTOSA_GC_BANDS = new String[]{"rtosa_gc_1", "rtosa_gc_2", "rtosa_gc_3", "rtosa_gc_4"};
    private static final String[] EXPECTED_RTOSA_GCAANN_BANDS = new String[]{"rtosagc_aann_1", "rtosagc_aann_2", "rtosagc_aann_3", "rtosagc_aann_4"};
    private static final String[] EXPECTED_RTOA_BANDS = new String[]{"rtoa_1", "rtoa_2", "rtoa_3", "rtoa_4"};
    private static final String[] EXPECTED_RPATH_BANDS = new String[]{"rpath_1", "rpath_2", "rpath_3", "rpath_4"};
    private static final String[] EXPECTED_TDOWN_BANDS = new String[]{"tdown_1", "tdown_2", "tdown_3", "tdown_4"};
    private static final String[] EXPECTED_TUP_BANDS = new String[]{"tup_1", "tup_2", "tup_3", "tup_4"};
    private static final String EXPECTED_SOURCE_FLAGS = "flags";
    private static final String EXPECTED_C2RCC_FLAGS = "c2rcc_flags";
    private static final String EXPECTED_PRODUCT_TYPE = "C2RCC_LANDSAT-7";

    @Test
    public void testProductSignature_Default() throws FactoryException, TransformException {
        C2rccLandsat7Operator operator = this.createDefaultOperator();
        Product targetProduct = operator.getTargetProduct();
        this.assertDefaults(targetProduct, false);
    }

    @Test
    public void testProductSignature_Default_Rrs() throws FactoryException, TransformException {
        C2rccLandsat7Operator operator = this.createDefaultOperator();
        operator.setOutputAsRrs(true);
        operator.setOutputOos(true);
        Product targetProduct = operator.getTargetProduct();
        this.assertDefaults(targetProduct, true);
        this.assertBands(targetProduct, EXPECTED_OOS_RTOSA);
        this.assertBands(targetProduct, EXPECTED_OOS_RRS);
    }

    @Test
    public void testProductSignature_OnlyMandatory() throws FactoryException, TransformException {
        C2rccLandsat7Operator operator = this.createDefaultOperator();
        operator.setOutputRtoa(false);
        operator.setOutputUncertainties(false);
        operator.setOutputAcReflectance(false);
        operator.setOutputRhown(false);
        operator.setOutputKd(false);
        Product targetProduct = operator.getTargetProduct();
        this.assertMandatoryBands(targetProduct);
        Assert.assertEquals((long)11L, (long)targetProduct.getNumBands());
    }

    @Test
    public void testProductSignature_DefaultWithRtosa() throws FactoryException, TransformException {
        C2rccLandsat7Operator operator = this.createDefaultOperator();
        operator.setOutputRtosa(true);
        operator.setOutputRtosaGcAann(true);
        Product targetProduct = operator.getTargetProduct();
        this.assertDefaults(targetProduct, false);
        this.assertBands(targetProduct, EXPECTED_RTOSA_GC_BANDS);
        this.assertBands(targetProduct, EXPECTED_RTOSA_GCAANN_BANDS);
    }

    @Test
    public void testProductSignature_DefaultWithRtoa() throws FactoryException, TransformException {
        C2rccLandsat7Operator operator = this.createDefaultOperator();
        operator.setOutputRtoa(true);
        Product targetProduct = operator.getTargetProduct();
        this.assertDefaults(targetProduct, false);
        this.assertBands(targetProduct, EXPECTED_RTOA_BANDS);
    }

    @Test
    public void testProductSignature_DefaultWithOthers() throws FactoryException, TransformException {
        C2rccLandsat7Operator operator = this.createDefaultOperator();
        operator.setOutputRpath(true);
        operator.setOutputTdown(true);
        operator.setOutputTup(true);
        operator.setOutputOos(true);
        Product targetProduct = operator.getTargetProduct();
        this.assertDefaults(targetProduct, false);
        this.assertBands(targetProduct, EXPECTED_RPATH_BANDS);
        this.assertBands(targetProduct, EXPECTED_TDOWN_BANDS);
        this.assertBands(targetProduct, EXPECTED_TUP_BANDS);
        this.assertBands(targetProduct, EXPECTED_OOS_RTOSA);
        this.assertBands(targetProduct, EXPECTED_OOS_RHOW);
    }

    @Test
    public void testProductSignature_DeriveRwAlternative() throws FactoryException, TransformException {
        C2rccLandsat7Operator operator = this.createDefaultOperator();
        operator.setDeriveRwFromPathAndTransmittance(true);
        Product targetProduct = operator.getTargetProduct();
        this.assertDefaults(targetProduct, false);
    }

    @Test
    public void testProductSignature_DefaultWithUncertainties() throws FactoryException, TransformException {
        C2rccLandsat7Operator operator = this.createDefaultOperator();
        operator.setOutputUncertainties(true);
        Product targetProduct = operator.getTargetProduct();
        this.assertDefaults(targetProduct, false);
        this.assertBands(targetProduct, EXPECTED_IOP_UNC_BANDS);
    }

    @Test
    public void testProductSignature_DefaultWithUncertaintiesAndKd() throws FactoryException, TransformException {
        C2rccLandsat7Operator operator = this.createDefaultOperator();
        operator.setOutputUncertainties(true);
        operator.setOutputKd(true);
        Product targetProduct = operator.getTargetProduct();
        this.assertDefaults(targetProduct, false);
        this.assertBands(targetProduct, EXPECTED_IOP_UNC_BANDS);
        this.assertBands(targetProduct, EXPECTED_KD_UNC_BANDS);
        this.assertBands(targetProduct, EXPECTED_KD_BANDS);
    }

    private void assertDefaults(Product targetProduct, boolean asRrs) {
        this.assertMandatoryBands(targetProduct);
        if (asRrs) {
            this.assertBands(targetProduct, EXPECTED_RRS_BANDS);
        } else {
            this.assertBands(targetProduct, EXPECTED_RHOW_BANDS);
        }
        this.assertBands(targetProduct, EXPECTED_RTOA_BANDS);
        this.assertBands(targetProduct, EXPECTED_NORM_REFLEC_BANDS);
        this.assertBands(targetProduct, EXPECTED_KD_BANDS);
        this.assertBands(targetProduct, EXPECTED_KD_UNC_BANDS);
        this.assertBands(targetProduct, EXPECTED_IOP_UNC_BANDS);
        Assert.assertEquals((Object)EXPECTED_PRODUCT_TYPE, (Object)targetProduct.getProductType());
    }

    private void assertMandatoryBands(Product targetProduct) {
        this.assertBands(targetProduct, EXPECTED_IOP_APIG);
        this.assertBands(targetProduct, EXPECTED_IOP_ADET);
        this.assertBands(targetProduct, EXPECTED_IOP_AGELB);
        this.assertBands(targetProduct, EXPECTED_IOP_BPART);
        this.assertBands(targetProduct, EXPECTED_IOP_BWIT);
        this.assertBands(targetProduct, EXPECTED_IOP_ADG);
        this.assertBands(targetProduct, EXPECTED_IOP_ATOT);
        this.assertBands(targetProduct, EXPECTED_IOP_BTOT);
        this.assertBands(targetProduct, EXPECTED_CONC_CHL);
        this.assertBands(targetProduct, EXPECTED_CONC_TSM);
        this.assertBands(targetProduct, EXPECTED_C2RCC_FLAGS);
    }

    private void assertBands(Product targetProduct, String ... expectedBands) {
        for (String expectedBand : expectedBands) {
            Assert.assertTrue((String)("Expected band " + expectedBand + " in product"), (boolean)targetProduct.containsBand(expectedBand));
        }
    }

    private C2rccLandsat7Operator createDefaultOperator() throws FactoryException, TransformException {
        C2rccLandsat7Operator operator = new C2rccLandsat7Operator();
        operator.setParameterDefaultValues();
        operator.setSourceProduct(this.createLandsat8TestProduct());
        return operator;
    }

    private Product createLandsat8TestProduct() throws FactoryException, TransformException {
        Product product = new Product("test-L7", "t", 1, 1);
        for (int i = 0; i < C2rccLandsat7Operator.L7_BAND_COUNT; ++i) {
            String expression = String.valueOf(i);
            product.addBand(C2rccLandsat7Operator.EXPECTED_BANDNAMES[i], expression);
        }
        MetadataElement metadataRoot = product.getMetadataRoot();
        MetadataElement l1MetadataFile = new MetadataElement("L1_METADATA_FILE");
        MetadataElement imageAttributes = new MetadataElement("IMAGE_ATTRIBUTES");
        imageAttributes.addAttribute(new MetadataAttribute("SUN_AZIMUTH", ProductData.createInstance((double[])new double[]{42.0}), true));
        imageAttributes.addAttribute(new MetadataAttribute("SUN_ELEVATION", ProductData.createInstance((double[])new double[]{10.0}), true));
        l1MetadataFile.addElement(imageAttributes);
        MetadataElement radiometricRescaling = new MetadataElement("RADIOMETRIC_RESCALING");
        for (int i = 0; i < C2rccLandsat8Operator.L8_BAND_COUNT; ++i) {
            radiometricRescaling.addAttribute(new MetadataAttribute(String.format("REFLECTANCE_ADD_BAND_%d", i + 1), ProductData.createInstance((double[])new double[]{0.1}), true));
            radiometricRescaling.addAttribute(new MetadataAttribute(String.format("REFLECTANCE_MULT_BAND_%d", i + 1), ProductData.createInstance((double[])new double[]{2.4}), true));
        }
        l1MetadataFile.addElement(radiometricRescaling);
        metadataRoot.addElement(l1MetadataFile);
        Date time = new Date();
        product.setStartTime(ProductData.UTC.create((Date)time, (long)0L));
        product.setEndTime(ProductData.UTC.create((Date)time, (long)500L));
        product.setSceneGeoCoding((GeoCoding)new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, 1, 1, 10.0, 50.0, 1.0, 1.0));
        return product;
    }
}

