/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.c2rcc.ancillary;

import junit.framework.Assert;
import org.esa.s3tbx.c2rcc.ancillary.DataInterpolator;
import org.esa.s3tbx.c2rcc.ancillary.DataInterpolatorStatic;
import org.esa.snap.core.datamodel.Product;
import org.junit.Before;
import org.junit.Test;

public class DataInterpolatorTest_ancillaryGap {
    private final double endTimeMJD = 25.5;
    private DataInterpolator di;
    private Product p1;
    private Product p2;
    private double startTimeMJD;

    @Before
    public void setUp() throws Exception {
        this.p1 = new Product("p1", "t1", 2, 2);
        this.p1.addBand("ozone", 31).setDataElems((Object)new double[]{3.0, 4.0, 5.0, 6.0});
        this.p2 = null;
        this.startTimeMJD = 24.5;
        double defaultValue = 15.0;
        this.di = new DataInterpolatorStatic(this.startTimeMJD, 25.5, this.p1, this.p2, "ozone", 15.0);
    }

    @Test
    public void testInitializing() {
        Assert.assertNull((Object)this.p1.getSceneGeoCoding());
    }

    @Test
    public void testGetStartTimeValue() throws Exception {
        Assert.assertEquals((Object)3.0, (Object)this.di.getValue(this.startTimeMJD, 45.0, -90.0));
        Assert.assertEquals((Object)4.0, (Object)this.di.getValue(this.startTimeMJD, 45.0, 90.0));
        Assert.assertEquals((Object)5.0, (Object)this.di.getValue(this.startTimeMJD, -45.0, -90.0));
        Assert.assertEquals((Object)6.0, (Object)this.di.getValue(this.startTimeMJD, -45.0, 90.0));
    }

    @Test
    public void testGetEndTimeValue() throws Exception {
        Assert.assertEquals((Object)15.0, (Object)this.di.getValue(25.5, 45.0, -90.0));
        Assert.assertEquals((Object)15.0, (Object)this.di.getValue(25.5, 45.0, 90.0));
        Assert.assertEquals((Object)15.0, (Object)this.di.getValue(25.5, -45.0, -90.0));
        Assert.assertEquals((Object)15.0, (Object)this.di.getValue(25.5, -45.0, 90.0));
    }

    @Test
    public void testGetCenterTimeValue() throws Exception {
        double centerTimeMJD = (25.5 - this.startTimeMJD) / 2.0 + this.startTimeMJD;
        Assert.assertEquals((Object)9.0, (Object)this.di.getValue(centerTimeMJD, 45.0, -90.0));
        Assert.assertEquals((Object)9.5, (Object)this.di.getValue(centerTimeMJD, 45.0, 90.0));
        Assert.assertEquals((Object)10.0, (Object)this.di.getValue(centerTimeMJD, -45.0, -90.0));
        Assert.assertEquals((Object)10.5, (Object)this.di.getValue(centerTimeMJD, -45.0, 90.0));
    }
}

