/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.c2rcc.ancillary;

import junit.framework.Assert;
import org.esa.s3tbx.c2rcc.ancillary.DataInterpolator;
import org.esa.s3tbx.c2rcc.ancillary.DataInterpolatorStatic;
import org.esa.snap.core.datamodel.Product;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class DataInterpolatorStaticTest {
    private final double endTimeMJD = 25.5;
    private DataInterpolator di;
    private Product p1;
    private Product p2;
    private double startTimeMJD;

    @Before
    public void setUp() throws Exception {
        this.p1 = new Product("p1", "t1", 2, 2);
        this.p1.addBand("ozone", 31).setDataElems((Object)new double[]{3.0, 4.0, 5.0, 6.0});
        this.p2 = new Product("p2", "t1", 2, 2);
        this.p2.addBand("ozone", 31).setDataElems((Object)new double[]{8.0, 11.2, 2.7, 12.25});
        this.startTimeMJD = 24.5;
        this.di = new DataInterpolatorStatic(this.startTimeMJD, 25.5, this.p1, this.p2, "ozone", 123.0);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testInitializing() {
        Assert.assertNull((Object)this.p1.getSceneGeoCoding());
        Assert.assertNull((Object)this.p2.getSceneGeoCoding());
    }

    @Test
    public void testGetStartTimeValue() throws Exception {
        Assert.assertEquals((Object)3.0, (Object)this.di.getValue(this.startTimeMJD, 45.0, -90.0));
        Assert.assertEquals((Object)4.0, (Object)this.di.getValue(this.startTimeMJD, 45.0, 90.0));
        Assert.assertEquals((Object)5.0, (Object)this.di.getValue(this.startTimeMJD, -45.0, -90.0));
        Assert.assertEquals((Object)6.0, (Object)this.di.getValue(this.startTimeMJD, -45.0, 90.0));
    }

    @Test
    public void testGetEndTimeValue() throws Exception {
        Assert.assertEquals((Object)8.0, (Object)this.di.getValue(25.5, 45.0, -90.0));
        Assert.assertEquals((Object)11.2, (Object)this.di.getValue(25.5, 45.0, 90.0));
        Assert.assertEquals((Object)2.7, (Object)this.di.getValue(25.5, -45.0, -90.0));
        Assert.assertEquals((Object)12.25, (Object)this.di.getValue(25.5, -45.0, 90.0));
    }

    @Test
    public void testGetCenterTimeValue() throws Exception {
        double centerTimeMJD = (25.5 - this.startTimeMJD) / 2.0 + this.startTimeMJD;
        Assert.assertEquals((Object)5.5, (Object)this.di.getValue(centerTimeMJD, 45.0, -90.0));
        Assert.assertEquals((Object)7.6, (Object)this.di.getValue(centerTimeMJD, 45.0, 90.0));
        Assert.assertEquals((Object)3.85, (Object)this.di.getValue(centerTimeMJD, -45.0, -90.0));
        Assert.assertEquals((Object)9.125, (Object)this.di.getValue(centerTimeMJD, -45.0, 90.0));
    }
}

