/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.c2rcc.ancillary;

import java.util.Calendar;
import org.esa.s3tbx.c2rcc.ancillary.AtmosphericAuxdataStatic;
import org.junit.Assert;
import org.junit.Test;

public class AtmosphericAuxdataStaticTest {
    @Test
    public void createCalendarByFilename() throws Exception {
        Calendar calendar = AtmosphericAuxdataStatic.createCalendarByFilename((String)"N201519412_O3_AURAOMI_24h.hdf");
        this.verifyCalendar(calendar, 194, 2015, 6, 13, 12);
        calendar = AtmosphericAuxdataStatic.createCalendarByFilename((String)"N201606006_O3_AURAOMI_24h.hdf");
        this.verifyCalendar(calendar, 60, 2016, 1, 29, 6);
        calendar = AtmosphericAuxdataStatic.createCalendarByFilename((String)"N201606108_O3_AURAOMI_24h.hdf");
        this.verifyCalendar(calendar, 61, 2016, 2, 1, 8);
    }

    private void verifyCalendar(Calendar calendar, int doy, int year, int month, int dayOfMonth, int hour) {
        Assert.assertEquals((long)doy, (long)calendar.get(6));
        Assert.assertEquals((long)year, (long)calendar.get(1));
        Assert.assertEquals((long)month, (long)calendar.get(2));
        Assert.assertEquals((long)dayOfMonth, (long)calendar.get(5));
        Assert.assertEquals((long)hour, (long)calendar.get(11));
        Assert.assertEquals((long)0L, (long)calendar.get(12));
        Assert.assertEquals((long)0L, (long)calendar.get(13));
        Assert.assertEquals((long)0L, (long)calendar.get(14));
    }
}

