/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.avhrr.noaa.pod;

import com.bc.ceres.binio.SequenceData;
import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import org.esa.s3tbx.dataio.avhrr.BandReader;
import org.esa.s3tbx.dataio.avhrr.calibration.Calibrator;
import org.esa.s3tbx.dataio.avhrr.noaa.pod.CalibratorFactory;
import org.esa.s3tbx.dataio.avhrr.noaa.pod.VideoDataProvider;
import org.esa.snap.core.datamodel.ProductData;

final class PodBandReader
implements BandReader {
    private static final int POINTS_PER_SCAN = 2048;
    private static final int WORDS_PER_SCAN = 3414;
    private static final int TEN_BITS = 1023;
    private static final int[] FIRST = new int[]{0, 0, 0, 1, 1};
    private static final int[][] INCREMENT = new int[][]{{1, 2, 2}, {2, 1, 2}, {2, 2, 1}, {1, 2, 2}, {2, 1, 2}};
    private static final int[][] SHIFT = new int[][]{{20, 0, 10}, {10, 20, 0}, {0, 10, 20}, {20, 0, 10}, {10, 20, 0}};
    private final VideoDataProvider videoDataProvider;
    private final int channelIndex;
    private final CalibratorFactory calibratorFactory;

    public PodBandReader(int channelIndex, VideoDataProvider videoDataProvider, CalibratorFactory calibratorFactory) {
        this.channelIndex = channelIndex;
        this.videoDataProvider = videoDataProvider;
        this.calibratorFactory = calibratorFactory;
    }

    @Override
    public String getBandName() {
        return this.calibratorFactory.getBandName();
    }

    @Override
    public String getBandUnit() {
        return this.calibratorFactory.getBandUnit();
    }

    @Override
    public String getBandDescription() {
        return this.calibratorFactory.getBandDescription();
    }

    @Override
    public double getScalingFactor() {
        return 1.0;
    }

    @Override
    public int getDataType() {
        return 30;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readBandRasterData(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, ProductData targetBuffer, ProgressMonitor pm) throws IOException {
        int minX = sourceOffsetX;
        int maxX = sourceOffsetX + sourceWidth - 1;
        int minY = sourceOffsetY;
        int maxY = sourceOffsetY + sourceHeight - 1;
        boolean targetStart = false;
        boolean targetIncrement = true;
        float[] targetData = (float[])targetBuffer.getElems();
        int[] videoData = new int[3414];
        int[] countData = new int[2048];
        int targetIdx = 0;
        pm.beginTask("Reading AVHRR band '" + this.getBandName() + "'...", maxY - minY);
        try {
            for (int y = minY; y <= maxY; y += sourceStepY) {
                if (pm.isCanceled()) {
                    break;
                }
                boolean valid = this.videoDataProvider.isValid(y);
                if (valid) {
                    this.readVideoData(y, videoData);
                    this.decodeVideoData(this.channelIndex, videoData, countData);
                    try {
                        Calibrator calibrator = this.calibratorFactory.createCalibrator(y);
                        for (int x = minX; x <= maxX; x += sourceStepX) {
                            targetData[targetIdx] = calibrator.calibrate(countData[x]);
                            ++targetIdx;
                        }
                    }
                    catch (IOException e) {
                        valid = false;
                    }
                }
                if (!valid) {
                    for (int x = minX; x <= maxX; x += sourceStepX) {
                        targetData[targetIdx] = Float.NaN;
                        ++targetIdx;
                    }
                }
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
    }

    private void readVideoData(int y, int[] videoData) throws IOException {
        SequenceData videoDataSequence = this.videoDataProvider.getVideoData(y);
        for (int i = 0; i < videoDataSequence.getElementCount(); ++i) {
            videoData[i] = videoDataSequence.getInt(i);
        }
    }

    private void decodeVideoData(int channelIndex, int[] videoData, int[] countData) {
        int[] shifts = SHIFT[channelIndex];
        int[] increments = INCREMENT[channelIndex];
        int j = 0;
        int rawIndex = FIRST[channelIndex];
        for (int i = 0; i < countData.length; ++i) {
            countData[i] = (videoData[rawIndex] & 1023 << shifts[j]) >> shifts[j];
            rawIndex += increments[j];
            if (j == 2) {
                j = 0;
                continue;
            }
            ++j;
        }
    }
}

