/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.avhrr.noaa;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.SequenceData;
import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import org.esa.s3tbx.dataio.avhrr.AvhrrFile;
import org.esa.s3tbx.dataio.avhrr.BandReader;
import org.esa.s3tbx.dataio.avhrr.noaa.KlmAvhrrFile;
import org.esa.s3tbx.dataio.avhrr.noaa.ProductFormat;
import org.esa.snap.core.datamodel.ProductData;

class CloudReader
implements BandReader {
    private KlmAvhrrFile noaaFile;
    private byte[] rawBuffer;
    private byte[] flagBuffer;

    public CloudReader(KlmAvhrrFile noaaFile) {
        this.noaaFile = noaaFile;
        ProductFormat productFormat = noaaFile.getProductFormat();
        int dataWidth = productFormat.getProductDimension().getDataWidth();
        int cloudBytes = productFormat.getProductDimension().getCloudBytes();
        this.rawBuffer = new byte[cloudBytes];
        this.flagBuffer = new byte[dataWidth];
    }

    @Override
    public String getBandDescription() {
        return "CLAVR-x cloud mask";
    }

    @Override
    public String getBandName() {
        return "cloudFlag";
    }

    @Override
    public String getBandUnit() {
        return null;
    }

    @Override
    public int getDataType() {
        return 20;
    }

    @Override
    public double getScalingFactor() {
        return 1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void readBandRasterData(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        AvhrrFile.RawCoordinates rawCoord = this.noaaFile.getRawCoordinates(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight);
        byte[] flagsData = (byte[])destBuffer.getElems();
        pm.beginTask("Reading AVHRR band '" + this.getBandName() + "'...", rawCoord.maxY - rawCoord.minY);
        int targetIdx = rawCoord.targetStart;
        try {
            for (int sourceY = rawCoord.minY; sourceY <= rawCoord.maxY; sourceY += sourceStepY) {
                if (pm.isCanceled()) {
                    break;
                }
                if (this.hasClouds(sourceY)) {
                    this.readClouds(sourceY);
                    for (int sourceX = rawCoord.minX; sourceX <= rawCoord.maxX; sourceX += sourceStepX) {
                        flagsData[targetIdx] = this.flagBuffer[sourceX];
                        targetIdx += rawCoord.targetIncrement;
                    }
                }
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
    }

    private boolean hasClouds(int sourceY) throws IOException {
        CompoundData dataRecord = this.noaaFile.getDataRecord(sourceY);
        int cloudFlag = dataRecord.getInt("CLAVR_STATUS_BIT_FIELD");
        return cloudFlag == 1;
    }

    private void readClouds(int sourceY) throws IOException {
        int i;
        CompoundData dataRecord = this.noaaFile.getDataRecord(sourceY);
        SequenceData ccm = dataRecord.getSequence("CCM");
        for (i = 0; i < this.rawBuffer.length; ++i) {
            this.rawBuffer[i] = ccm.getByte(i);
        }
        for (i = 0; i < this.flagBuffer.length; ++i) {
            this.flagBuffer[i] = (byte)(this.rawBuffer[i / 4] >> 3 - i % 4 & 3);
        }
    }
}

