/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.avhrr.metop;

import java.io.File;
import java.io.IOException;
import javax.imageio.stream.FileImageInputStream;
import org.esa.s3tbx.dataio.avhrr.AvhrrConstants;
import org.esa.s3tbx.dataio.avhrr.AvhrrReader;
import org.esa.s3tbx.dataio.avhrr.BandReader;
import org.esa.s3tbx.dataio.avhrr.metop.MetopFile;
import org.esa.s3tbx.dataio.avhrr.metop.MetopReaderPlugIn;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.dataop.maptransf.Datum;

public class MetopReader
extends AvhrrReader
implements AvhrrConstants {
    public MetopReader(ProductReaderPlugIn metopReaderPlugIn) {
        super(metopReaderPlugIn);
    }

    @Override
    protected Product readProductNodesImpl() throws IOException {
        File dataFile = MetopReaderPlugIn.getInputFile(this.getInput());
        try {
            FileImageInputStream imageInputStream = new FileImageInputStream(dataFile);
            this.avhrrFile = new MetopFile(imageInputStream);
            this.avhrrFile.readHeader();
            this.createProduct();
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
        this.product.setFileLocation(dataFile);
        return this.product;
    }

    @Override
    protected void addTiePointGrids() throws IOException {
        MetopFile metopFile = (MetopFile)this.avhrrFile;
        int tiePointSampleRate = metopFile.getNavSampleRate();
        int tiePointGridHeight = metopFile.getProductHeight() / tiePointSampleRate + 1;
        int tiePointGridWidth = metopFile.getNumNavPoints();
        String[] tiePointNames = this.avhrrFile.getTiePointNames();
        float[][] tiePointData = this.avhrrFile.getTiePointData();
        int numGrids = tiePointNames.length;
        TiePointGrid[] grid = new TiePointGrid[numGrids];
        for (int i = 0; i < grid.length; ++i) {
            grid[i] = this.createTiePointGrid(tiePointNames[i], tiePointGridWidth, tiePointGridHeight, 0.5, 0.5, tiePointSampleRate, tiePointSampleRate, tiePointData[i]);
            grid[i].setUnit("deg");
            this.product.addTiePointGrid(grid[i]);
        }
        this.addDeltaAzimuth(tiePointGridWidth, tiePointGridHeight, tiePointSampleRate);
        TiePointGeoCoding geoCoding = new TiePointGeoCoding(grid[numGrids - 2], grid[numGrids - 1], Datum.WGS_72);
        this.product.setSceneGeoCoding((GeoCoding)geoCoding);
    }

    @Override
    protected void addCloudBand() {
        if (this.avhrrFile.hasCloudBand()) {
            BandReader cloudReader = this.avhrrFile.createCloudBandReader();
            Band cloudBand = new Band(cloudReader.getBandName(), cloudReader.getDataType(), this.avhrrFile.getProductWidth(), this.avhrrFile.getProductHeight());
            FlagCoding fc = new FlagCoding(cloudReader.getBandName());
            fc.setDescription("Flag coding for CLOUD_INFORMATION");
            this.addFlagAndBitmaskDef(fc, "uniformity_test2", "Uniformity test (0='test failed' or 'clear'; 1='cloudy')", 15);
            this.addFlagAndBitmaskDef(fc, "uniformity_test1", "Uniformity test (0 ='test failed' or 'cloudy', 1='clear')", 14);
            this.addFlagAndBitmaskDef(fc, "t3_t5_test2", "T3-T5 test (0='test failed' or 'clear'; 1='cloudy')", 13);
            this.addFlagAndBitmaskDef(fc, "t3_t5_test1", "T3-T5 test (0 ='test failed' or 'cloudy', 1='clear')", 12);
            this.addFlagAndBitmaskDef(fc, "t4_t3_test2", "T4-T3 test (0='test failed' or 'clear'; 1='cloudy')", 11);
            this.addFlagAndBitmaskDef(fc, "t4_t3_test1", "T4-T3 test (0 ='test failed' or 'cloudy', 1='clear')", 10);
            this.addFlagAndBitmaskDef(fc, "t4_t5_test2", "T4-T5 test (0='test failed' or 'clear'; 1='cloudy')", 9);
            this.addFlagAndBitmaskDef(fc, "t4_t5_test1", "T4-T5 test (0 ='test failed' or 'cloudy', 1='clear')", 8);
            this.addFlagAndBitmaskDef(fc, "albedo_test2", "Albedo test (0='test failed' or 'clear'; 1='cloudy' or 'snow/ice covered')", 7);
            this.addFlagAndBitmaskDef(fc, "albedo_test1", "Albedo test (0 ='test failed' or 'cloudy', 1='clear' or 'snow/ice covered')", 6);
            this.addFlagAndBitmaskDef(fc, "t4_test2", "T4 test (0='test failed' or 'clear'; 1='cloudy' or 'snow/ice covered')", 5);
            this.addFlagAndBitmaskDef(fc, "t4_test1", "T4 test (0 ='test failed' or 'cloudy', 1='clear' or 'snow/ice covered')", 4);
            cloudBand.setSampleCoding((SampleCoding)fc);
            this.product.getFlagCodingGroup().add((ProductNode)fc);
            this.product.addBand(cloudBand);
            this.bandReaders.put(cloudBand, cloudReader);
        }
    }

    private void addDeltaAzimuth(int tiePointGridWidth, int tiePointGridHeight, int tiePointSampleRate) {
        float[] sunAzimuthTiePointData = this.product.getTiePointGrid("sun_azimuth").getTiePoints();
        float[] viewAzimuthTiePointData = this.product.getTiePointGrid("view_azimuth").getTiePoints();
        int numTiePoints = viewAzimuthTiePointData.length;
        float[] deltaAzimuthData = new float[numTiePoints];
        for (int i = 0; i < numTiePoints; ++i) {
            deltaAzimuthData[i] = (float)MetopReader.computeAda(viewAzimuthTiePointData[i], sunAzimuthTiePointData[i]);
        }
        TiePointGrid grid = this.createTiePointGrid("delta_azimuth", tiePointGridWidth, tiePointGridHeight, 0.5, 0.5, tiePointSampleRate, tiePointSampleRate, deltaAzimuthData);
        grid.setUnit("deg");
        this.product.addTiePointGrid(grid);
    }

    private static double computeAda(double vaa, double saa) {
        double ada = saa - vaa;
        if (ada <= -180.0) {
            ada += 360.0;
        } else if (ada > 180.0) {
            ada -= 360.0;
        }
        return ada;
    }

    public static boolean canOpenFile(File file) {
        try {
            return MetopFile.canOpenFile(file);
        }
        catch (IOException e) {
            return false;
        }
    }
}

