/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.avhrr.metop;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.esa.s3tbx.dataio.avhrr.AvhrrFile;
import org.esa.s3tbx.dataio.avhrr.BandReader;
import org.esa.s3tbx.dataio.avhrr.FlagReader;
import org.esa.s3tbx.dataio.avhrr.HeaderUtil;
import org.esa.s3tbx.dataio.avhrr.calibration.Radiance2TemperatureCalibrator;
import org.esa.s3tbx.dataio.avhrr.metop.AsciiRecord;
import org.esa.s3tbx.dataio.avhrr.metop.CalibratedBandReader;
import org.esa.s3tbx.dataio.avhrr.metop.CloudBandReader;
import org.esa.s3tbx.dataio.avhrr.metop.GenericRecordHeader;
import org.esa.s3tbx.dataio.avhrr.metop.GiadrRadiance;
import org.esa.s3tbx.dataio.avhrr.metop.InternalPointerRecord;
import org.esa.s3tbx.dataio.avhrr.metop.MainProductHeaderRecord;
import org.esa.s3tbx.dataio.avhrr.metop.MetopRad2ReflFactorCalibrator;
import org.esa.s3tbx.dataio.avhrr.metop.PlainBandReader;
import org.esa.s3tbx.dataio.avhrr.metop.SecondaryProductHeaderRecord;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;

class MetopFile
extends AvhrrFile {
    private static final int EXPECTED_PRODUCT_WIDTH = 2048;
    private static final int HIGH_PRECISION_SAMPLE_RATE = 20;
    private static final int LOW_PRECISION_SAMPLE_RATE = 40;
    private static final int LOW_PRECISION_TRIM_X = 24;
    private static final int HIGH_PRECISION_TRIM_X = 4;
    private static final int LOW_PRECISION_PRODUCT_WIDTH = 2001;
    private static final int HIGH_PRECISION_PRODUCT_WIDTH = 2041;
    private static final int LOW_PRECISION_TIE_POINT_WIDTH = 51;
    private static final int HIGH_PRECISION_TIE_POINT_WIDTH = 103;
    private static final int TIE_POINT_DIFFERENCE = 832;
    private static final int TIE_POINT_OFFSET = 20556;
    private static final int FLAG_OFFSET = 22204;
    private static final int FRAME_INDICATOR_OFFSET = 26580;
    private ImageInputStream inputStream;
    private GenericRecordHeader mphrHeader;
    private AsciiRecord mainProductHeaderRecord;
    private AsciiRecord secondaryProductHeaderRecord;
    private GiadrRadiance giadrRadiance;
    private int firstMdrOffset;
    private int mdrSize;
    private int numNavPoints;
    private int numTrimX;
    private ProductData.UTC startTime;
    private ProductData.UTC endTime;
    private MetadataElement geadrMetadata;
    private MetadataElement readerInfo;

    public MetopFile(ImageInputStream imageInputStream) {
        this.inputStream = imageInputStream;
        this.readerInfo = new MetadataElement("READER_INFO");
    }

    @Override
    public void readHeader() throws IOException {
        InternalPointerRecord internalPointerRecord;
        this.mphrHeader = new GenericRecordHeader();
        boolean correct = this.mphrHeader.readGenericRecordHeader(this.inputStream);
        if (!correct || this.mphrHeader.recordClass != GenericRecordHeader.RecordClass.MPHR || this.mphrHeader.instrumentGroup != GenericRecordHeader.InstrumentGroup.GENERIC || this.mphrHeader.recordSubclass != 0) {
            throw new IOException("Unsupported product: bad MPHR. RecordClass=" + (Object)((Object)this.mphrHeader.recordClass) + " InstrumentGroup=" + (Object)((Object)this.mphrHeader.instrumentGroup) + " RecordSubclass=" + this.mphrHeader.recordSubclass);
        }
        this.mainProductHeaderRecord = new MainProductHeaderRecord();
        this.mainProductHeaderRecord.readRecord(this.inputStream);
        if (this.mainProductHeaderRecord.getIntValue("TOTAL_SPHR") != 1) {
            throw new IOException("Unsupported Product: more than one SPHR.");
        }
        GenericRecordHeader sphrHeader = new GenericRecordHeader();
        correct = sphrHeader.readGenericRecordHeader(this.inputStream);
        if (!correct || sphrHeader.recordClass != GenericRecordHeader.RecordClass.SPHR || sphrHeader.instrumentGroup != GenericRecordHeader.InstrumentGroup.AVHRR_3 || sphrHeader.recordSubclass != 0) {
            throw new IOException("Unsupported product: bad SPHR. RecordClass=" + (Object)((Object)sphrHeader.recordClass) + " InstrumentGroup=" + (Object)((Object)sphrHeader.instrumentGroup) + " RecordSubclass=" + sphrHeader.recordSubclass);
        }
        this.secondaryProductHeaderRecord = new SecondaryProductHeaderRecord();
        this.secondaryProductHeaderRecord.readRecord(this.inputStream);
        if (this.secondaryProductHeaderRecord.getIntValue("EARTH_VIEWS_PER_SCANLINE") != 2048) {
            throw new IOException("Unsupported product: bad SPHR. EARTH_VIEWS_PER_SCANLINE is not 2048. Actual value: " + this.secondaryProductHeaderRecord.getIntValue("EARTH_VIEWS_PER_SCANLINE"));
        }
        int navSampleRate = this.secondaryProductHeaderRecord.getIntValue("NAV_SAMPLE_RATE");
        if (navSampleRate == 40) {
            this.numNavPoints = 51;
            this.numTrimX = 24;
            this.productWidth = 2001;
        } else if (navSampleRate == 20) {
            this.numNavPoints = 103;
            this.numTrimX = 4;
            this.productWidth = 2041;
        } else {
            throw new IOException("Unsupported product: bad SPHR. NAV_SAMPLE_RATE is: " + navSampleRate);
        }
        this.readerInfo.addAttribute(HeaderUtil.createAttribute("TRIM_LEFT", this.numTrimX, "pixel", "Number of pixel cut from the left of the product to match the tie-points."));
        this.readerInfo.addAttribute(HeaderUtil.createAttribute("TRIM_RIGHT", 2048 - this.numTrimX - this.productWidth, "pixel", "Number of pixel cut from the right of the product to match the tie-points."));
        ArrayList<InternalPointerRecord> iprs = new ArrayList<InternalPointerRecord>();
        do {
            internalPointerRecord = new InternalPointerRecord();
            internalPointerRecord.readRecord(this.inputStream);
            iprs.add(internalPointerRecord);
        } while (internalPointerRecord.targetRecordClass != GenericRecordHeader.RecordClass.MDR);
        for (InternalPointerRecord ipr : iprs) {
            if (ipr.targetRecordClass == GenericRecordHeader.RecordClass.GIADR) {
                if (ipr.targetRecordSubclass == 1) {
                    this.inputStream.seek(ipr.targetRecordOffset);
                    this.giadrRadiance = new GiadrRadiance();
                    this.giadrRadiance.readRecord(this.inputStream);
                    continue;
                }
                if (ipr.targetRecordSubclass != 2) continue;
                continue;
            }
            if (ipr.targetRecordClass == GenericRecordHeader.RecordClass.GEADR) {
                this.inputStream.seek(ipr.targetRecordOffset);
                GenericRecordHeader grh = new GenericRecordHeader();
                grh.readGenericRecordHeader(this.inputStream);
                byte[] geadrText = new byte[100];
                this.inputStream.read(geadrText);
                if (this.geadrMetadata == null) {
                    this.geadrMetadata = new MetadataElement("GEADR");
                }
                this.geadrMetadata.addAttribute(HeaderUtil.createAttribute(Integer.toString(grh.recordSubclass), new String(geadrText)));
                continue;
            }
            if (ipr.targetRecordClass != GenericRecordHeader.RecordClass.MDR) continue;
            this.firstMdrOffset = ipr.targetRecordOffset;
        }
        this.productHeight = this.mainProductHeaderRecord.getIntValue("TOTAL_MDR");
        int toSkip = this.checkMdrs(navSampleRate);
        this.analyzeFrameIndicator();
        this.readerInfo.addAttribute(HeaderUtil.createAttribute("TRIM_BOTTOM", toSkip, "pixel", "Number of lines cut from the end of the product to match the tie-points."));
    }

    @Override
    public String getProductName() {
        return this.mainProductHeaderRecord.getValue("PRODUCT_NAME");
    }

    @Override
    public ProductData.UTC getStartDate() {
        return this.startTime;
    }

    @Override
    public ProductData.UTC getEndDate() {
        return this.endTime;
    }

    @Override
    public void addMetaData(MetadataElement metadataRoot) {
        metadataRoot.addElement(this.mainProductHeaderRecord.getMetaData());
        metadataRoot.addElement(this.secondaryProductHeaderRecord.getMetaData());
        if (this.geadrMetadata != null) {
            metadataRoot.addElement(this.geadrMetadata);
        }
        metadataRoot.addElement(this.giadrRadiance.getMetaData());
        metadataRoot.addElement(this.readerInfo);
    }

    @Override
    public BandReader createVisibleRadianceBandReader(int channel) {
        return new PlainBandReader(channel, this, this.inputStream);
    }

    @Override
    public BandReader createIrRadianceBandReader(int channel) {
        return new PlainBandReader(channel, this, this.inputStream);
    }

    @Override
    public BandReader createReflectanceFactorBandReader(int channel) {
        MetopRad2ReflFactorCalibrator radianceCalibrator = new MetopRad2ReflFactorCalibrator(this.giadrRadiance.getSolarIrradiance(channel), 1.0);
        return new CalibratedBandReader(channel, this, this.inputStream, radianceCalibrator);
    }

    @Override
    public BandReader createIrTemperatureBandReader(int channel) {
        Radiance2TemperatureCalibrator radianceCalibrator = new Radiance2TemperatureCalibrator(this.giadrRadiance.getConstant1(channel), this.giadrRadiance.getConstant2(channel), this.giadrRadiance.getCentralWavenumber(channel));
        return new CalibratedBandReader(channel, this, this.inputStream, radianceCalibrator);
    }

    @Override
    public BandReader createFlagBandReader() {
        return new FlagReader(this, this.inputStream);
    }

    @Override
    public boolean hasCloudBand() {
        return true;
    }

    @Override
    public BandReader createCloudBandReader() {
        return new CloudBandReader(this, this.inputStream);
    }

    public int getNumNavPoints() {
        return this.numNavPoints;
    }

    public int getNavSampleRate() {
        return this.secondaryProductHeaderRecord.getIntValue("NAV_SAMPLE_RATE");
    }

    public int getNumTrimX() {
        return this.numTrimX;
    }

    @Override
    public String[] getTiePointNames() {
        return new String[]{"sun_zenith", "view_zenith", "sun_azimuth", "view_azimuth", "latitude", "longitude"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float[][] getTiePointData() throws IOException {
        int navSampleRate = this.getNavSampleRate();
        int gridHeight = this.getProductHeight() / navSampleRate + 1;
        int numNavPoints = this.getNumNavPoints();
        int numTiePoints = numNavPoints * gridHeight;
        float[][] tiePointData = new float[6][numTiePoints];
        int numRawAngles = numNavPoints * 4;
        int numRawLatLon = numNavPoints * 2;
        short[] rawAngles = new short[numRawAngles];
        int[] rawLatLon = new int[numRawLatLon];
        int targetIndex = 0;
        int targetIncr = 1;
        for (int scanLine = 0; scanLine < this.getProductHeight(); scanLine += navSampleRate) {
            int scanLineOffset = this.getScanLineOffset(scanLine);
            ImageInputStream imageInputStream = this.inputStream;
            synchronized (imageInputStream) {
                this.inputStream.seek(scanLineOffset + 20556);
                this.inputStream.readFully(rawAngles, 0, numRawAngles);
                this.inputStream.readFully(rawLatLon, 0, numRawLatLon);
            }
            for (int scanPoint = 0; scanPoint < numNavPoints; ++scanPoint) {
                tiePointData[0][targetIndex] = (float)rawAngles[scanPoint * 4] * 0.01f;
                tiePointData[1][targetIndex] = (float)rawAngles[scanPoint * 4 + 1] * 0.01f;
                tiePointData[2][targetIndex] = (float)rawAngles[scanPoint * 4 + 2] * 0.01f;
                tiePointData[3][targetIndex] = (float)rawAngles[scanPoint * 4 + 3] * 0.01f;
                tiePointData[4][targetIndex] = (float)rawLatLon[scanPoint * 2] * 1.0E-4f;
                tiePointData[5][targetIndex] = (float)rawLatLon[scanPoint * 2 + 1] * 1.0E-4f;
                targetIndex += targetIncr;
            }
        }
        return tiePointData;
    }

    @Override
    public int getScanLineOffset(int rawY) {
        return this.firstMdrOffset + rawY * this.mdrSize;
    }

    @Override
    public int getFlagOffset(int rawY) {
        int flagOffset = this.getScanLineOffset(rawY) + 22204;
        if (this.numNavPoints == 51) {
            flagOffset -= 832;
        }
        return flagOffset;
    }

    @Override
    public int getTiePointTrimX() {
        return 25;
    }

    @Override
    public int getTiePointSubsampling() {
        return 40;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readFrameIndicator(int rawY) throws IOException {
        byte flag;
        int flagOffset = this.getScanLineOffset(rawY) + 26580 + 1;
        if (this.numNavPoints == 51) {
            flagOffset -= 832;
        }
        ImageInputStream imageInputStream = this.inputStream;
        synchronized (imageInputStream) {
            this.inputStream.seek(flagOffset);
            flag = this.inputStream.readByte();
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canOpenFile(File file) throws IOException {
        try (FileImageInputStream inputStream = new FileImageInputStream(file);){
            GenericRecordHeader mphrHeader = new GenericRecordHeader();
            boolean correct = mphrHeader.readGenericRecordHeader(inputStream);
            if (!correct || mphrHeader.recordClass != GenericRecordHeader.RecordClass.MPHR || mphrHeader.instrumentGroup != GenericRecordHeader.InstrumentGroup.GENERIC || mphrHeader.recordSubclass != 0) {
                boolean bl = false;
                return bl;
            }
            inputStream.seek(mphrHeader.recordSize);
            GenericRecordHeader sphrHeader = new GenericRecordHeader();
            correct = sphrHeader.readGenericRecordHeader(inputStream);
            if (correct && sphrHeader.recordClass == GenericRecordHeader.RecordClass.SPHR && sphrHeader.instrumentGroup == GenericRecordHeader.InstrumentGroup.AVHRR_3 && sphrHeader.recordSubclass == 0) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private void analyzeFrameIndicator() throws IOException {
        int first = this.readFrameIndicator(0);
        int last = this.readFrameIndicator(this.getProductHeight() - 1);
        int firstChannel3ab = first & 1;
        int lastChannel3ab = last & 1;
        this.channel3ab = firstChannel3ab == 1 && lastChannel3ab == 1 ? 2 : (firstChannel3ab == 0 && lastChannel3ab == 0 ? 3 : -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkMdrs(int navSampleRate) throws IOException {
        int toSkip;
        GenericRecordHeader firstMdr = new GenericRecordHeader();
        ImageInputStream imageInputStream = this.inputStream;
        synchronized (imageInputStream) {
            this.inputStream.seek(this.firstMdrOffset);
            boolean correct = firstMdr.readGenericRecordHeader(this.inputStream);
            if (!correct) {
                throw new IllegalArgumentException("Bad GRH in first MDR.");
            }
        }
        this.startTime = firstMdr.recordStartTime;
        this.mdrSize = (int)firstMdr.recordSize;
        long fileSize = this.inputStream.length();
        long expectedFileSize = this.firstMdrOffset + this.productHeight * this.mdrSize;
        if (fileSize != expectedFileSize) {
            this.productHeight = (int)((fileSize - (long)this.firstMdrOffset) / (long)this.mdrSize);
        }
        if ((toSkip = this.productHeight % navSampleRate - 1) < 0) {
            toSkip += navSampleRate;
        }
        this.productHeight -= toSkip;
        GenericRecordHeader lastMdr = new GenericRecordHeader();
        ImageInputStream imageInputStream2 = this.inputStream;
        synchronized (imageInputStream2) {
            this.inputStream.seek(this.firstMdrOffset + (this.productHeight - 1) * this.mdrSize);
            boolean correct = lastMdr.readGenericRecordHeader(this.inputStream);
            if (!correct) {
                throw new IllegalArgumentException("Bad GRH in last MDR.");
            }
        }
        this.endTime = lastMdr.recordEndTime;
        return toSkip;
    }

    @Override
    public AvhrrFile.RawCoordinates getRawCoordinates(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight) {
        AvhrrFile.RawCoordinates coordinates = new AvhrrFile.RawCoordinates(this);
        if (this.northbound) {
            coordinates.minX = this.productWidth - sourceOffsetX - sourceWidth;
            coordinates.maxX = this.productWidth - sourceOffsetX - 1;
            coordinates.minY = this.productHeight - sourceOffsetY - sourceHeight;
            coordinates.maxY = this.productHeight - sourceOffsetY - 1;
            coordinates.targetStart = sourceWidth * sourceHeight - 1;
            coordinates.targetIncrement = -1;
        } else {
            coordinates.minX = sourceOffsetX;
            coordinates.maxX = sourceOffsetX + sourceWidth - 1;
            coordinates.minY = sourceOffsetY;
            coordinates.maxY = sourceOffsetY + sourceHeight - 1;
            coordinates.targetStart = 0;
            coordinates.targetIncrement = 1;
        }
        coordinates.minX += this.numTrimX;
        coordinates.maxX += this.numTrimX;
        return coordinates;
    }

    @Override
    public void dispose() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
    }
}

