/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.avhrr.metop;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.esa.s3tbx.dataio.avhrr.metop.AsciiRecord;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;

class MainProductHeaderRecord
extends AsciiRecord {
    private static final int NUM_FIELDS = 72;
    private static final DateFormat generalTimeFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
    private static final DateFormat longGeneralTimeFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS'Z'");

    public MainProductHeaderRecord() {
        super(72);
    }

    @Override
    public MetadataElement getMetaData() {
        MetadataElement element = new MetadataElement("MPH");
        element.addElement(this.getProductDetails());
        element.addElement(this.getAscendingNodeOrbitParameters());
        element.addElement(this.getLocationSummary());
        element.addElement(this.getLeapSecondInformation());
        element.addElement(this.getRecordCounts());
        element.addElement(this.getRecordBasedGenericQualityFlags());
        element.addElement(this.getTimeBasedGenericQualityFlags());
        element.addElement(this.getRegionalProductInformation());
        return element;
    }

    private MetadataElement getProductDetails() {
        MetadataElement element = new MetadataElement("PRODUCT_DETAILS");
        MetadataAttribute attribute = this.createStringAttribute("PRODUCT_NAME", null);
        attribute.setDescription("Complete name of the product");
        element.addAttribute(attribute);
        attribute = this.createStringAttribute("PARENT_PRODUCT_NAME_1", null);
        attribute.setDescription("Name of the parent product");
        element.addAttribute(attribute);
        attribute = this.createStringAttribute("PARENT_PRODUCT_NAME_2", null);
        attribute.setDescription("Name of the parent product");
        element.addAttribute(attribute);
        attribute = this.createStringAttribute("PARENT_PRODUCT_NAME_3", null);
        attribute.setDescription("Name of the parent product");
        element.addAttribute(attribute);
        attribute = this.createStringAttribute("PARENT_PRODUCT_NAME_4", null);
        attribute.setDescription("Name of the parent product");
        element.addAttribute(attribute);
        element.addAttribute(this.createStringAttribute("INSTRUMENT_ID", null));
        element.addAttribute(this.createStringAttribute("INSTRUMENT_MODEL", null));
        element.addAttribute(this.createStringAttribute("PRODUCT_TYPE", null));
        element.addAttribute(this.createStringAttribute("PROCESSING_LEVEL", null));
        element.addAttribute(this.createStringAttribute("SPACECRAFT_ID", null));
        element.addAttribute(this.createDateAttribute("SENSING_START", generalTimeFormat));
        element.addAttribute(this.createDateAttribute("SENSING_END", generalTimeFormat));
        element.addAttribute(this.createDateAttribute("SENSING_START_THEORETICAL", generalTimeFormat));
        element.addAttribute(this.createDateAttribute("SENSING_END_THEORETICAL", generalTimeFormat));
        element.addAttribute(this.createStringAttribute("PROCESSING_CENTRE", null));
        element.addAttribute(this.createIntAttribute("PROCESSOR_MAJOR_VERSION", null));
        element.addAttribute(this.createIntAttribute("PROCESSOR_MINOR_VERSION", null));
        element.addAttribute(this.createIntAttribute("FORMAT_MAJOR_VERSION", null));
        element.addAttribute(this.createIntAttribute("FORMAT_MINOR_VERSION", null));
        element.addAttribute(this.createDateAttribute("PROCESSING_TIME_START", generalTimeFormat));
        element.addAttribute(this.createDateAttribute("PROCESSING_TIME_END", generalTimeFormat));
        element.addAttribute(this.createStringAttribute("PROCESSING_MODE", null));
        element.addAttribute(this.createStringAttribute("DISPOSITION_MODE", null));
        element.addAttribute(this.createStringAttribute("RECEIVING_GROUND_STATION", null));
        element.addAttribute(this.createDateAttribute("RECEIVE_TIME_START", generalTimeFormat));
        element.addAttribute(this.createDateAttribute("RECEIVE_TIME_END", generalTimeFormat));
        attribute = this.createIntAttribute("ORBIT_START", null);
        attribute.setDescription("Start Orbit Number, counted incrementally since launch");
        element.addAttribute(attribute);
        attribute = this.createIntAttribute("ORBIT_END", null);
        attribute.setDescription("Stop Orbit Number");
        element.addAttribute(attribute);
        attribute = this.createIntAttribute("ACTUAL_PRODUCT_SIZE", "bytes");
        attribute.setDescription("Size of the complete product");
        element.addAttribute(attribute);
        return element;
    }

    private MetadataElement getAscendingNodeOrbitParameters() {
        MetadataElement element = new MetadataElement("ASCENDING_NODE_ORBIT_PARAMETERS");
        element.addAttribute(this.createDateAttribute("STATE_VECTOR_TIME", longGeneralTimeFormat));
        element.addAttribute(this.createStringAttribute("SEMI_MAJOR_AXIS", "mm"));
        element.addAttribute(this.createFloatAttribute("ECCENTRICITY", 1.0E-6f, null));
        element.addAttribute(this.createFloatAttribute("INCLINATION", 0.001f, "deg"));
        element.addAttribute(this.createFloatAttribute("PERIGEE_ARGUMENT", 0.001f, "deg"));
        element.addAttribute(this.createFloatAttribute("RIGHT_ASCENSION", 0.001f, "deg"));
        element.addAttribute(this.createFloatAttribute("MEAN_ANOMALY", 0.001f, "deg"));
        element.addAttribute(this.createFloatAttribute("X_POSITION", 0.001f, "m"));
        element.addAttribute(this.createFloatAttribute("Y_POSITION", 0.001f, "m"));
        element.addAttribute(this.createFloatAttribute("Z_POSITION", 0.001f, "m"));
        element.addAttribute(this.createFloatAttribute("X_VELOCITY", 0.001f, "m/s"));
        element.addAttribute(this.createFloatAttribute("Y_VELOCITY", 0.001f, "m/s"));
        element.addAttribute(this.createFloatAttribute("Z_VELOCITY", 0.001f, "m/s"));
        element.addAttribute(this.createIntAttribute("EARTH_SUN_DISTANCE_RATIO", null));
        element.addAttribute(this.createIntAttribute("LOCATION_TOLERANCE_RADIAL", "m"));
        element.addAttribute(this.createIntAttribute("LOCATION_TOLERANCE_CROSSTRACK", "m"));
        element.addAttribute(this.createIntAttribute("LOCATION_TOLERANCE_ALONGTRACK", "m"));
        element.addAttribute(this.createFloatAttribute("YAW_ERROR", 0.001f, "deg"));
        element.addAttribute(this.createFloatAttribute("ROLL_ERROR", 0.001f, "deg"));
        element.addAttribute(this.createFloatAttribute("PITCH_ERROR", 0.001f, "deg"));
        return element;
    }

    private MetadataElement getLocationSummary() {
        MetadataElement element = new MetadataElement("LOCATION_SUMMARY");
        element.addAttribute(this.createFloatAttribute("SUBSAT_LATITUDE_START", 0.001f, "deg"));
        element.addAttribute(this.createFloatAttribute("SUBSAT_LONGITUDE_START", 0.001f, "deg"));
        element.addAttribute(this.createFloatAttribute("SUBSAT_LATITUDE_END", 0.001f, "deg"));
        element.addAttribute(this.createFloatAttribute("SUBSAT_LONGITUDE_END", 0.001f, "deg"));
        return element;
    }

    private MetadataElement getLeapSecondInformation() {
        MetadataElement element = new MetadataElement("LEAP_SECOND_INFORMATION");
        element.addAttribute(this.createIntAttribute("LEAP_SECOND", null));
        element.addAttribute(this.createDateAttribute("LEAP_SECOND_UTC", generalTimeFormat));
        return element;
    }

    private MetadataElement getRecordCounts() {
        MetadataElement element = new MetadataElement("RECORD_COUNTS");
        element.addAttribute(this.createIntAttribute("TOTAL_RECORDS", null));
        element.addAttribute(this.createIntAttribute("TOTAL_MPHR", null));
        element.addAttribute(this.createIntAttribute("TOTAL_SPHR", null));
        element.addAttribute(this.createIntAttribute("TOTAL_IPR", null));
        element.addAttribute(this.createIntAttribute("TOTAL_GEADR", null));
        element.addAttribute(this.createIntAttribute("TOTAL_GIADR", null));
        element.addAttribute(this.createIntAttribute("TOTAL_VEADR", null));
        element.addAttribute(this.createIntAttribute("TOTAL_VIADR", null));
        element.addAttribute(this.createIntAttribute("TOTAL_MDR", null));
        return element;
    }

    private MetadataElement getRecordBasedGenericQualityFlags() {
        MetadataElement element = new MetadataElement("RECORD_BASED_GENERIC_QUALITY_FLAGS");
        element.addAttribute(this.createIntAttribute("COUNT_DEGRADED_INST_MDR", null));
        element.addAttribute(this.createIntAttribute("COUNT_DEGRADED_PROC_MDR", null));
        element.addAttribute(this.createIntAttribute("COUNT_DEGRADED_INST_MDR_BLOCKS", null));
        element.addAttribute(this.createIntAttribute("COUNT_DEGRADED_PROC_MDR_BLOCKS", null));
        return element;
    }

    private MetadataElement getTimeBasedGenericQualityFlags() {
        MetadataElement element = new MetadataElement("TIME_BASED_GENERIC_RECORD_FLAGS");
        element.addAttribute(this.createIntAttribute("DURATION_OF_PRODUCT", "ms"));
        element.addAttribute(this.createIntAttribute("MILLISECONDS_OF_DATA_PRESENT", "ms"));
        element.addAttribute(this.createIntAttribute("MILLISECONDS_OF_DATA_MISSING", "ms"));
        return element;
    }

    private MetadataElement getRegionalProductInformation() {
        MetadataElement element = new MetadataElement("REGIONAL_PRODUCT_INFORMATION");
        element.addAttribute(this.createStringAttribute("SUBSETTED_PRODUCT", null));
        return element;
    }
}

